/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.metric.SimpleCounter;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.SSLAuthTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerCnxnFactoryTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerCnxnFactoryTest.class);
    ClientX509Util x509Util;
    final LinkedBlockingQueue<ZooKeeper> zooKeeperClients = new LinkedBlockingQueue();

    @Override
    public void setUp() throws Exception {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
    }

    @Override
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.serverCnxnFactory");
        if (this.x509Util != null) {
            SSLAuthTest.clearSecureSetting(this.x509Util);
        }
        for (ZooKeeper zk : this.zooKeeperClients) {
            zk.close();
        }
        if (this.serverFactory != null) {
            super.tearDown();
        }
    }

    @Test
    public void testRebind() throws Exception {
        InetSocketAddress addr = new InetSocketAddress(PortAssignment.unique());
        NettyServerCnxnFactory factory = new NettyServerCnxnFactory();
        factory.configure(addr, 100, -1, false);
        factory.start();
        Assertions.assertTrue((boolean)factory.getParentChannel().isActive());
        factory.reconfigure(addr);
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)factory.getParentChannel().isActive());
    }

    @Test
    public void testRebindIPv4IPv6() throws Exception {
        int randomPort = PortAssignment.unique();
        InetSocketAddress addr = new InetSocketAddress("0.0.0.0", randomPort);
        NettyServerCnxnFactory factory = new NettyServerCnxnFactory();
        factory.configure(addr, 100, -1, false);
        factory.start();
        Assertions.assertTrue((boolean)factory.getParentChannel().isActive());
        factory.reconfigure(new InetSocketAddress("[0:0:0:0:0:0:0:0]", randomPort));
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)factory.getParentChannel().isActive());
    }

    @Test
    public void testOutstandingHandshakeLimit() throws Exception {
        this.x509Util = SSLAuthTest.setUpSecure();
        System.clearProperty("javax.net.debug");
        this.setUpWithServerId(1);
        SimpleCounter tlsHandshakeExceeded = (SimpleCounter)ServerMetrics.getMetrics().TLS_HANDSHAKE_EXCEEDED;
        tlsHandshakeExceeded.reset();
        Assertions.assertEquals((long)tlsHandshakeExceeded.get(), (long)0L);
        NettyServerCnxnFactory factory = (NettyServerCnxnFactory)this.serverFactory;
        factory.setSecure(true);
        factory.setOutstandingHandshakeLimit(3);
        int threadNum = 3;
        int cnxnPerThread = 3;
        int cnxnLimit = threadNum * cnxnPerThread;
        AtomicInteger cnxnCreated = new AtomicInteger(0);
        CountDownLatch latch = new CountDownLatch(1);
        Thread[] cnxnWorker = new Thread[threadNum];
        for (int i = 0; i < cnxnWorker.length; ++i) {
            cnxnWorker[i] = new ClientConnectionGenerator(i, cnxnPerThread, cnxnCreated, cnxnLimit, latch, this.zooKeeperClients);
            cnxnWorker[i].start();
        }
        boolean allConnectionsCreatedInTime = latch.await(30L, TimeUnit.SECONDS);
        int actualConnections = cnxnCreated.get();
        LOG.info("created {} connections", (Object)actualConnections);
        if (!allConnectionsCreatedInTime) {
            Assertions.fail((String)String.format("Only %d out of %d connections created!", actualConnections, cnxnLimit));
        }
        long handshakeThrottledNum = tlsHandshakeExceeded.get();
        LOG.info("TLS_HANDSHAKE_EXCEEDED: {}", (Object)handshakeThrottledNum);
        MatcherAssert.assertThat((String)"The number of handshake throttled should be greater than 0", (Object)handshakeThrottledNum, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        int outstandingHandshakeNum = factory.getOutstandingHandshakeNum();
        LOG.info("outstanding handshake is {}", (Object)outstandingHandshakeNum);
        MatcherAssert.assertThat((String)"The outstanding handshake number should be 0 after all cnxns established", (Object)outstandingHandshakeNum, (Matcher)Matchers.is((Object)0));
    }

    private final class ClientConnectionGenerator
    extends Thread {
        private final int cnxnThreadId;
        private final int cnxnPerThread;
        private final AtomicInteger cnxnCreated;
        private final int cnxnLimit;
        private final CountDownLatch latch;
        private final LinkedBlockingQueue<ZooKeeper> zks;

        private ClientConnectionGenerator(int cnxnThreadId, int cnxnPerThread, AtomicInteger cnxnCreated, int cnxnLimit, CountDownLatch latch, LinkedBlockingQueue<ZooKeeper> zks) {
            this.cnxnThreadId = cnxnThreadId;
            this.cnxnPerThread = cnxnPerThread;
            this.cnxnCreated = cnxnCreated;
            this.cnxnLimit = cnxnLimit;
            this.latch = latch;
            this.zks = zks;
        }

        @Override
        public void run() {
            for (int j = 0; j < this.cnxnPerThread; ++j) {
                try {
                    this.zks.add(new ZooKeeper(NettyServerCnxnFactoryTest.this.hostPort, 30000, (Watcher)new ClientConnectionWatcher(this.cnxnCreated, this.cnxnLimit, this.cnxnThreadId, j, this.latch)));
                    continue;
                }
                catch (Exception e) {
                    LOG.info("Error while creating zk client", (Throwable)e);
                }
            }
        }
    }

    private final class ClientConnectionWatcher
    implements Watcher {
        private final AtomicInteger cnxnCreated;
        private final int cnxnLimit;
        private final int cnxnThreadId;
        private final int cnxnId;
        private final CountDownLatch latch;

        public ClientConnectionWatcher(AtomicInteger cnxnCreated, int cnxnLimit, int cnxnThreadId, int cnxnId, CountDownLatch latch) {
            this.cnxnCreated = cnxnCreated;
            this.cnxnLimit = cnxnLimit;
            this.cnxnThreadId = cnxnThreadId;
            this.cnxnId = cnxnId;
            this.latch = latch;
        }

        public void process(WatchedEvent event) {
            int created;
            LOG.info(String.format("WATCHER [thread: %d, cnx:%d] - new event: %s", this.cnxnThreadId, this.cnxnId, event.toString()));
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected && (created = this.cnxnCreated.addAndGet(1)) == this.cnxnLimit) {
                this.latch.countDown();
            }
        }
    }
}

