/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.EnumSet;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.proto.WatcherEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WatchedEventTest
extends ZKTestCase {
    @Test
    public void testCreatingWatchedEvent() {
        EnumSet<Watcher.Event.EventType> allTypes = EnumSet.allOf(Watcher.Event.EventType.class);
        EnumSet<Watcher.Event.KeeperState> allStates = EnumSet.allOf(Watcher.Event.KeeperState.class);
        for (Watcher.Event.EventType et : allTypes) {
            for (Watcher.Event.KeeperState ks : allStates) {
                WatchedEvent we = new WatchedEvent(et, ks, "blah");
                Assertions.assertEquals((Object)et, (Object)we.getType());
                Assertions.assertEquals((Object)ks, (Object)we.getState());
                Assertions.assertEquals((Object)"blah", (Object)we.getPath());
            }
        }
    }

    @Test
    public void testCreatingWatchedEventFromWrapper() {
        EnumSet<Watcher.Event.EventType> allTypes = EnumSet.allOf(Watcher.Event.EventType.class);
        EnumSet<Watcher.Event.KeeperState> allStates = EnumSet.allOf(Watcher.Event.KeeperState.class);
        for (Watcher.Event.EventType et : allTypes) {
            for (Watcher.Event.KeeperState ks : allStates) {
                WatcherEvent wep = new WatcherEvent(et.getIntValue(), ks.getIntValue(), "blah");
                WatchedEvent we = new WatchedEvent(wep, -1L);
                Assertions.assertEquals((Object)et, (Object)we.getType());
                Assertions.assertEquals((Object)ks, (Object)we.getState());
                Assertions.assertEquals((Object)"blah", (Object)we.getPath());
            }
        }
    }

    @Test
    public void testCreatingWatchedEventFromInvalidWrapper() {
        try {
            WatcherEvent wep = new WatcherEvent(-2342, -252352, "foo");
            new WatchedEvent(wep, -1L);
            Assertions.fail((String)"Was able to create WatchedEvent from bad wrapper");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testConvertingToEventWrapper() {
        WatchedEvent we = new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.Expired, "blah");
        WatcherEvent wew = we.getWrapper();
        Assertions.assertEquals((int)Watcher.Event.EventType.NodeCreated.getIntValue(), (int)wew.getType());
        Assertions.assertEquals((int)Watcher.Event.KeeperState.Expired.getIntValue(), (int)wew.getState());
        Assertions.assertEquals((Object)"blah", (Object)wew.getPath());
    }
}

