/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class HelpWriter
extends HtmlDocletWriter {
    HtmlTree mainTree = HtmlTree.MAIN();

    public HelpWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPath.empty;
        try {
            filename = DocPaths.HELP_DOC;
            HelpWriter helpgen = new HelpWriter(configuration, filename);
            helpgen.generateHelpFile();
            helpgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void generateHelpFile() throws IOException {
        String title = this.configuration.getText("doclet.Window_Help_title");
        HtmlTree body = this.getBody(true, this.getWindowTitle(title));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : body;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            body.addContent(htmlTree);
        }
        this.addHelpFileContents(body);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            htmlTree = HtmlTree.FOOTER();
        }
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(htmlTree);
        }
        this.printHtmlDocument(null, true, body);
    }

    protected void addHelpFileContents(Content contentTree) {
        HtmlTree htmlTree;
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, this.getResource("doclet.Help_line_1"));
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        HtmlTree line2 = HtmlTree.DIV(HtmlStyle.subTitle, this.getResource("doclet.Help_line_2"));
        ((Content)div).addContent(line2);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
        } else {
            contentTree.addContent(div);
        }
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        if (this.configuration.createoverview) {
            HtmlTree overviewHeading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Overview"));
            htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(overviewHeading) : HtmlTree.LI(HtmlStyle.blockList, overviewHeading);
            Content line3 = this.getResource("doclet.Help_line_3", this.getHyperLink(DocPaths.OVERVIEW_SUMMARY, this.configuration.getText("doclet.Overview")));
            HtmlTree overviewPara = HtmlTree.P(line3);
            htmlTree.addContent(overviewPara);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
            } else {
                ul.addContent(htmlTree);
            }
        }
        HtmlTree packageHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Package"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(packageHead) : HtmlTree.LI(HtmlStyle.blockList, packageHead);
        Content line4 = this.getResource("doclet.Help_line_4");
        HtmlTree packagePara = HtmlTree.P(line4);
        htmlTree.addContent(packagePara);
        HtmlTree ulPackage = new HtmlTree(HtmlTag.UL);
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Interfaces_Italic")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Classes")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Enums")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Exceptions")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Errors")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.AnnotationTypes")));
        htmlTree.addContent(ulPackage);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        HtmlTree classHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_5"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(classHead) : HtmlTree.LI(HtmlStyle.blockList, classHead);
        Content line6 = this.getResource("doclet.Help_line_6");
        HtmlTree classPara = HtmlTree.P(line6);
        htmlTree.addContent(classPara);
        HtmlTree ul1 = new HtmlTree(HtmlTag.UL);
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_7")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_8")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_9")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_10")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_11")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_12")));
        htmlTree.addContent(ul1);
        HtmlTree ul2 = new HtmlTree(HtmlTag.UL);
        ul2.addContent(HtmlTree.LI(this.getResource("doclet.Nested_Class_Summary")));
        ul2.addContent(HtmlTree.LI(this.getResource("doclet.Field_Summary")));
        ul2.addContent(HtmlTree.LI(this.getResource("doclet.Constructor_Summary")));
        ul2.addContent(HtmlTree.LI(this.getResource("doclet.Method_Summary")));
        htmlTree.addContent(ul2);
        HtmlTree ul3 = new HtmlTree(HtmlTag.UL);
        ul3.addContent(HtmlTree.LI(this.getResource("doclet.Field_Detail")));
        ul3.addContent(HtmlTree.LI(this.getResource("doclet.Constructor_Detail")));
        ul3.addContent(HtmlTree.LI(this.getResource("doclet.Method_Detail")));
        htmlTree.addContent(ul3);
        Content line13 = this.getResource("doclet.Help_line_13");
        HtmlTree para = HtmlTree.P(line13);
        htmlTree.addContent(para);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        HtmlTree aHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.AnnotationType"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(aHead) : HtmlTree.LI(HtmlStyle.blockList, aHead);
        Content aline1 = this.getResource("doclet.Help_annotation_type_line_1");
        HtmlTree aPara = HtmlTree.P(aline1);
        htmlTree.addContent(aPara);
        HtmlTree aul = new HtmlTree(HtmlTag.UL);
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Help_annotation_type_line_2")));
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Help_annotation_type_line_3")));
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Annotation_Type_Required_Member_Summary")));
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Annotation_Type_Optional_Member_Summary")));
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Annotation_Type_Member_Detail")));
        htmlTree.addContent(aul);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        HtmlTree enumHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Enum"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(enumHead) : HtmlTree.LI(HtmlStyle.blockList, enumHead);
        Content eline1 = this.getResource("doclet.Help_enum_line_1");
        HtmlTree enumPara = HtmlTree.P(eline1);
        htmlTree.addContent(enumPara);
        HtmlTree eul = new HtmlTree(HtmlTag.UL);
        eul.addContent(HtmlTree.LI(this.getResource("doclet.Help_enum_line_2")));
        eul.addContent(HtmlTree.LI(this.getResource("doclet.Help_enum_line_3")));
        eul.addContent(HtmlTree.LI(this.getResource("doclet.Enum_Constant_Summary")));
        eul.addContent(HtmlTree.LI(this.getResource("doclet.Enum_Constant_Detail")));
        htmlTree.addContent(eul);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        if (this.configuration.classuse) {
            HtmlTree useHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_14"));
            htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(useHead) : HtmlTree.LI(HtmlStyle.blockList, useHead);
            Content line15 = this.getResource("doclet.Help_line_15");
            HtmlTree usePara = HtmlTree.P(line15);
            htmlTree.addContent(usePara);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
            } else {
                ul.addContent(htmlTree);
            }
        }
        if (this.configuration.createtree) {
            HtmlTree treeHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_16"));
            htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(treeHead) : HtmlTree.LI(HtmlStyle.blockList, treeHead);
            Content line17 = this.getResource("doclet.Help_line_17_with_tree_link", this.getHyperLink(DocPaths.OVERVIEW_TREE, this.configuration.getText("doclet.Class_Hierarchy")), HtmlTree.CODE(new StringContent("java.lang.Object")));
            HtmlTree treePara = HtmlTree.P(line17);
            htmlTree.addContent(treePara);
            HtmlTree tul = new HtmlTree(HtmlTag.UL);
            tul.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_18")));
            tul.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_19")));
            htmlTree.addContent(tul);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
            } else {
                ul.addContent(htmlTree);
            }
        }
        if (!this.configuration.nodeprecatedlist && !this.configuration.nodeprecated) {
            HtmlTree dHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Deprecated_API"));
            htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(dHead) : HtmlTree.LI(HtmlStyle.blockList, dHead);
            Content line20 = this.getResource("doclet.Help_line_20_with_deprecated_api_link", this.getHyperLink(DocPaths.DEPRECATED_LIST, this.configuration.getText("doclet.Deprecated_API")));
            HtmlTree dPara = HtmlTree.P(line20);
            htmlTree.addContent(dPara);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
            } else {
                ul.addContent(htmlTree);
            }
        }
        if (this.configuration.createindex) {
            Content indexlink = this.configuration.splitindex ? this.getHyperLink(DocPaths.INDEX_FILES.resolve(DocPaths.indexN(1)), this.configuration.getText("doclet.Index")) : this.getHyperLink(DocPaths.INDEX_ALL, this.configuration.getText("doclet.Index"));
            HtmlTree indexHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_21"));
            htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(indexHead) : HtmlTree.LI(HtmlStyle.blockList, indexHead);
            Content line22 = this.getResource("doclet.Help_line_22", indexlink);
            HtmlTree indexPara = HtmlTree.P(line22);
            htmlTree.addContent(indexPara);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
            } else {
                ul.addContent(htmlTree);
            }
        }
        HtmlTree prevHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_23"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(prevHead) : HtmlTree.LI(HtmlStyle.blockList, prevHead);
        Content line24 = this.getResource("doclet.Help_line_24");
        HtmlTree prevPara = HtmlTree.P(line24);
        htmlTree.addContent(prevPara);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        HtmlTree frameHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_25"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(frameHead) : HtmlTree.LI(HtmlStyle.blockList, frameHead);
        Content line26 = this.getResource("doclet.Help_line_26");
        HtmlTree framePara = HtmlTree.P(line26);
        htmlTree.addContent(framePara);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        HtmlTree allclassesHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.All_Classes"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(allclassesHead) : HtmlTree.LI(HtmlStyle.blockList, allclassesHead);
        Content line27 = this.getResource("doclet.Help_line_27", this.getHyperLink(DocPaths.ALLCLASSES_NOFRAME, this.configuration.getText("doclet.All_Classes")));
        HtmlTree allclassesPara = HtmlTree.P(line27);
        htmlTree.addContent(allclassesPara);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        HtmlTree sHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Serialized_Form"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(sHead) : HtmlTree.LI(HtmlStyle.blockList, sHead);
        Content line28 = this.getResource("doclet.Help_line_28");
        HtmlTree serialPara = HtmlTree.P(line28);
        htmlTree.addContent(serialPara);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        HtmlTree constHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Constants_Summary"));
        htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(constHead) : HtmlTree.LI(HtmlStyle.blockList, constHead);
        Content line29 = this.getResource("doclet.Help_line_29", this.getHyperLink(DocPaths.CONSTANT_VALUES, this.configuration.getText("doclet.Constants_Summary")));
        HtmlTree constPara = HtmlTree.P(line29);
        htmlTree.addContent(constPara);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
        } else {
            ul.addContent(htmlTree);
        }
        HtmlTree divContent = HtmlTree.DIV(HtmlStyle.contentContainer, ul);
        HtmlTree line30 = HtmlTree.SPAN(HtmlStyle.emphasizedPhrase, this.getResource("doclet.Help_line_30"));
        ((Content)divContent).addContent(line30);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(divContent);
            contentTree.addContent(this.mainTree);
        } else {
            contentTree.addContent(divContent);
        }
    }

    @Override
    protected Content getNavLinkHelp() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.helpLabel);
        return li;
    }
}

