/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor9;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.source.doctree.IndexTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ClassWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SearchIndexItem;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.RawHtml;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.SerializedFormBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocLink;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletConstants;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.MessageRetriever;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class TagletWriterImpl
extends TagletWriter {
    private final HtmlDocletWriter htmlWriter;
    private final ConfigurationImpl configuration;
    private final Utils utils;

    public TagletWriterImpl(HtmlDocletWriter htmlWriter, boolean isFirstSentence) {
        super(isFirstSentence);
        this.htmlWriter = htmlWriter;
        this.configuration = htmlWriter.configuration;
        this.utils = this.configuration.utils;
    }

    @Override
    public Content getOutputInstance() {
        return new ContentBuilder();
    }

    @Override
    protected Content codeTagOutput(Element element, DocTree tag) {
        CommentHelper ch = this.utils.getCommentHelper(element);
        StringContent content = new StringContent(this.utils.normalizeNewlines(ch.getText(tag)));
        HtmlTree result = HtmlTree.CODE(content);
        return result;
    }

    @Override
    protected Content indexTagOutput(final Element element, DocTree tag) {
        IndexTree itt;
        CommentHelper ch = this.utils.getCommentHelper(element);
        String tagText = ch.getText((itt = (IndexTree)tag).getSearchTerm());
        if (tagText.charAt(0) == '\"' && tagText.charAt(tagText.length() - 1) == '\"') {
            tagText = tagText.substring(1, tagText.length() - 1);
        }
        String desc = ch.getText(itt.getDescription());
        final String anchorName = this.htmlWriter.getName(tagText);
        HtmlTree result = HtmlTree.A_ID(anchorName, new StringContent(tagText));
        if (this.configuration.createindex && !tagText.isEmpty()) {
            final SearchIndexItem si = new SearchIndexItem();
            si.setLabel(tagText);
            si.setDescription(desc);
            new SimpleElementVisitor9<Void, Void>(){

                @Override
                public Void visitPackage(PackageElement e, Void p) {
                    si.setUrl(DocPath.forPackage(e).getPath() + "/" + DocPaths.PACKAGE_SUMMARY.getPath() + "#" + anchorName);
                    si.setHolder(TagletWriterImpl.this.utils.getSimpleName(element));
                    return null;
                }

                @Override
                public Void visitType(TypeElement e, Void p) {
                    si.setUrl(DocPath.forClass(TagletWriterImpl.this.utils, e).getPath() + "#" + anchorName);
                    si.setHolder(TagletWriterImpl.this.utils.getFullyQualifiedName(e));
                    return null;
                }

                @Override
                public Void visitVariable(VariableElement e, Void p) {
                    TypeElement te = TagletWriterImpl.this.utils.getEnclosingTypeElement(e);
                    si.setUrl(DocPath.forClass(TagletWriterImpl.this.utils, te).getPath() + "#" + anchorName);
                    si.setHolder(TagletWriterImpl.this.utils.getFullyQualifiedName(e) + "." + TagletWriterImpl.this.utils.getSimpleName(e));
                    return null;
                }

                @Override
                protected Void defaultAction(Element e, Void p) {
                    TypeElement te = TagletWriterImpl.this.utils.getEnclosingTypeElement(e);
                    si.setUrl(DocPath.forClass(TagletWriterImpl.this.utils, te).getPath() + "#" + anchorName);
                    si.setHolder(TagletWriterImpl.this.utils.getFullyQualifiedName(e));
                    return null;
                }
            }.visit(element);
            si.setCategory(this.configuration.getResource("doclet.SearchTags").toString());
            this.configuration.tagSearchIndex.add(si);
        }
        return result;
    }

    @Override
    public Content getDocRootOutput() {
        String path = this.htmlWriter.pathToRoot.isEmpty() ? "." : this.htmlWriter.pathToRoot.getPath();
        return new StringContent(path);
    }

    @Override
    public Content deprecatedTagOutput(Element element) {
        ContentBuilder result = new ContentBuilder();
        CommentHelper ch = this.utils.getCommentHelper(element);
        List<? extends DocTree> deprs = this.utils.getBlockTags(element, DocTree.Kind.DEPRECATED);
        if (this.utils.isTypeElement(element)) {
            if (this.utils.isDeprecated(element)) {
                List<? extends DocTree> commentTags;
                result.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
                result.addContent(RawHtml.nbsp);
                if (!deprs.isEmpty() && !(commentTags = ch.getDescription(this.configuration, deprs.get(0))).isEmpty()) {
                    result.addContent(this.commentTagsToOutput(null, element, commentTags, false));
                }
            }
        } else if (this.utils.isDeprecated(element)) {
            List<? extends DocTree> bodyTags;
            Content body;
            result.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
            result.addContent(RawHtml.nbsp);
            if (!deprs.isEmpty() && !(body = this.commentTagsToOutput(null, element, bodyTags = ch.getBody(this.configuration, deprs.get(0)), false)).isEmpty()) {
                result.addContent(HtmlTree.SPAN(HtmlStyle.deprecationComment, body));
            }
        } else if (this.utils.isDeprecated(this.utils.getEnclosingTypeElement(element))) {
            result.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
            result.addContent(RawHtml.nbsp);
        }
        return result;
    }

    @Override
    protected Content literalTagOutput(Element element, DocTree tag) {
        CommentHelper ch = this.utils.getCommentHelper(element);
        StringContent result = new StringContent(this.utils.normalizeNewlines(ch.getText(tag)));
        return result;
    }

    @Override
    public MessageRetriever getMsgRetriever() {
        return this.configuration.message;
    }

    @Override
    public Content getParamHeader(String header) {
        HtmlTree result = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.paramLabel, new StringContent(header)));
        return result;
    }

    @Override
    public Content paramTagOutput(Element element, DocTree paramTag, String paramName) {
        ContentBuilder body = new ContentBuilder();
        CommentHelper ch = this.utils.getCommentHelper(element);
        body.addContent(HtmlTree.CODE(new RawHtml(paramName)));
        body.addContent(" - ");
        List<? extends DocTree> description = ch.getDescription(this.configuration, paramTag);
        body.addContent(this.htmlWriter.commentTagsToContent(paramTag, element, description, false));
        HtmlTree result = HtmlTree.DD(body);
        return result;
    }

    @Override
    public Content propertyTagOutput(Element element, DocTree tag, String prefix) {
        ContentBuilder body = new ContentBuilder();
        CommentHelper ch = this.utils.getCommentHelper(element);
        ((Content)body).addContent(new RawHtml(prefix));
        ((Content)body).addContent(" ");
        ((Content)body).addContent(HtmlTree.CODE(new RawHtml(ch.getText(tag))));
        ((Content)body).addContent(".");
        HtmlTree result = HtmlTree.P(body);
        return result;
    }

    @Override
    public Content returnTagOutput(Element element, DocTree returnTag) {
        ContentBuilder result = new ContentBuilder();
        CommentHelper ch = this.utils.getCommentHelper(element);
        result.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.returnLabel, new StringContent(this.configuration.getText("doclet.Returns")))));
        result.addContent(HtmlTree.DD(this.htmlWriter.commentTagsToContent(returnTag, element, ch.getDescription(this.configuration, returnTag), false)));
        return result;
    }

    @Override
    public Content seeTagOutput(Element holder, List<? extends DocTree> seeTags) {
        ContentBuilder body = new ContentBuilder();
        if (!seeTags.isEmpty()) {
            for (DocTree docTree : seeTags) {
                this.appendSeparatorIfNotEmpty(body);
                body.addContent(this.htmlWriter.seeTagToContent(holder, docTree));
            }
        }
        if (this.utils.isVariableElement(holder) && ((VariableElement)holder).getConstantValue() != null && this.htmlWriter instanceof ClassWriterImpl) {
            this.appendSeparatorIfNotEmpty(body);
            DocPath constantsPath = this.htmlWriter.pathToRoot.resolve(DocPaths.CONSTANT_VALUES);
            String string = ((ClassWriterImpl)this.htmlWriter).getTypeElement().getQualifiedName() + "." + this.utils.getSimpleName(holder);
            DocLink link = constantsPath.fragment(string);
            body.addContent(this.htmlWriter.getHyperLink(link, (Content)new StringContent(this.configuration.getText("doclet.Constants_Summary"))));
        }
        if (this.utils.isClass(holder) && this.utils.isSerializable((TypeElement)holder) && SerializedFormBuilder.serialInclude(this.utils, holder) && SerializedFormBuilder.serialInclude(this.utils, this.utils.containingPackage(holder))) {
            this.appendSeparatorIfNotEmpty(body);
            DocPath serialPath = this.htmlWriter.pathToRoot.resolve(DocPaths.SERIALIZED_FORM);
            DocLink docLink = serialPath.fragment(this.utils.getFullyQualifiedName(holder));
            body.addContent(this.htmlWriter.getHyperLink(docLink, (Content)new StringContent(this.configuration.getText("doclet.Serialized_Form"))));
        }
        if (body.isEmpty()) {
            return body;
        }
        ContentBuilder result = new ContentBuilder();
        result.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.seeLabel, new StringContent(this.configuration.getText("doclet.See_Also")))));
        result.addContent(HtmlTree.DD(body));
        return result;
    }

    private void appendSeparatorIfNotEmpty(ContentBuilder body) {
        if (!body.isEmpty()) {
            body.addContent(", ");
            body.addContent(DocletConstants.NL);
        }
    }

    @Override
    public Content simpleTagOutput(Element element, List<? extends DocTree> simpleTags, String header) {
        CommentHelper ch = this.utils.getCommentHelper(element);
        ContentBuilder result = new ContentBuilder();
        result.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.simpleTagLabel, new RawHtml(header))));
        ContentBuilder body = new ContentBuilder();
        boolean many = false;
        for (DocTree docTree : simpleTags) {
            if (many) {
                body.addContent(", ");
            }
            List<? extends DocTree> bodyTags = ch.getBody(this.configuration, docTree);
            body.addContent(this.htmlWriter.commentTagsToContent(docTree, element, bodyTags, false));
            many = true;
        }
        result.addContent(HtmlTree.DD(body));
        return result;
    }

    @Override
    public Content simpleTagOutput(Element element, DocTree simpleTag, String header) {
        ContentBuilder result = new ContentBuilder();
        result.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.simpleTagLabel, new RawHtml(header))));
        CommentHelper ch = this.utils.getCommentHelper(element);
        List<? extends DocTree> description = ch.getDescription(this.configuration, simpleTag);
        Content body = this.htmlWriter.commentTagsToContent(simpleTag, element, description, false);
        result.addContent(HtmlTree.DD(body));
        return result;
    }

    @Override
    public Content getThrowsHeader() {
        HtmlTree result = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.throwsLabel, new StringContent(this.configuration.getText("doclet.Throws"))));
        return result;
    }

    @Override
    public Content throwsTagOutput(Element element, DocTree throwsTag) {
        Content excName;
        ContentBuilder body = new ContentBuilder();
        CommentHelper ch = this.utils.getCommentHelper(element);
        Element exception = ch.getException(this.configuration, throwsTag);
        if (exception == null) {
            excName = new RawHtml(ch.getExceptionName(throwsTag).toString());
        } else if (exception.asType() == null) {
            excName = new RawHtml(this.utils.getFullyQualifiedName(exception));
        } else {
            LinkInfoImpl link = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, exception.asType());
            link.excludeTypeBounds = true;
            excName = this.htmlWriter.getLink(link);
        }
        body.addContent(HtmlTree.CODE(excName));
        List<? extends DocTree> description = ch.getDescription(this.configuration, throwsTag);
        Content desc = this.htmlWriter.commentTagsToContent(throwsTag, element, description, false);
        if (desc != null && !desc.isEmpty()) {
            body.addContent(" - ");
            body.addContent(desc);
        }
        HtmlTree result = HtmlTree.DD(body);
        return result;
    }

    @Override
    public Content throwsTagOutput(TypeMirror throwsType) {
        HtmlTree result = HtmlTree.DD(HtmlTree.CODE(this.htmlWriter.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, throwsType))));
        return result;
    }

    @Override
    public Content valueTagOutput(VariableElement field, String constantVal, boolean includeLink) {
        return includeLink ? this.htmlWriter.getDocLink(LinkInfoImpl.Kind.VALUE_TAG, field, constantVal, false) : new RawHtml(constantVal);
    }

    @Override
    public Content commentTagsToOutput(DocTree holderTag, List<? extends DocTree> tags) {
        return this.commentTagsToOutput(holderTag, null, tags, false);
    }

    @Override
    public Content commentTagsToOutput(Element holder, List<? extends DocTree> tags) {
        return this.commentTagsToOutput(null, holder, tags, false);
    }

    @Override
    public Content commentTagsToOutput(DocTree holderTag, Element holder, List<? extends DocTree> tags, boolean isFirstSentence) {
        return this.htmlWriter.commentTagsToContent(holderTag, holder, tags, isFirstSentence);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }
}

