/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit;

import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.openjdk.tools.javadoc.doclet.DocletEnvironment;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDoclet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.CommentUtils;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.WorkArounds;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.BuilderFactory;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ClassTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.PackageListWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public abstract class AbstractDoclet {
    public Configuration configuration;
    protected Utils utils;
    private static final String TOOLKIT_DOCLET_NAME = HtmlDoclet.class.getName();

    private boolean isValidDoclet() {
        if (!this.getClass().getName().equals(TOOLKIT_DOCLET_NAME)) {
            this.configuration.message.error("doclet.Toolkit_Usage_Violation", TOOLKIT_DOCLET_NAME);
            return false;
        }
        return true;
    }

    public boolean startDoclet(DocletEnvironment root) {
        this.configuration = this.configuration();
        this.configuration.root = root;
        this.configuration.cmtUtils = new CommentUtils(this.configuration);
        this.utils = this.configuration.utils = new Utils(this.configuration);
        this.configuration.workArounds = new WorkArounds(this.configuration);
        if (!this.isValidDoclet()) {
            return false;
        }
        try {
            this.startGeneration(root);
        }
        catch (Configuration.Fault f) {
            this.configuration.reporter.print(Diagnostic.Kind.ERROR, f.getMessage());
            return false;
        }
        catch (DocletAbortException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause.getLocalizedMessage() != null) {
                    this.configuration.reporter.print(Diagnostic.Kind.ERROR, cause.getLocalizedMessage());
                } else {
                    this.configuration.reporter.print(Diagnostic.Kind.ERROR, cause.toString());
                }
            }
            return false;
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    public SourceVersion sourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    public abstract Configuration configuration();

    private void startGeneration(DocletEnvironment root) throws Configuration.Fault, Exception {
        if (root.getIncludedClasses().isEmpty()) {
            this.configuration.message.error("doclet.No_Public_Classes_To_Document", new Object[0]);
            return;
        }
        if (!this.configuration.setOptions()) {
            return;
        }
        this.configuration.getDocletSpecificMsg().notice("doclet.build_version", this.configuration.getDocletSpecificBuildDate());
        ClassTree classtree = new ClassTree(this.configuration, this.configuration.nodeprecated);
        this.generateClassFiles(root, classtree);
        this.configuration.utils.copyDocFiles(DocPaths.DOC_FILES);
        PackageListWriter.generate(this.configuration);
        this.generatePackageFiles(classtree);
        this.generateOtherFiles(root, classtree);
        this.configuration.tagletManager.printReport();
    }

    protected void generateOtherFiles(DocletEnvironment root, ClassTree classtree) throws Exception {
        BuilderFactory builderFactory = this.configuration.getBuilderFactory();
        AbstractBuilder constantsSummaryBuilder = builderFactory.getConstantsSummaryBuilder();
        constantsSummaryBuilder.build();
        AbstractBuilder serializedFormBuilder = builderFactory.getSerializedFormBuilder();
        serializedFormBuilder.build();
    }

    protected abstract void generatePackageFiles(ClassTree var1) throws Exception;

    protected abstract void generateClassFiles(SortedSet<TypeElement> var1, ClassTree var2);

    protected void generateClassFiles(DocletEnvironment root, ClassTree classtree) {
        this.generateClassFiles(classtree);
        TreeSet<Element> packages = new TreeSet<Element>(this.utils.makePackageComparator());
        packages.addAll(this.utils.getSpecifiedPackages());
        packages.stream().forEach(pkg -> this.generateClassFiles(this.utils.getAllClasses((Element)pkg), classtree));
    }

    private void generateClassFiles(ClassTree classtree) {
        SortedSet<PackageElement> packages = this.configuration.typeElementCatalog.packages();
        packages.stream().forEach(pkg -> this.generateClassFiles(this.configuration.typeElementCatalog.allClasses((PackageElement)pkg), classtree));
    }
}

