/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.twitter.common.util.concurrent.ForwardingExecutorService;
import com.twitter.common.util.concurrent.TaskConverter;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ExceptionHandlingExecutorService
extends ForwardingExecutorService<ExecutorService> {
    private final Supplier<Thread.UncaughtExceptionHandler> handler;

    ExceptionHandlingExecutorService(ExecutorService delegate, Supplier<Thread.UncaughtExceptionHandler> handler) {
        super(delegate);
        this.handler = (Supplier)Preconditions.checkNotNull(handler);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(TaskConverter.alertingCallable(task, this.handler));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(TaskConverter.alertingRunnable(task, this.handler), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return super.submit(TaskConverter.alertingRunnable(task, this.handler));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return super.invokeAll(TaskConverter.alertingCallables(tasks, this.handler));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return super.invokeAll(TaskConverter.alertingCallables(tasks, this.handler), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)super.invokeAny(TaskConverter.alertingCallables(tasks, this.handler));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)super.invokeAny(TaskConverter.alertingCallables(tasks, this.handler), timeout, unit);
    }
}

