/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.IOException;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyBookie
extends Bookie {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyBookie.class);

    public ReadOnlyBookie(ServerConfiguration conf, StatsLogger statsLogger) throws IOException, KeeperException, InterruptedException, BookieException {
        super(conf, statsLogger);
        if (!conf.isReadOnlyModeEnabled()) {
            String err = "Try to init ReadOnly Bookie, while ReadOnly mode is not enabled";
            LOG.error(err);
            throw new IOException(err);
        }
        this.readOnly.set(true);
        LOG.info("Running bookie in readonly mode.");
    }

    @Override
    public void doTransitionToWritableMode() {
        LOG.info("Skip transition to writable mode for readonly bookie");
    }

    @Override
    public void doTransitionToReadOnlyMode() {
        LOG.info("Skip transition to readonly mode for readonly bookie");
    }
}

