/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.benchmark.Utils;
import org.apache.distributedlog.benchmark.Worker;
import org.apache.distributedlog.benchmark.utils.ShiftableRateLimiter;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLWriterWorker
implements Worker {
    private static final Logger LOG = LoggerFactory.getLogger(DLWriterWorker.class);
    static final int BACKOFF_MS = 200;
    final String streamPrefix;
    final int startStreamId;
    final int endStreamId;
    final int writeConcurrency;
    final int messageSizeBytes;
    final ExecutorService executorService;
    final ScheduledExecutorService rescueService;
    final ShiftableRateLimiter rateLimiter;
    final Random random;
    final Namespace namespace;
    final List<DistributedLogManager> dlms;
    final List<AsyncLogWriter> streamWriters;
    final int numStreams;
    volatile boolean running = true;
    final StatsLogger statsLogger;
    final OpStatsLogger requestStat;

    public DLWriterWorker(DistributedLogConfiguration conf, URI uri, String streamPrefix, int startStreamId, int endStreamId, ShiftableRateLimiter rateLimiter, int writeConcurrency, int messageSizeBytes, StatsLogger statsLogger) throws IOException {
        String streamName;
        int i;
        Preconditions.checkArgument((startStreamId <= endStreamId ? 1 : 0) != 0);
        this.streamPrefix = streamPrefix;
        this.startStreamId = startStreamId;
        this.endStreamId = endStreamId;
        this.rateLimiter = rateLimiter;
        this.writeConcurrency = writeConcurrency;
        this.messageSizeBytes = messageSizeBytes;
        this.statsLogger = statsLogger;
        this.requestStat = this.statsLogger.getOpStatsLogger("requests");
        this.executorService = Executors.newCachedThreadPool();
        this.rescueService = Executors.newSingleThreadScheduledExecutor();
        this.random = new Random(System.currentTimeMillis());
        this.namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).statsLogger(statsLogger.scope("dl")).build();
        this.numStreams = endStreamId - startStreamId;
        this.dlms = new ArrayList<DistributedLogManager>(this.numStreams);
        this.streamWriters = new ArrayList<AsyncLogWriter>(this.numStreams);
        final ConcurrentHashMap writers = new ConcurrentHashMap();
        final CountDownLatch latch = new CountDownLatch(this.numStreams);
        for (i = startStreamId; i < endStreamId; ++i) {
            streamName = String.format("%s_%d", streamPrefix, i);
            final DistributedLogManager dlm = this.namespace.openLog(streamName);
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
                        if (null != writers.putIfAbsent(streamName, writer)) {
                            FutureUtils.result((CompletableFuture)writer.asyncClose());
                        }
                        latch.countDown();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to intialize writer for stream : {}", (Object)streamName, (Object)e);
                    }
                }
            });
            this.dlms.add(dlm);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted on initializing writers for streams.", e);
        }
        for (i = startStreamId; i < endStreamId; ++i) {
            streamName = String.format("%s_%d", streamPrefix, i);
            AsyncLogWriter writer = (AsyncLogWriter)writers.get(streamName);
            if (null == writer) {
                throw new IOException("Writer for " + streamName + " never initialized.");
            }
            this.streamWriters.add(writer);
        }
        LOG.info("Writing to {} streams.", (Object)this.numStreams);
    }

    void rescueWriter(int idx, AsyncLogWriter writer) {
        if (this.streamWriters.get(idx) == writer) {
            try {
                FutureUtils.result((CompletableFuture)writer.asyncClose());
            }
            catch (Exception e) {
                LOG.error("Failed to close writer for stream {}.", (Object)idx);
            }
            AsyncLogWriter newWriter = null;
            try {
                newWriter = this.dlms.get(idx).startAsyncLogSegmentNonPartitioned();
            }
            catch (IOException e) {
                LOG.error("Failed to create new writer for stream {}, backoff for {} ms.", (Object)idx, (Object)200);
                this.scheduleRescue(idx, writer, 200);
            }
            this.streamWriters.set(idx, newWriter);
        } else {
            LOG.warn("AsyncLogWriter for stream {} was already rescued.", (Object)idx);
        }
    }

    void scheduleRescue(final int idx, final AsyncLogWriter writer, int delayMs) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DLWriterWorker.this.rescueWriter(idx, writer);
            }
        };
        if (delayMs > 0) {
            this.rescueService.schedule(r, (long)delayMs, TimeUnit.MILLISECONDS);
        } else {
            this.rescueService.submit(r);
        }
    }

    @Override
    public void close() throws IOException {
        this.running = false;
        SchedulerUtils.shutdownScheduler((ExecutorService)this.executorService, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        SchedulerUtils.shutdownScheduler((ExecutorService)this.rescueService, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        for (AsyncLogWriter writer : this.streamWriters) {
            org.apache.distributedlog.util.Utils.ioResult((CompletableFuture)writer.asyncClose());
        }
        for (DistributedLogManager dlm : this.dlms) {
            dlm.close();
        }
        this.namespace.close();
    }

    @Override
    public void run() {
        LOG.info("Starting dlwriter (concurrency = {}, prefix = {}, numStreams = {})", new Object[]{this.writeConcurrency, this.streamPrefix, this.numStreams});
        for (int i = 0; i < this.writeConcurrency; ++i) {
            this.executorService.submit(new Writer(i));
        }
    }

    class Writer
    implements Runnable {
        final int idx;

        Writer(int idx) {
            this.idx = idx;
        }

        @Override
        public void run() {
            LOG.info("Started writer {}.", (Object)this.idx);
            while (DLWriterWorker.this.running) {
                byte[] data;
                final int streamIdx = DLWriterWorker.this.random.nextInt(DLWriterWorker.this.numStreams);
                final AsyncLogWriter writer = DLWriterWorker.this.streamWriters.get(streamIdx);
                DLWriterWorker.this.rateLimiter.getLimiter().acquire();
                final long requestMillis = System.currentTimeMillis();
                try {
                    data = Utils.generateMessage(requestMillis, DLWriterWorker.this.messageSizeBytes);
                }
                catch (TException e) {
                    LOG.error("Error on generating message : ", (Throwable)e);
                    break;
                }
                writer.write(new LogRecord(requestMillis, data)).whenComplete((BiConsumer)new FutureEventListener<DLSN>(){

                    public void onSuccess(DLSN value) {
                        DLWriterWorker.this.requestStat.registerSuccessfulEvent(System.currentTimeMillis() - requestMillis, TimeUnit.MILLISECONDS);
                    }

                    public void onFailure(Throwable cause) {
                        DLWriterWorker.this.requestStat.registerFailedEvent(System.currentTimeMillis() - requestMillis, TimeUnit.MILLISECONDS);
                        LOG.error("Failed to publish, rescue it : ", cause);
                        DLWriterWorker.this.scheduleRescue(streamIdx, writer, 0);
                    }
                });
            }
        }
    }
}

