/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.service;

import com.twitter.conversions.time$;
import com.twitter.finagle.service.RetryBudget;
import com.twitter.finagle.service.RetryBudget$TokenRetryBudget$;
import com.twitter.util.Duration;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TokenBucket;
import com.twitter.util.TokenBucket$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class RetryBudget$ {
    public static final RetryBudget$ MODULE$;
    private final RetryBudget Empty;
    private final RetryBudget Infinite;
    private final Duration DefaultTtl;

    static {
        new RetryBudget$();
    }

    public RetryBudget Empty() {
        return this.Empty;
    }

    public RetryBudget Infinite() {
        return this.Infinite;
    }

    public RetryBudget apply() {
        return this.apply(this.DefaultTtl, 10, 0.2, (Function0<Object>)Stopwatch$.MODULE$.systemMillis());
    }

    public RetryBudget apply(Duration ttl, int minRetriesPerSec, double percentCanRetry, Function0<Object> nowMillis) {
        Predef$.MODULE$.require(ttl.inSeconds() >= 1 && ttl.inSeconds() <= 60, (Function0)new Serializable(ttl){
            public static final long serialVersionUID = 0L;
            private final Duration ttl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ttl must be [1 second, 60 seconds]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ttl$1}));
            }
            {
                this.ttl$1 = ttl$1;
            }
        });
        Predef$.MODULE$.require(minRetriesPerSec >= 0, (Function0)new Serializable(minRetriesPerSec){
            public static final long serialVersionUID = 0L;
            private final int minRetriesPerSec$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minRetriesPerSec must be non-negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.minRetriesPerSec$1)}));
            }
            {
                this.minRetriesPerSec$1 = minRetriesPerSec$1;
            }
        });
        Predef$.MODULE$.require(percentCanRetry >= 0.0, (Function0)new Serializable(percentCanRetry){
            public static final long serialVersionUID = 0L;
            private final double percentCanRetry$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentCanRetry must be non-negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.percentCanRetry$1)}));
            }
            {
                this.percentCanRetry$1 = percentCanRetry$1;
            }
        });
        Predef$.MODULE$.require(percentCanRetry <= RetryBudget$TokenRetryBudget$.MODULE$.ScaleFactor(), (Function0)new Serializable(percentCanRetry){
            public static final long serialVersionUID = 0L;
            private final double percentCanRetry$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentCanRetry must not be greater than ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)RetryBudget$TokenRetryBudget$.MODULE$.ScaleFactor()), BoxesRunTime.boxToDouble((double)this.percentCanRetry$1)}));
            }
            {
                this.percentCanRetry$1 = percentCanRetry$1;
            }
        });
        if (minRetriesPerSec == 0 && percentCanRetry == 0.0) {
            return this.Empty();
        }
        int depositAmount = percentCanRetry == 0.0 ? 0 : (int)RetryBudget$TokenRetryBudget$.MODULE$.ScaleFactor();
        int withdrawalAmount = percentCanRetry == 0.0 ? 1 : (int)(RetryBudget$TokenRetryBudget$.MODULE$.ScaleFactor() / percentCanRetry);
        int reserve = minRetriesPerSec * ttl.inSeconds() * withdrawalAmount;
        TokenBucket tokenBucket = TokenBucket$.MODULE$.newLeakyBucket(ttl, reserve, nowMillis);
        return new RetryBudget.TokenRetryBudget(tokenBucket, depositAmount, withdrawalAmount);
    }

    public Function0<Object> apply$default$4() {
        return Stopwatch$.MODULE$.systemMillis();
    }

    private RetryBudget$() {
        MODULE$ = this;
        this.Empty = new RetryBudget(){

            public void deposit() {
            }

            public boolean tryWithdraw() {
                return false;
            }

            public long balance() {
                return 0L;
            }
        };
        this.Infinite = new RetryBudget(){

            public void deposit() {
            }

            public boolean tryWithdraw() {
                return true;
            }

            public long balance() {
                return 100L;
            }
        };
        this.DefaultTtl = time$.MODULE$.intToTimeableNumber(10).seconds();
    }
}

