/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.routing;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.finagle.ChannelException;
import com.twitter.finagle.NoBrokersAvailableException;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.NullStatsReceiver;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Function0;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.client.routing.ServerSetRoutingService;
import org.apache.distributedlog.client.routing.ServerSetWatcher;
import org.apache.distributedlog.client.routing.TwitterServerSetWatcher;
import org.apache.distributedlog.service.DLSocketAddress;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class ConsistentHashRoutingService
extends ServerSetRoutingService {
    private static final Logger logger = LoggerFactory.getLogger(ConsistentHashRoutingService.class);
    protected final HashedWheelTimer hashedWheelTimer;
    protected final HashFunction hashFunction = Hashing.md5();
    protected final ConsistentHash circle;
    protected final Map<Integer, SocketAddress> shardId2Address = new HashMap<Integer, SocketAddress>();
    protected final Map<SocketAddress, Integer> address2ShardId = new HashMap<SocketAddress, Integer>();
    protected final int blackoutSeconds;
    protected final StatsReceiver statsReceiver;
    protected final AtomicInteger numBlackoutHosts;
    protected final Gauge numBlackoutHostsGauge;
    protected final Gauge numHostsGauge;
    private static final int UNKNOWN_SHARD_ID = -1;

    @Deprecated
    public static ConsistentHashRoutingService of(ServerSetWatcher serverSetWatcher, int numReplicas) {
        return new ConsistentHashRoutingService(serverSetWatcher, numReplicas, 300, (StatsReceiver)NullStatsReceiver.get());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    ConsistentHashRoutingService(ServerSetWatcher serverSetWatcher, int numReplicas, int blackoutSeconds, StatsReceiver statsReceiver) {
        super(serverSetWatcher);
        this.circle = new ConsistentHash(this.hashFunction, numReplicas, statsReceiver.scope("ring"));
        this.hashedWheelTimer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("ConsistentHashRoutingService-Timer-%d").build());
        this.blackoutSeconds = blackoutSeconds;
        this.statsReceiver = statsReceiver;
        this.numBlackoutHosts = new AtomicInteger(0);
        this.numBlackoutHostsGauge = this.statsReceiver.addGauge(ConsistentHashRoutingService.gaugeName("num_blackout_hosts"), (scala.Function0)new Function0<Object>(){

            public Object apply() {
                return Float.valueOf(ConsistentHashRoutingService.this.numBlackoutHosts.get());
            }
        });
        this.numHostsGauge = this.statsReceiver.addGauge(ConsistentHashRoutingService.gaugeName("num_hosts"), (scala.Function0)new Function0<Object>(){

            public Object apply() {
                return Float.valueOf(ConsistentHashRoutingService.this.address2ShardId.size());
            }
        });
    }

    private static Seq<String> gaugeName(String name) {
        return JavaConversions.asScalaBuffer(Arrays.asList(name)).toList();
    }

    @Override
    public void startService() {
        super.startService();
        this.hashedWheelTimer.start();
    }

    @Override
    public void stopService() {
        this.hashedWheelTimer.stop();
        super.stopService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getHosts() {
        Map<Integer, SocketAddress> map = this.shardId2Address;
        synchronized (map) {
            return ImmutableSet.copyOf(this.address2ShardId.keySet());
        }
    }

    @Override
    public SocketAddress getHost(String key, RoutingService.RoutingContext rContext) throws NoBrokersAvailableException {
        SocketAddress host = this.circle.get(key, rContext);
        if (null != host) {
            return host;
        }
        throw new NoBrokersAvailableException("No host found for " + key + ", routing context : " + rContext);
    }

    @Override
    public void removeHost(SocketAddress host, Throwable reason) {
        this.removeHostInternal(host, (Optional<Throwable>)Optional.of((Object)reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHostInternal(SocketAddress host, Optional<Throwable> reason) {
        Map<Integer, SocketAddress> map = this.shardId2Address;
        synchronized (map) {
            Integer shardId = this.address2ShardId.remove(host);
            if (null != shardId) {
                SocketAddress curHost = this.shardId2Address.get(shardId);
                if (null != curHost && curHost.equals(host)) {
                    this.shardId2Address.remove(shardId);
                }
                this.circle.remove(shardId, host);
                if (reason.isPresent()) {
                    if (reason.get() instanceof ChannelException) {
                        logger.info("Shard {} ({}) left due to ChannelException, black it out for {} seconds (message = {})", new Object[]{shardId, host, this.blackoutSeconds, ((Throwable)reason.get()).toString()});
                        BlackoutHost blackoutHost = new BlackoutHost(shardId, host);
                        this.hashedWheelTimer.newTimeout((TimerTask)blackoutHost, (long)this.blackoutSeconds, TimeUnit.SECONDS);
                    } else {
                        logger.info("Shard {} ({}) left due to exception {}", new Object[]{shardId, host, ((Throwable)reason.get()).toString()});
                    }
                } else {
                    logger.info("Shard {} ({}) left after server set change", (Object)shardId, (Object)host);
                }
            } else if (reason.isPresent()) {
                logger.info("Node {} left due to exception {}", (Object)host, (Object)((Throwable)reason.get()).toString());
            } else {
                logger.info("Node {} left after server set change", (Object)host);
            }
        }
    }

    private void join(int shardId, SocketAddress newHost, Set<SocketAddress> removedList) {
        SocketAddress oldHost = this.shardId2Address.put(shardId, newHost);
        if (null != oldHost) {
            this.address2ShardId.remove(oldHost);
            this.circle.remove(shardId, oldHost);
            removedList.add(oldHost);
            logger.info("Shard {} ({}) left permanently.", (Object)shardId, (Object)oldHost);
        }
        this.address2ShardId.put(newHost, shardId);
        this.circle.add(shardId, newHost);
        logger.info("Shard {} ({}) joined to replace ({}).", new Object[]{shardId, newHost, oldHost});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void performServerSetChange(ImmutableSet<DLSocketAddress> serviceInstances) {
        HashSet<SocketAddress> joinedList = new HashSet<SocketAddress>();
        HashSet<SocketAddress> removedList = new HashSet<SocketAddress>();
        HashMap<Integer, InetSocketAddress> newMap = new HashMap<Integer, InetSocketAddress>();
        Map<Integer, SocketAddress> map = this.shardId2Address;
        synchronized (map) {
            for (DLSocketAddress serviceInstance : serviceInstances) {
                if (serviceInstance.getShard() >= 0) {
                    newMap.put(serviceInstance.getShard(), serviceInstance.getSocketAddress());
                    continue;
                }
                Integer shard = this.address2ShardId.get(serviceInstance.getSocketAddress());
                if (null == shard) {
                    int shardId;
                    while (null != this.shardId2Address.get(shardId = Math.min(-1, (int)(Math.random() * -2.147483648E9)))) {
                    }
                    shard = shardId;
                }
                newMap.put(shard, serviceInstance.getSocketAddress());
            }
        }
        Map<Integer, SocketAddress> map2 = this.shardId2Address;
        synchronized (map2) {
            MapDifference difference = Maps.difference(this.shardId2Address, newMap);
            Map left = difference.entriesOnlyOnLeft();
            for (Map.Entry shardEntry : left.entrySet()) {
                SocketAddress host;
                int shard = (Integer)shardEntry.getKey();
                if (shard >= 0) {
                    host = this.shardId2Address.get(shard);
                    if (null == host) continue;
                    logger.info("Shard {} ({}) left temporarily.", (Object)shard, (Object)host);
                    continue;
                }
                host = (SocketAddress)shardEntry.getValue();
                if (null == host) continue;
                this.removeHostInternal(host, (Optional<Throwable>)Optional.absent());
                removedList.add(host);
            }
            for (Map.Entry shard : newMap.entrySet()) {
                SocketAddress oldHost = this.shardId2Address.get(shard.getKey());
                SocketAddress newHost = (SocketAddress)shard.getValue();
                if (newHost.equals(oldHost)) continue;
                this.join((Integer)shard.getKey(), newHost, removedList);
                joinedList.add(newHost);
            }
        }
        for (SocketAddress addr : removedList) {
            for (RoutingService.RoutingListener listener : this.listeners) {
                listener.onServerLeft(addr);
            }
        }
        for (SocketAddress addr : joinedList) {
            for (RoutingService.RoutingListener listener : this.listeners) {
                listener.onServerJoin(addr);
            }
        }
    }

    class BlackoutHost
    implements TimerTask {
        final int shardId;
        final SocketAddress address;

        BlackoutHost(int shardId, SocketAddress address) {
            this.shardId = shardId;
            this.address = address;
            ConsistentHashRoutingService.this.numBlackoutHosts.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Timeout timeout) throws Exception {
            boolean joined;
            ConsistentHashRoutingService.this.numBlackoutHosts.decrementAndGet();
            if (!timeout.isExpired()) {
                return;
            }
            HashSet removedList = new HashSet();
            Iterator iterator = ConsistentHashRoutingService.this.shardId2Address;
            synchronized (iterator) {
                SocketAddress curHost = ConsistentHashRoutingService.this.shardId2Address.get(this.shardId);
                if (null != curHost) {
                    logger.info("Blackout Shard {} ({}) was already replaced by {} permanently.", new Object[]{this.shardId, this.address, curHost});
                    joined = false;
                } else {
                    ConsistentHashRoutingService.this.join(this.shardId, this.address, removedList);
                    joined = true;
                }
            }
            if (joined) {
                for (RoutingService.RoutingListener listener : ConsistentHashRoutingService.this.listeners) {
                    listener.onServerJoin(this.address);
                }
            } else {
                for (RoutingService.RoutingListener listener : ConsistentHashRoutingService.this.listeners) {
                    listener.onServerLeft(this.address);
                }
            }
        }
    }

    static class ConsistentHash {
        private final HashFunction hashFunction;
        private final int numOfReplicas;
        private final SortedMap<Long, SocketAddress> circle;
        protected final Counter hostAddedCounter;
        protected final Counter hostRemovedCounter;

        ConsistentHash(HashFunction hashFunction, int numOfReplicas, StatsReceiver statsReceiver) {
            this.hashFunction = hashFunction;
            this.numOfReplicas = numOfReplicas;
            this.circle = new TreeMap<Long, SocketAddress>();
            this.hostAddedCounter = statsReceiver.counter0("adds");
            this.hostRemovedCounter = statsReceiver.counter0("removes");
        }

        private String replicaName(int shardId, int replica, String address) {
            if (shardId < 0) {
                shardId = -1;
            }
            StringBuilder sb = new StringBuilder(100);
            sb.append("shard-");
            sb.append(shardId);
            sb.append('-');
            sb.append(replica);
            sb.append('-');
            sb.append(address);
            return sb.toString();
        }

        private Long replicaHash(int shardId, int replica, String address) {
            return this.hashFunction.hashUnencodedChars((CharSequence)this.replicaName(shardId, replica, address)).asLong();
        }

        private Long replicaHash(int shardId, int replica, SocketAddress address) {
            return this.replicaHash(shardId, replica, address.toString());
        }

        public synchronized void add(int shardId, SocketAddress address) {
            String addressStr = address.toString();
            for (int i = 0; i < this.numOfReplicas; ++i) {
                Long hash = this.replicaHash(shardId, i, addressStr);
                this.circle.put(hash, address);
            }
            this.hostAddedCounter.incr();
        }

        public synchronized void remove(int shardId, SocketAddress address) {
            for (int i = 0; i < this.numOfReplicas; ++i) {
                long hash = this.replicaHash(shardId, i, address);
                SocketAddress oldAddress = (SocketAddress)this.circle.get(hash);
                if (null == oldAddress || !oldAddress.equals(address)) continue;
                this.circle.remove(hash);
            }
            this.hostRemovedCounter.incr();
        }

        public SocketAddress get(String key, RoutingService.RoutingContext rContext) {
            long hash = this.hashFunction.hashUnencodedChars((CharSequence)key).asLong();
            return this.find(hash, rContext);
        }

        private synchronized SocketAddress find(long hash, RoutingService.RoutingContext rContext) {
            if (this.circle.isEmpty()) {
                return null;
            }
            for (Map.Entry<Long, SocketAddress> entry : this.circle.tailMap(hash).entrySet()) {
                if (rContext.isTriedHost(entry.getValue())) continue;
                return entry.getValue();
            }
            for (Map.Entry<Long, SocketAddress> entry : this.circle.headMap(hash).entrySet()) {
                if (rContext.isTriedHost(entry.getValue())) continue;
                return entry.getValue();
            }
            return null;
        }

        private synchronized Pair<Long, SocketAddress> get(long hash) {
            if (this.circle.isEmpty()) {
                return null;
            }
            if (!this.circle.containsKey(hash)) {
                SortedMap<Long, SocketAddress> tailMap = this.circle.tailMap(hash);
                hash = tailMap.isEmpty() ? this.circle.firstKey().longValue() : tailMap.firstKey().longValue();
            }
            return Pair.of((Object)hash, this.circle.get(hash));
        }

        synchronized void dumpHashRing() {
            for (Map.Entry<Long, SocketAddress> entry : this.circle.entrySet()) {
                logger.info(entry.getKey() + " : " + entry.getValue());
            }
        }
    }

    public static class Builder
    implements RoutingService.Builder {
        private ServerSet serverSet;
        private boolean resolveFromName = false;
        private int numReplicas;
        private int blackoutSeconds = 300;
        private StatsReceiver statsReceiver = NullStatsReceiver.get();

        private Builder() {
        }

        public Builder serverSet(ServerSet serverSet) {
            this.serverSet = serverSet;
            return this;
        }

        public Builder resolveFromName(boolean enabled) {
            this.resolveFromName = enabled;
            return this;
        }

        public Builder numReplicas(int numReplicas) {
            this.numReplicas = numReplicas;
            return this;
        }

        public Builder blackoutSeconds(int seconds) {
            this.blackoutSeconds = seconds;
            return this;
        }

        @Override
        public Builder statsReceiver(StatsReceiver statsReceiver) {
            this.statsReceiver = statsReceiver;
            return this;
        }

        @Override
        public RoutingService build() {
            Preconditions.checkNotNull((Object)this.serverSet, (Object)"No serverset provided.");
            Preconditions.checkNotNull((Object)this.statsReceiver, (Object)"No stats receiver provided.");
            Preconditions.checkArgument((this.numReplicas > 0 ? 1 : 0) != 0, (Object)("Invalid number of replicas : " + this.numReplicas));
            return new ConsistentHashRoutingService(new TwitterServerSetWatcher(this.serverSet, this.resolveFromName), this.numReplicas, this.blackoutSeconds, this.statsReceiver);
        }
    }
}

