/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.apt;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class Configuration {
    static final String DEFAULT_RESOURCE_PACKAGE = Configuration.class.getPackage().getName();
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    private static final CharMatcher IDENTIFIER_START = CharMatcher.forPredicate((Predicate)new Predicate<Character>(){

        public boolean apply(Character c) {
            return Character.isJavaIdentifierStart(c.charValue());
        }
    });
    private static final CharMatcher IDENTIFIER_REST = CharMatcher.forPredicate((Predicate)new Predicate<Character>(){

        public boolean apply(Character c) {
            return Character.isJavaIdentifierPart(c.charValue());
        }
    });
    private static final Function<URL, InputSupplier<? extends InputStream>> URL_TO_INPUT = new Function<URL, InputSupplier<? extends InputStream>>(){

        public InputSupplier<? extends InputStream> apply(final URL resource) {
            return new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return resource.openStream();
                }
            };
        }
    };
    private static final Function<InputSupplier<? extends InputStream>, InputSupplier<? extends Reader>> INPUT_TO_READER = new Function<InputSupplier<? extends InputStream>, InputSupplier<? extends Reader>>(){

        public InputSupplier<? extends Reader> apply(InputSupplier<? extends InputStream> input) {
            return CharStreams.newReaderSupplier(input, (Charset)Charsets.UTF_8);
        }
    };
    private static final Function<URL, InputSupplier<? extends Reader>> URL_TO_READER = Functions.compose(INPUT_TO_READER, URL_TO_INPUT);
    private static final String DEFAULT_RESOURCE_NAME = "cmdline.arg.info.txt";
    private int nextResourceIndex;
    private final ImmutableSet<ArgInfo> positionalInfos;
    private final ImmutableSet<ArgInfo> cmdLineInfos;
    private final ImmutableSet<ParserInfo> parserInfos;
    private final ImmutableSet<VerifierInfo> verifierInfos;

    private Configuration(int nextResourceIndex, Iterable<ArgInfo> positionalInfos, Iterable<ArgInfo> cmdLineInfos, Iterable<ParserInfo> parserInfos, Iterable<VerifierInfo> verifierInfos) {
        this.nextResourceIndex = nextResourceIndex;
        this.positionalInfos = ImmutableSet.copyOf(positionalInfos);
        this.cmdLineInfos = ImmutableSet.copyOf(cmdLineInfos);
        this.parserInfos = ImmutableSet.copyOf(parserInfos);
        this.verifierInfos = ImmutableSet.copyOf(verifierInfos);
    }

    private static String checkValidIdentifier(String identifier, boolean compound) {
        String[] parts;
        String[] stringArray;
        Preconditions.checkNotNull((Object)identifier);
        String trimmed = identifier.trim();
        Preconditions.checkArgument((!trimmed.isEmpty() ? 1 : 0) != 0, (String)"Invalid identifier: '%s'", (Object[])new Object[]{identifier});
        if (compound) {
            stringArray = trimmed.split("\\.");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = trimmed;
        }
        for (String part : parts = stringArray) {
            Preconditions.checkArgument((boolean)IDENTIFIER_REST.matchesAllOf((CharSequence)IDENTIFIER_START.trimLeadingFrom((CharSequence)part)), (String)"Invalid identifier: '%s'", (Object[])new Object[]{identifier});
        }
        return trimmed;
    }

    private static String getResourceName(int index) {
        return String.format("%s.%s", DEFAULT_RESOURCE_NAME, index);
    }

    private static String getResourcePath(int index) {
        return String.format("%s/%s", DEFAULT_RESOURCE_PACKAGE.replace('.', '/'), Configuration.getResourceName(index));
    }

    public static Configuration load() throws ConfigurationException, IOException {
        ConfigurationResources allResources = Configuration.getAllResources();
        ImmutableList configs = ImmutableList.copyOf((Iterator)allResources.resources);
        if (configs.isEmpty()) {
            LOG.info("No @CmdLine arg configs found on the classpath");
        } else {
            LOG.info("Loading @CmdLine config from: " + configs);
        }
        return Configuration.load(allResources.nextResourceIndex, (List<URL>)configs);
    }

    private static ConfigurationResources getAllResources() throws IOException {
        int maxResourceIndex = 0;
        Iterator allResources = Configuration.getResources(0);
        for (int nextResourceIndex = 1; nextResourceIndex <= maxResourceIndex + 10; ++nextResourceIndex) {
            Iterator<URL> resources = Configuration.getResources(nextResourceIndex);
            if (!resources.hasNext()) continue;
            allResources = Iterators.concat(allResources, resources);
            maxResourceIndex = nextResourceIndex;
        }
        return new ConfigurationResources(maxResourceIndex + 1, allResources);
    }

    private static Iterator<URL> getResources(int index) throws IOException {
        return Iterators.forEnumeration(Configuration.class.getClassLoader().getResources(Configuration.getResourcePath(index)));
    }

    private static Configuration load(int nextIndex, List<URL> configs) throws ConfigurationException, IOException {
        InputSupplier input = CharStreams.join((Iterable)Iterables.transform(configs, URL_TO_READER));
        return (Configuration)CharStreams.readLines((InputSupplier)input, (LineProcessor)new ConfigurationParser(nextIndex));
    }

    public boolean isEmpty() {
        return this.positionalInfos.isEmpty() && this.cmdLineInfos.isEmpty() && this.parserInfos.isEmpty() && this.verifierInfos.isEmpty();
    }

    public Iterable<ArgInfo> positionalInfo() {
        return this.positionalInfos;
    }

    public Iterable<ArgInfo> optionInfo() {
        return this.cmdLineInfos;
    }

    public Iterable<ParserInfo> parserInfo() {
        return this.parserInfos;
    }

    public Iterable<VerifierInfo> verifierInfo() {
        return this.verifierInfos;
    }

    static String mainResourceName() {
        return Configuration.getResourceName(0);
    }

    String nextResourceName() {
        return Configuration.getResourceName(this.nextResourceIndex);
    }

    void store(Writer output, String message) {
        PrintWriter writer = new PrintWriter(output);
        writer.printf("# %s\n", new Date());
        writer.printf("# %s\n ", message);
        writer.println();
        for (Object info : this.positionalInfos) {
            writer.printf("positional %s %s\n", ((ArgInfo)info).className, ((ArgInfo)info).fieldName);
        }
        writer.println();
        for (Object info : this.cmdLineInfos) {
            writer.printf("field %s %s\n", ((ArgInfo)info).className, ((ArgInfo)info).fieldName);
        }
        writer.println();
        for (Object info : this.parserInfos) {
            writer.printf("parser %s %s\n", ((ParserInfo)info).parsedType, ((ParserInfo)info).parserClass);
        }
        writer.println();
        for (Object info : this.verifierInfos) {
            writer.printf("verifier %s %s %s\n", ((VerifierInfo)info).verifiedType, ((VerifierInfo)info).verifyingAnnotation, ((VerifierInfo)info).verifierClass);
        }
    }

    private static final class ConfigurationParser
    implements LineProcessor<Configuration> {
        private final int nextIndex;
        private int lineNumber = 0;
        private final ImmutableList.Builder<ArgInfo> positionalInfo = ImmutableList.builder();
        private final ImmutableList.Builder<ArgInfo> fieldInfoBuilder = ImmutableList.builder();
        private final ImmutableList.Builder<ParserInfo> parserInfoBuilder = ImmutableList.builder();
        private final ImmutableList.Builder<VerifierInfo> verifierInfoBuilder = ImmutableList.builder();

        private ConfigurationParser(int nextIndex) {
            this.nextIndex = nextIndex;
        }

        public boolean processLine(String line) throws IOException {
            ++this.lineNumber;
            String trimmed = line.trim();
            if (!trimmed.isEmpty() && !trimmed.startsWith("#")) {
                ArrayList parts = Lists.newArrayList((Object[])trimmed.split(" "));
                if (parts.size() < 1) {
                    throw new ConfigurationException("Invalid line: %s @%d", trimmed, this.lineNumber);
                }
                String type = (String)parts.remove(0);
                if ("positional".equals(type)) {
                    if (parts.size() != 2) {
                        throw new ConfigurationException("Invalid positional line: %s @%d", trimmed, this.lineNumber);
                    }
                    this.positionalInfo.add((Object)new ArgInfo((String)parts.get(0), (String)parts.get(1)));
                } else if ("field".equals(type)) {
                    if (parts.size() != 2) {
                        throw new ConfigurationException("Invalid field line: %s @%d", trimmed, this.lineNumber);
                    }
                    this.fieldInfoBuilder.add((Object)new ArgInfo((String)parts.get(0), (String)parts.get(1)));
                } else if ("parser".equals(type)) {
                    if (parts.size() != 2) {
                        throw new ConfigurationException("Invalid parser line: %s @%d", trimmed, this.lineNumber);
                    }
                    this.parserInfoBuilder.add((Object)new ParserInfo((String)parts.get(0), (String)parts.get(1)));
                } else if ("verifier".equals(type)) {
                    if (parts.size() != 3) {
                        throw new ConfigurationException("Invalid verifier line: %s @%d", trimmed, this.lineNumber);
                    }
                    this.verifierInfoBuilder.add((Object)new VerifierInfo((String)parts.get(0), (String)parts.get(1), (String)parts.get(2)));
                } else {
                    LOG.warning(String.format("Did not recognize entry type %s for line: %s @%d", type, trimmed, this.lineNumber));
                }
            }
            return true;
        }

        public Configuration getResult() {
            return new Configuration(this.nextIndex, (Iterable)this.positionalInfo.build(), (Iterable)this.fieldInfoBuilder.build(), (Iterable)this.parserInfoBuilder.build(), (Iterable)this.verifierInfoBuilder.build());
        }
    }

    static final class ConfigurationResources {
        private final int nextResourceIndex;
        private final Iterator<URL> resources;

        private ConfigurationResources(int nextResourceIndex, Iterator<URL> resources) {
            this.nextResourceIndex = nextResourceIndex;
            this.resources = resources;
        }
    }

    static class Builder {
        private final Set<ArgInfo> positionalInfos = Sets.newHashSet();
        private final Set<ArgInfo> argInfos = Sets.newHashSet();
        private final Set<ParserInfo> parserInfos = Sets.newHashSet();
        private final Set<VerifierInfo> verifierInfos = Sets.newHashSet();

        Builder() {
        }

        public boolean isEmpty() {
            return this.positionalInfos.isEmpty() && this.argInfos.isEmpty() && this.parserInfos.isEmpty() && this.verifierInfos.isEmpty();
        }

        void addPositionalInfo(ArgInfo positionalInfo) {
            this.positionalInfos.add(positionalInfo);
        }

        void addCmdLineArg(ArgInfo argInfo) {
            this.argInfos.add(argInfo);
        }

        void addParser(ParserInfo parserInfo) {
            this.parserInfos.add(parserInfo);
        }

        public void addParser(String parserForType, String parserType) {
            this.addParser(new ParserInfo(parserForType, parserType));
        }

        void addVerifier(VerifierInfo verifierInfo) {
            this.verifierInfos.add(verifierInfo);
        }

        public void addVerifier(String verifierForType, String annotationType, String verifierType) {
            this.addVerifier(new VerifierInfo(verifierForType, annotationType, verifierType));
        }

        public Configuration build(Configuration configuration) {
            return new Configuration(configuration.nextResourceIndex + 1, this.positionalInfos, this.argInfos, this.parserInfos, this.verifierInfos);
        }
    }

    public static final class VerifierInfo {
        public final String verifiedType;
        public final String verifyingAnnotation;
        public final String verifierClass;

        public VerifierInfo(String verifiedType, String verifyingAnnotation, String verifierClass) {
            this.verifiedType = Configuration.checkValidIdentifier(verifiedType, true);
            this.verifyingAnnotation = Configuration.checkValidIdentifier(verifyingAnnotation, true);
            this.verifierClass = Configuration.checkValidIdentifier(verifierClass, true);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VerifierInfo)) {
                return false;
            }
            VerifierInfo other = (VerifierInfo)obj;
            return new EqualsBuilder().append((Object)this.verifiedType, (Object)other.verifiedType).append((Object)this.verifyingAnnotation, (Object)other.verifyingAnnotation).append((Object)this.verifierClass, (Object)other.verifierClass).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.verifiedType).append((Object)this.verifyingAnnotation).append((Object)this.verifierClass).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("verifiedType", (Object)this.verifiedType).append("verifyingAnnotation", (Object)this.verifyingAnnotation).append("verifierClass", (Object)this.verifierClass).toString();
        }
    }

    public static final class ParserInfo {
        public final String parsedType;
        public final String parserClass;

        public ParserInfo(String parsedType, String parserClass) {
            this.parsedType = Configuration.checkValidIdentifier(parsedType, true);
            this.parserClass = Configuration.checkValidIdentifier(parserClass, true);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ParserInfo)) {
                return false;
            }
            ParserInfo other = (ParserInfo)obj;
            return new EqualsBuilder().append((Object)this.parsedType, (Object)other.parsedType).append((Object)this.parserClass, (Object)other.parserClass).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.parsedType).append((Object)this.parserClass).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("parsedType", (Object)this.parsedType).append("parserClass", (Object)this.parserClass).toString();
        }
    }

    public static final class ArgInfo {
        public final String className;
        public final String fieldName;

        public ArgInfo(String className, String fieldName) {
            this.className = Configuration.checkValidIdentifier(className, true);
            this.fieldName = Configuration.checkValidIdentifier(fieldName, false);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ArgInfo)) {
                return false;
            }
            ArgInfo other = (ArgInfo)obj;
            return new EqualsBuilder().append((Object)this.className, (Object)other.className).append((Object)this.fieldName, (Object)other.fieldName).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.className).append((Object)this.fieldName).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("className", (Object)this.className).append("fieldName", (Object)this.fieldName).toString();
        }
    }

    public static class ConfigurationException
    extends RuntimeException {
        public ConfigurationException(String message, Object ... args) {
            super(String.format(message, args));
        }

        public ConfigurationException(Throwable cause) {
            super(cause);
        }
    }
}

