/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.stats;

import com.twitter.finagle.stats.StatsReceiver;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.distributedlog.client.resolver.RegionResolver;
import org.apache.distributedlog.client.stats.OpStatsLogger;

public class OpStats {
    private final RegionResolver regionResolver;
    private final StatsReceiver statsReceiver;
    private final OpStatsLogger opStatsLogger;
    private final boolean enableRegionStats;
    private final ConcurrentMap<String, OpStatsLogger> regionOpStatsLoggers;

    public OpStats(StatsReceiver statsReceiver, boolean enableRegionStats, RegionResolver regionResolver) {
        this.statsReceiver = statsReceiver;
        this.opStatsLogger = new OpStatsLogger(statsReceiver);
        this.enableRegionStats = enableRegionStats;
        this.regionOpStatsLoggers = new ConcurrentHashMap<String, OpStatsLogger>();
        this.regionResolver = regionResolver;
    }

    private OpStatsLogger getRegionOpStatsLogger(SocketAddress address) {
        String region = this.regionResolver.resolveRegion(address);
        return this.getRegionOpStatsLogger(region);
    }

    private OpStatsLogger getRegionOpStatsLogger(String region) {
        OpStatsLogger statsLogger = (OpStatsLogger)this.regionOpStatsLoggers.get(region);
        if (null == statsLogger) {
            OpStatsLogger newStatsLogger = new OpStatsLogger(this.statsReceiver.scope(region));
            OpStatsLogger oldStatsLogger = this.regionOpStatsLoggers.putIfAbsent(region, newStatsLogger);
            statsLogger = null == oldStatsLogger ? newStatsLogger : oldStatsLogger;
        }
        return statsLogger;
    }

    public void completeRequest(SocketAddress addr, long micros, int numTries) {
        this.opStatsLogger.completeRequest(micros, numTries);
        if (this.enableRegionStats && null != addr) {
            this.getRegionOpStatsLogger(addr).completeRequest(micros, numTries);
        }
    }

    public void failRequest(SocketAddress addr, long micros, int numTries) {
        this.opStatsLogger.failRequest(micros, numTries);
        if (this.enableRegionStats && null != addr) {
            this.getRegionOpStatsLogger(addr).failRequest(micros, numTries);
        }
    }
}

