/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import java.util.LinkedHashMap;
import java.util.Set;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.List;

public class Options {
    private static final long serialVersionUID = 0L;
    public static final Context.Key<Options> optionsKey = new Context.Key();
    private LinkedHashMap<String, String> values;
    private List<Runnable> listeners = List.nil();

    public static Options instance(Context context) {
        Options instance = context.get(optionsKey);
        if (instance == null) {
            instance = new Options(context);
        }
        return instance;
    }

    protected Options(Context context) {
        this.values = new LinkedHashMap();
        context.put(optionsKey, this);
    }

    public String get(String name) {
        return this.values.get(name);
    }

    public String get(Option option) {
        return this.values.get(option.text);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public boolean isSet(String name) {
        return this.values.get(name) != null;
    }

    public boolean isSet(Option option) {
        return this.values.get(option.text) != null;
    }

    public boolean isSet(Option option, String value) {
        return this.values.get(option.text + value) != null;
    }

    public boolean isUnset(String name) {
        return this.values.get(name) == null;
    }

    public boolean isUnset(Option option) {
        return this.values.get(option.text) == null;
    }

    public boolean isUnset(Option option, String value) {
        return this.values.get(option.text + value) == null;
    }

    public void put(String name, String value) {
        this.values.put(name, value);
    }

    public void put(Option option, String value) {
        this.values.put(option.text, value);
    }

    public void putAll(Options options) {
        this.values.putAll(options.values);
    }

    public void remove(String name) {
        this.values.remove(name);
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public int size() {
        return this.values.size();
    }

    public void addListener(Runnable listener) {
        this.listeners = this.listeners.prepend(listener);
    }

    public void notifyListeners() {
        for (Runnable r : this.listeners) {
            r.run();
        }
    }

    public boolean lint(String s) {
        return this.isSet(Option.XLINT_CUSTOM, s) || (this.isSet(Option.XLINT) || this.isSet(Option.XLINT_CUSTOM, "all")) && this.isUnset(Option.XLINT_CUSTOM, "-" + s);
    }
}

