/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SectionName;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.ConstantsSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocLink;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;

public class ConstantsSummaryWriterImpl
extends HtmlDocletWriter
implements ConstantsSummaryWriter {
    ConfigurationImpl configuration;
    private TypeElement currentTypeElement;
    private final String constantsTableSummary;
    private final List<String> constantsTableHeader;
    private HtmlTree mainTree = HtmlTree.MAIN();
    private HtmlTree summaryTree;

    public ConstantsSummaryWriterImpl(ConfigurationImpl configuration) throws IOException {
        super(configuration, DocPaths.CONSTANT_VALUES);
        this.configuration = configuration;
        this.constantsTableSummary = configuration.getText("doclet.Constants_Table_Summary", configuration.getText("doclet.Constants_Summary"));
        this.constantsTableHeader = new ArrayList<String>();
        this.constantsTableHeader.add(this.getModifierTypeHeader());
        this.constantsTableHeader.add(configuration.getText("doclet.ConstantField"));
        this.constantsTableHeader.add(configuration.getText("doclet.Value"));
    }

    @Override
    public Content getHeader() {
        String label = this.configuration.getText("doclet.Constants_Summary");
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(label));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        return bodyTree;
    }

    @Override
    public Content getContentsHeader() {
        return new HtmlTree(HtmlTag.UL);
    }

    @Override
    public void addLinkToPackageContent(PackageElement pkg, Set<PackageElement> printedPackageHeaders, Content contentListTree) {
        Content link;
        if (pkg.isUnnamed()) {
            link = this.getHyperLink(this.getDocLink(SectionName.UNNAMED_PACKAGE_ANCHOR), this.defaultPackageLabel, "", "");
        } else {
            String parsedPackageName = this.utils.parsePackageName(pkg);
            Content packageNameContent = this.getPackageLabel(parsedPackageName);
            packageNameContent.addContent(".*");
            link = this.getHyperLink(DocLink.fragment(parsedPackageName), packageNameContent, "", "");
            PackageElement abbrevPkg = this.utils.elementUtils.getPackageElement(parsedPackageName);
            printedPackageHeaders.add(abbrevPkg);
        }
        contentListTree.addContent(HtmlTree.LI(link));
    }

    @Override
    public void addContentsList(Content contentTree, Content contentListTree) {
        Content titleContent = this.getResource("doclet.Constants_Summary");
        HtmlTree pHeading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, titleContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, pHeading);
        Content headingContent = this.getResource("doclet.Contents");
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, headingContent);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            HtmlTree section = HtmlTree.SECTION(heading);
            section.addContent(contentListTree);
            ((Content)div).addContent(section);
            this.mainTree.addContent(div);
        } else {
            ((Content)div).addContent(heading);
            ((Content)div).addContent(contentListTree);
            contentTree.addContent(div);
        }
    }

    @Override
    public Content getConstantSummaries() {
        HtmlTree summariesDiv = new HtmlTree(HtmlTag.DIV);
        summariesDiv.addStyle(HtmlStyle.constantValuesContainer);
        return summariesDiv;
    }

    @Override
    public void addPackageName(PackageElement pkg, Content summariesTree, boolean first) {
        Content pkgNameContent;
        if (!first && this.configuration.allowTag(HtmlTag.SECTION)) {
            summariesTree.addContent(this.summaryTree);
        }
        if (pkg.isUnnamed()) {
            summariesTree.addContent(this.getMarkerAnchor(SectionName.UNNAMED_PACKAGE_ANCHOR));
            pkgNameContent = this.defaultPackageLabel;
        } else {
            String parsedPackageName = this.utils.parsePackageName(pkg);
            summariesTree.addContent(this.getMarkerAnchor(parsedPackageName));
            pkgNameContent = this.getPackageLabel(parsedPackageName);
        }
        StringContent headingContent = new StringContent(".*");
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, pkgNameContent);
        ((Content)heading).addContent(headingContent);
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            this.summaryTree = HtmlTree.SECTION(heading);
        } else {
            summariesTree.addContent(heading);
        }
    }

    @Override
    public Content getClassConstantHeader() {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        return ul;
    }

    @Override
    public void addClassConstant(Content summariesTree, Content classConstantTree) {
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            this.summaryTree.addContent(classConstantTree);
        } else {
            summariesTree.addContent(classConstantTree);
        }
    }

    public Content getConstantMembersHeader(TypeElement typeElement) {
        Content classlink = this.utils.isPublic(typeElement) || this.utils.isProtected(typeElement) ? this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CONSTANT_SUMMARY, typeElement)) : new StringContent(this.utils.getFullyQualifiedName(typeElement));
        PackageElement enclosingPackage = this.utils.containingPackage(typeElement);
        if (!enclosingPackage.isUnnamed()) {
            ContentBuilder cb = new ContentBuilder();
            ((Content)cb).addContent(enclosingPackage.getQualifiedName());
            ((Content)cb).addContent(".");
            ((Content)cb).addContent(classlink);
            return this.getClassName(cb);
        }
        return this.getClassName(classlink);
    }

    protected Content getClassName(Content classStr) {
        Content caption = this.getTableCaption(classStr);
        HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.constantsSummary, caption) : HtmlTree.TABLE(HtmlStyle.constantsSummary, this.constantsTableSummary, caption);
        ((Content)table).addContent(this.getSummaryTableHeader(this.constantsTableHeader, "col"));
        return table;
    }

    @Override
    public void addConstantMembers(TypeElement typeElement, Collection<VariableElement> fields, Content classConstantTree) {
        this.currentTypeElement = typeElement;
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        boolean altColor = true;
        for (VariableElement field : fields) {
            HtmlTree tr = new HtmlTree(HtmlTag.TR);
            tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
            this.addConstantMember(field, tr);
            ((Content)tbody).addContent(tr);
            altColor = !altColor;
        }
        Content table = this.getConstantMembersHeader(typeElement);
        table.addContent(tbody);
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
        classConstantTree.addContent(li);
    }

    private void addConstantMember(VariableElement member, HtmlTree trTree) {
        trTree.addContent(this.getTypeColumn(member));
        trTree.addContent(this.getNameColumn(member));
        trTree.addContent(this.getValue(member));
    }

    private Content getTypeColumn(VariableElement member) {
        Content anchor = this.getMarkerAnchor(this.currentTypeElement.getQualifiedName() + "." + member.getSimpleName());
        HtmlTree tdType = HtmlTree.TD(HtmlStyle.colFirst, anchor);
        HtmlTree code = new HtmlTree(HtmlTag.CODE);
        for (Modifier mod : member.getModifiers()) {
            StringContent modifier = new StringContent(mod.toString());
            ((Content)code).addContent(modifier);
            ((Content)code).addContent(this.getSpace());
        }
        Content type = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CONSTANT_SUMMARY, member.asType()));
        ((Content)code).addContent(type);
        ((Content)tdType).addContent(code);
        return tdType;
    }

    private Content getNameColumn(VariableElement member) {
        Content nameContent = this.getDocLink(LinkInfoImpl.Kind.CONSTANT_SUMMARY, member, member.getSimpleName(), false);
        HtmlTree code = HtmlTree.CODE(nameContent);
        return HtmlTree.TD(code);
    }

    private Content getValue(VariableElement member) {
        String value = this.utils.constantValueExpresion(member);
        StringContent valueContent = new StringContent(value);
        HtmlTree code = HtmlTree.CODE(valueContent);
        return HtmlTree.TD(HtmlStyle.colLast, code);
    }

    @Override
    public void addConstantSummaries(Content contentTree, Content summariesTree) {
        if (this.configuration.allowTag(HtmlTag.SECTION) && this.summaryTree != null) {
            summariesTree.addContent(this.summaryTree);
        }
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(summariesTree);
            contentTree.addContent(this.mainTree);
        } else {
            contentTree.addContent(summariesTree);
        }
    }

    @Override
    public void addFooter(Content contentTree) {
        Content htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : contentTree;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            contentTree.addContent(htmlTree);
        }
    }

    @Override
    public void printDocument(Content contentTree) throws IOException {
        this.printHtmlDocument(null, true, contentTree);
    }
}

