/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.zookeeper;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.twitter.common.base.Command;
import com.twitter.common.base.Commands;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.net.pool.DynamicHostSet;
import com.twitter.common.zookeeper.Group;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.thrift.ServiceInstance;
import com.twitter.thrift.Status;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;

public class CompoundServerSet
implements ServerSet {
    private static final Joiner STACK_TRACE_JOINER = Joiner.on((char)'\n');
    private final List<ServerSet> serverSets;
    private final Map<ServerSet, ImmutableSet<ServiceInstance>> instanceCache = Maps.newHashMap();
    private final List<DynamicHostSet.HostChangeMonitor<ServiceInstance>> monitors = Lists.newArrayList();
    private Command stopWatching = null;
    private ImmutableSet<ServiceInstance> allHosts = ImmutableSet.of();

    public CompoundServerSet(Iterable<ServerSet> serverSets) {
        MorePreconditions.checkNotBlank(serverSets);
        this.serverSets = ImmutableList.copyOf(serverSets);
    }

    private void changeStatus(ImmutableList<ServerSet.EndpointStatus> statuses, StatusOp statusOp) throws ServerSet.UpdateException {
        ImmutableList.Builder builder = ImmutableList.builder();
        int errorIdx = 1;
        for (ServerSet.EndpointStatus endpointStatus : statuses) {
            try {
                statusOp.changeStatus(endpointStatus);
            }
            catch (ServerSet.UpdateException exception) {
                builder.add((Object)String.format("[%d] %s", errorIdx++, Throwables.getStackTraceAsString((Throwable)exception)));
            }
        }
        if (errorIdx > 1) {
            throw new ServerSet.UpdateException("One or more ServerSet update failed: " + STACK_TRACE_JOINER.join((Iterable)builder.build()));
        }
    }

    private ServerSet.EndpointStatus doJoin(JoinOp joiner) throws Group.JoinException, InterruptedException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ServerSet serverSet : this.serverSets) {
            builder.add((Object)joiner.doJoin(serverSet));
        }
        final ImmutableList statuses = builder.build();
        return new ServerSet.EndpointStatus(){

            @Override
            public void leave() throws ServerSet.UpdateException {
                CompoundServerSet.this.changeStatus((ImmutableList<ServerSet.EndpointStatus>)statuses, new StatusOp(){

                    @Override
                    public void changeStatus(ServerSet.EndpointStatus status) throws ServerSet.UpdateException {
                        status.leave();
                    }
                });
            }

            @Override
            public void update(final Status newStatus) throws ServerSet.UpdateException {
                CompoundServerSet.this.changeStatus((ImmutableList<ServerSet.EndpointStatus>)statuses, new StatusOp(){

                    @Override
                    public void changeStatus(ServerSet.EndpointStatus status) throws ServerSet.UpdateException {
                        status.update(newStatus);
                    }
                });
            }
        };
    }

    @Override
    public ServerSet.EndpointStatus join(final InetSocketAddress endpoint, final Map<String, InetSocketAddress> additionalEndpoints) throws Group.JoinException, InterruptedException {
        return this.doJoin(new JoinOp(){

            @Override
            public ServerSet.EndpointStatus doJoin(ServerSet serverSet) throws Group.JoinException, InterruptedException {
                return serverSet.join(endpoint, additionalEndpoints);
            }
        });
    }

    @Override
    public ServerSet.EndpointStatus join(final InetSocketAddress endpoint, final Map<String, InetSocketAddress> additionalEndpoints, final Status status) throws Group.JoinException, InterruptedException {
        return this.doJoin(new JoinOp(){

            @Override
            public ServerSet.EndpointStatus doJoin(ServerSet serverSet) throws Group.JoinException, InterruptedException {
                return serverSet.join(endpoint, (Map<String, InetSocketAddress>)additionalEndpoints, status);
            }
        });
    }

    @Override
    public ServerSet.EndpointStatus join(final InetSocketAddress endpoint, final Map<String, InetSocketAddress> additionalEndpoints, final int shardId) throws Group.JoinException, InterruptedException {
        return this.doJoin(new JoinOp(){

            @Override
            public ServerSet.EndpointStatus doJoin(ServerSet serverSet) throws Group.JoinException, InterruptedException {
                return serverSet.join(endpoint, (Map<String, InetSocketAddress>)additionalEndpoints, shardId);
            }
        });
    }

    private synchronized void handleChange(ServerSet serverSet, ImmutableSet<ServiceInstance> hosts) {
        this.instanceCache.put(serverSet, hosts);
        ImmutableSet currentHosts = ImmutableSet.copyOf((Iterable)Iterables.concat(this.instanceCache.values()));
        if (!currentHosts.equals(this.allHosts)) {
            this.allHosts = currentHosts;
            for (DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor : this.monitors) {
                monitor.onChange(this.allHosts);
            }
        }
    }

    public synchronized Command watch(DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) throws DynamicHostSet.MonitorException {
        if (this.stopWatching == null) {
            this.monitors.add(monitor);
            ImmutableList.Builder commandsBuilder = ImmutableList.builder();
            for (final ServerSet serverSet : this.serverSets) {
                commandsBuilder.add((Object)serverSet.watch((DynamicHostSet.HostChangeMonitor)new DynamicHostSet.HostChangeMonitor<ServiceInstance>(){

                    public void onChange(ImmutableSet<ServiceInstance> hostSet) {
                        CompoundServerSet.this.handleChange(serverSet, (ImmutableSet<ServiceInstance>)hostSet);
                    }
                }));
            }
            this.stopWatching = Commands.compound((Iterable)commandsBuilder.build());
        }
        return this.stopWatching;
    }

    public void monitor(DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) throws DynamicHostSet.MonitorException {
        this.watch(monitor);
    }

    private static interface StatusOp {
        public void changeStatus(ServerSet.EndpointStatus var1) throws ServerSet.UpdateException;
    }

    private static interface JoinOp {
        public ServerSet.EndpointStatus doJoin(ServerSet var1) throws Group.JoinException, InterruptedException;
    }
}

