/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import bk-shade.com.google.common.base.Charsets;
import bk-shade.com.google.common.base.Preconditions;
import bk-shade.com.google.common.util.concurrent.AbstractFuture;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookiesListener;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerFragmentReplicator;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.LedgerOpenOp;
import org.apache.bookkeeper.client.RoundRobinDistributionSchedule;
import org.apache.bookkeeper.client.SynchCallbackUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.replication.BookieLedgerIndexer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperAdmin
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BookKeeperAdmin.class);
    private ZooKeeper zk;
    private final boolean ownsZK;
    private final String bookiesPath;
    private BookKeeper bkc;
    private final boolean ownsBK;
    private LedgerFragmentReplicator lfr;
    private Random rand = new Random();
    private LedgerManagerFactory mFactory;
    private LedgerUnderreplicationManager underreplicationManager;

    public BookKeeperAdmin(String zkServers) throws IOException, InterruptedException, KeeperException {
        this(new ClientConfiguration().setZkServers(zkServers));
    }

    public BookKeeperAdmin(ClientConfiguration conf) throws IOException, InterruptedException, KeeperException {
        this.zk = ZooKeeperClient.newBuilder().connectString(conf.getZkServers()).sessionTimeoutMs(conf.getZkTimeout()).build();
        this.ownsZK = true;
        this.bookiesPath = conf.getZkAvailableBookiesPath();
        this.bkc = new BookKeeper(conf, this.zk);
        this.ownsBK = true;
        this.lfr = new LedgerFragmentReplicator(this.bkc, (StatsLogger)NullStatsLogger.INSTANCE);
        this.mFactory = this.bkc.ledgerManagerFactory;
    }

    public BookKeeperAdmin(BookKeeper bkc, StatsLogger statsLogger) {
        this.bkc = bkc;
        this.ownsBK = false;
        this.zk = bkc.zk;
        this.ownsZK = false;
        this.bookiesPath = bkc.getConf().getZkAvailableBookiesPath();
        this.lfr = new LedgerFragmentReplicator(bkc, statsLogger);
        this.mFactory = bkc.ledgerManagerFactory;
    }

    public BookKeeperAdmin(BookKeeper bkc) {
        this(bkc, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    @Override
    public void close() throws InterruptedException, BKException {
        if (this.ownsBK) {
            this.bkc.close();
        }
        if (this.ownsZK) {
            this.zk.close();
        }
    }

    public ZooKeeper getZooKeeper() {
        return this.zk;
    }

    public Collection<BookieSocketAddress> getAvailableBookies() throws BKException {
        return this.bkc.bookieWatcher.getBookies();
    }

    public Collection<BookieSocketAddress> getReadOnlyBookies() {
        return this.bkc.bookieWatcher.getReadOnlyBookies();
    }

    public void notifyBookiesChanged(BookiesListener listener) throws BKException {
        this.bkc.bookieWatcher.notifyBookiesChanged(listener);
    }

    public void notifyReadOnlyBookiesChanged(BookiesListener listener) throws BKException {
        this.bkc.bookieWatcher.notifyReadOnlyBookiesChanged(listener);
    }

    public void asyncOpenLedger(long lId, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this.bkc, lId, cb, ctx).initiate();
    }

    public LedgerHandle openLedger(long lId) throws InterruptedException, BKException {
        CompletableFuture counter = new CompletableFuture();
        new LedgerOpenOp(this.bkc, lId, new BookKeeper.SyncOpenCallback(), counter).initiate();
        return (LedgerHandle)SynchCallbackUtils.waitForResult(counter);
    }

    public void asyncOpenLedgerNoRecovery(long lId, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this.bkc, lId, cb, ctx).initiateWithoutRecovery();
    }

    public LedgerHandle openLedgerNoRecovery(long lId) throws InterruptedException, BKException {
        CompletableFuture counter = new CompletableFuture();
        new LedgerOpenOp(this.bkc, lId, new BookKeeper.SyncOpenCallback(), counter).initiateWithoutRecovery();
        return (LedgerHandle)SynchCallbackUtils.waitForResult(counter);
    }

    public Iterable<LedgerEntry> readEntries(long ledgerId, long firstEntry, long lastEntry) throws InterruptedException, BKException {
        Preconditions.checkArgument(ledgerId >= 0L && firstEntry >= 0L);
        return new LedgerEntriesIterable(ledgerId, firstEntry, lastEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverBookieData(BookieSocketAddress bookieSrc, BookieSocketAddress bookieDest) throws InterruptedException, BKException {
        SyncObject sync = new SyncObject();
        this.asyncRecoverBookieData(bookieSrc, bookieDest, new AsyncCallback.RecoverCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recoverComplete(int rc, Object ctx) {
                SyncObject syncObj;
                LOG.info("Recover bookie operation completed with rc: " + rc);
                SyncObject syncObject = syncObj = (SyncObject)ctx;
                synchronized (syncObject) {
                    syncObj.rc = rc;
                    syncObj.value = true;
                    syncObj.notify();
                }
            }
        }, sync);
        SyncObject syncObject = sync;
        synchronized (syncObject) {
            while (!sync.value) {
                sync.wait();
            }
        }
        if (sync.rc != 0) {
            throw BKException.create(sync.rc);
        }
    }

    public void asyncRecoverBookieData(final BookieSocketAddress bookieSrc, final BookieSocketAddress bookieDest, final AsyncCallback.RecoverCallback cb, final Object context) {
        this.zk.sync(this.bookiesPath, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("ZK error syncing: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    cb.recoverComplete(-9, context);
                    return;
                }
                BookKeeperAdmin.this.getAvailableBookies(bookieSrc, bookieDest, cb, context);
            }
        }, null);
    }

    private void getAvailableBookies(final BookieSocketAddress bookieSrc, BookieSocketAddress bookieDest, final AsyncCallback.RecoverCallback cb, final Object context) {
        final LinkedList<BookieSocketAddress> availableBookies = new LinkedList<BookieSocketAddress>();
        if (bookieDest != null) {
            availableBookies.add(bookieDest);
            this.getActiveLedgers(bookieSrc, bookieDest, cb, context, availableBookies);
        } else {
            this.zk.getChildren(this.bookiesPath, null, new AsyncCallback.ChildrenCallback(){

                public void processResult(int rc, String path, Object ctx, List<String> children) {
                    if (rc != KeeperException.Code.OK.intValue()) {
                        LOG.error("ZK error getting bookie nodes: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                        cb.recoverComplete(-9, context);
                        return;
                    }
                    for (String bookieNode : children) {
                        BookieSocketAddress addr;
                        if ("readonly".equals(bookieNode)) continue;
                        try {
                            addr = new BookieSocketAddress(bookieNode);
                        }
                        catch (UnknownHostException nhe) {
                            LOG.error("Bookie Node retrieved from ZK has invalid name format: " + bookieNode);
                            cb.recoverComplete(-9, context);
                            return;
                        }
                        availableBookies.add(addr);
                    }
                    BookKeeperAdmin.this.getActiveLedgers(bookieSrc, null, cb, context, availableBookies);
                }
            }, null);
        }
    }

    private void getActiveLedgers(final BookieSocketAddress bookieSrc, BookieSocketAddress bookieDest, AsyncCallback.RecoverCallback cb, Object context, final List<BookieSocketAddress> availableBookies) {
        BookkeeperInternalCallbacks.Processor<Long> ledgerProcessor = new BookkeeperInternalCallbacks.Processor<Long>(){

            @Override
            public void process(Long ledgerId, AsyncCallback.VoidCallback iterCallback) {
                BookKeeperAdmin.this.recoverLedger(bookieSrc, ledgerId, iterCallback, availableBookies);
            }
        };
        class RecoverCallbackWrapper
        implements AsyncCallback.VoidCallback {
            final AsyncCallback.RecoverCallback cb;

            RecoverCallbackWrapper(AsyncCallback.RecoverCallback cb) {
                this.cb = cb;
            }

            public void processResult(int rc, String path, Object ctx) {
                this.cb.recoverComplete(BookKeeperAdmin.this.bkc.getReturnRc(rc), ctx);
            }
        }
        this.bkc.getLedgerManager().asyncProcessLedgers(ledgerProcessor, new RecoverCallbackWrapper(cb), context, 0, -10);
    }

    private BookieSocketAddress getNewBookie(List<BookieSocketAddress> bookiesAlreadyInEnsemble, List<BookieSocketAddress> availableBookies) throws BKException.BKNotEnoughBookiesException {
        ArrayList<BookieSocketAddress> candidates = new ArrayList<BookieSocketAddress>();
        candidates.addAll(availableBookies);
        candidates.removeAll(bookiesAlreadyInEnsemble);
        if (candidates.size() == 0) {
            throw new BKException.BKNotEnoughBookiesException();
        }
        return (BookieSocketAddress)candidates.get(this.rand.nextInt(candidates.size()));
    }

    private void recoverLedger(final BookieSocketAddress bookieSrc, final long lId, final AsyncCallback.VoidCallback ledgerIterCb, final List<BookieSocketAddress> availableBookies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recovering ledger : {}", (Object)lId);
        }
        this.asyncOpenLedgerNoRecovery(lId, new AsyncCallback.OpenCallback(){

            @Override
            public void openComplete(int rc, LedgerHandle lh, Object ctx) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("BK error opening ledger: " + lId, (Throwable)BKException.create(rc));
                    ledgerIterCb.processResult(rc, null, null);
                    return;
                }
                LedgerMetadata lm = lh.getLedgerMetadata();
                if (!lm.isClosed() && lm.getEnsembles().size() > 0) {
                    Long lastKey = lm.getEnsembles().lastKey();
                    ArrayList lastEnsemble = (ArrayList)lm.getEnsembles().get(lastKey);
                    if (lastEnsemble.contains(bookieSrc)) {
                        try {
                            lh.close();
                        }
                        catch (Exception ie) {
                            LOG.warn("Error closing non recovery ledger handle for ledger " + lId, (Throwable)ie);
                        }
                        BookKeeperAdmin.this.asyncOpenLedger(lId, new AsyncCallback.OpenCallback(){

                            @Override
                            public void openComplete(int newrc, LedgerHandle newlh, Object newctx) {
                                if (newrc != KeeperException.Code.OK.intValue()) {
                                    LOG.error("BK error close ledger: " + lId, (Throwable)BKException.create(newrc));
                                    ledgerIterCb.processResult(newrc, null, null);
                                    return;
                                }
                                BookKeeperAdmin.this.recoverLedger(bookieSrc, lId, ledgerIterCb, availableBookies);
                            }
                        }, null);
                        return;
                    }
                }
                LinkedList<Long> ledgerFragmentsToRecover = new LinkedList<Long>();
                HashMap<Long, Long> ledgerFragmentsRange = new HashMap<Long, Long>();
                Long curEntryId = null;
                for (Map.Entry<Long, ArrayList<BookieSocketAddress>> entry : lh.getLedgerMetadata().getEnsembles().entrySet()) {
                    if (curEntryId != null) {
                        ledgerFragmentsRange.put(curEntryId, entry.getKey() - 1L);
                    }
                    curEntryId = entry.getKey();
                    if (!entry.getValue().contains(bookieSrc)) continue;
                    ledgerFragmentsToRecover.add(entry.getKey());
                }
                if (curEntryId != null) {
                    ledgerFragmentsRange.put(curEntryId, lh.getLastAddConfirmed());
                }
                if (ledgerFragmentsToRecover.size() == 0) {
                    ledgerIterCb.processResult(0, null, null);
                    return;
                }
                BookkeeperInternalCallbacks.MultiCallback ledgerFragmentsMcb = new BookkeeperInternalCallbacks.MultiCallback(ledgerFragmentsToRecover.size(), ledgerIterCb, null, 0, -10);
                for (Long startEntryId : ledgerFragmentsToRecover) {
                    Long endEntryId = (Long)ledgerFragmentsRange.get(startEntryId);
                    BookieSocketAddress newBookie = null;
                    try {
                        newBookie = BookKeeperAdmin.this.getNewBookie((List)lh.getLedgerMetadata().getEnsembles().get(startEntryId), availableBookies);
                    }
                    catch (BKException.BKNotEnoughBookiesException bke) {
                        ledgerFragmentsMcb.processResult(-6, null, null);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Replicating fragment from [" + startEntryId + "," + endEntryId + "] of ledger " + lh.getId() + " to " + newBookie);
                    }
                    try {
                        LedgerFragmentReplicator.SingleFragmentCallback cb = new LedgerFragmentReplicator.SingleFragmentCallback(ledgerFragmentsMcb, lh, startEntryId, bookieSrc, newBookie);
                        ArrayList<BookieSocketAddress> currentEnsemble = lh.getLedgerMetadata().getEnsemble(startEntryId);
                        int bookieIndex = -1;
                        if (null != currentEnsemble) {
                            for (int i = 0; i < currentEnsemble.size(); ++i) {
                                if (!currentEnsemble.get(i).equals(bookieSrc)) continue;
                                bookieIndex = i;
                                break;
                            }
                        }
                        LedgerFragment ledgerFragment = new LedgerFragment(lh, startEntryId, endEntryId, bookieIndex);
                        BookKeeperAdmin.this.asyncRecoverLedgerFragment(lh, ledgerFragment, cb, newBookie);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }, null);
    }

    private void asyncRecoverLedgerFragment(LedgerHandle lh, LedgerFragment ledgerFragment, AsyncCallback.VoidCallback ledgerFragmentMcb, BookieSocketAddress newBookie) throws InterruptedException {
        this.lfr.replicate(lh, ledgerFragment, ledgerFragmentMcb, newBookie);
    }

    public void replicateLedgerFragment(LedgerHandle lh, LedgerFragment ledgerFragment, BookieSocketAddress targetBookieAddress) throws InterruptedException, BKException {
        CompletableFuture<Void> counter = new CompletableFuture<Void>();
        ResultCallBack resultCallBack = new ResultCallBack(counter);
        LedgerFragmentReplicator.SingleFragmentCallback cb = new LedgerFragmentReplicator.SingleFragmentCallback(resultCallBack, lh, ledgerFragment.getFirstEntryId(), ledgerFragment.getAddress(), targetBookieAddress);
        this.asyncRecoverLedgerFragment(lh, ledgerFragment, cb, targetBookieAddress);
        try {
            SynchCallbackUtils.waitForResult(counter);
        }
        catch (BKException err) {
            throw BKException.create(this.bkc.getReturnRc(err.getCode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean format(ClientConfiguration conf, boolean isInteractive, boolean force) throws Exception {
        ZooKeeperClient zkc = ZooKeeperClient.newBuilder().connectString(conf.getZkServers()).sessionTimeoutMs(conf.getZkTimeout()).build();
        BookKeeper bkc = null;
        try {
            List<ACL> zkAcls;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            boolean ledgerRootExists = null != zkc.exists(conf.getZkLedgersRootPath(), false);
                            boolean availableNodeExists = null != zkc.exists(conf.getZkAvailableBookiesPath(), false);
                            zkAcls = ZkUtils.getACLs(conf);
                            if (!ledgerRootExists) {
                                zkc.create(conf.getZkLedgersRootPath(), "".getBytes(Charsets.UTF_8), zkAcls, CreateMode.PERSISTENT);
                            }
                            if (!availableNodeExists) {
                                zkc.create(conf.getZkAvailableBookiesPath(), "".getBytes(Charsets.UTF_8), zkAcls, CreateMode.PERSISTENT);
                            }
                            if (ledgerRootExists) {
                                boolean confirm = false;
                                confirm = !isInteractive ? force : IOUtils.confirmPrompt("Ledger root already exists. Are you sure to format bookkeeper metadata? This may cause data loss.");
                                if (!confirm) {
                                    LOG.error("BookKeeper metadata Format aborted!!");
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                            bkc = new BookKeeper(conf, zkc);
                            bkc.ledgerManagerFactory.format(conf, zkc);
                            try {
                                ZKUtil.deleteRecursive((ZooKeeper)zkc, (String)(ZkLedgerUnderreplicationManager.getBasePath(conf.getZkLedgersRootPath()) + "/ledgers"));
                            }
                            catch (KeeperException.NoNodeException e) {
                                if (!LOG.isDebugEnabled()) break block18;
                                LOG.debug("underreplicated ledgers root path node not exists in zookeeper to delete");
                            }
                        }
                        try {
                            ZKUtil.deleteRecursive((ZooKeeper)zkc, (String)(ZkLedgerUnderreplicationManager.getBasePath(conf.getZkLedgersRootPath()) + '/' + "locks"));
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (!LOG.isDebugEnabled()) break block19;
                            LOG.debug("underreplicatedledger locks node not exists in zookeeper to delete");
                        }
                    }
                    try {
                        ZKUtil.deleteRecursive((ZooKeeper)zkc, (String)(conf.getZkLedgersRootPath() + "/cookies"));
                    }
                    catch (KeeperException.NoNodeException e) {
                        if (!LOG.isDebugEnabled()) break block20;
                        LOG.debug("cookies node not exists in zookeeper to delete");
                    }
                }
                try {
                    zkc.delete(conf.getZkLedgersRootPath() + "/" + "INSTANCEID", -1);
                }
                catch (KeeperException.NoNodeException e) {
                    if (!LOG.isDebugEnabled()) break block21;
                    LOG.debug("INSTANCEID not exists in zookeeper to delete");
                }
            }
            String instanceId = UUID.randomUUID().toString();
            zkc.create(conf.getZkLedgersRootPath() + "/" + "INSTANCEID", instanceId.getBytes(Charsets.UTF_8), zkAcls, CreateMode.PERSISTENT);
            LOG.info("Successfully formatted BookKeeper metadata");
        }
        finally {
            if (null != bkc) {
                bkc.close();
            }
            if (null != zkc) {
                zkc.close();
            }
        }
        return true;
    }

    public Iterable<Long> listLedgers() throws IOException {
        final LedgerManager.LedgerRangeIterator iterator = this.bkc.getLedgerManager().getLedgerRanges();
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){
                    Iterator<Long> currentRange = null;

                    @Override
                    public boolean hasNext() {
                        try {
                            if (iterator.hasNext()) {
                                return true;
                            }
                            if (this.currentRange != null && this.currentRange.hasNext()) {
                                return true;
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Error while checking if there is a next element", (Throwable)e);
                        }
                        return false;
                    }

                    @Override
                    public Long next() throws NoSuchElementException {
                        try {
                            if (this.currentRange == null || !this.currentRange.hasNext()) {
                                this.currentRange = iterator.next().getLedgers().iterator();
                            }
                        }
                        catch (IOException e) {
                            LOG.error("Error while reading the next element", (Throwable)e);
                            throw new NoSuchElementException(e.getMessage());
                        }
                        return this.currentRange.next();
                    }

                    @Override
                    public void remove() throws UnsupportedOperationException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public LedgerMetadata getLedgerMetadata(LedgerHandle lh) {
        return lh.getLedgerMetadata();
    }

    private LedgerUnderreplicationManager getUnderreplicationManager() throws ReplicationException.CompatibilityException, KeeperException, InterruptedException {
        if (this.underreplicationManager == null) {
            this.underreplicationManager = this.mFactory.newLedgerUnderreplicationManager();
        }
        return this.underreplicationManager;
    }

    public void setLostBookieRecoveryDelay(int lostBookieRecoveryDelay) throws ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException {
        LedgerUnderreplicationManager urlManager = this.getUnderreplicationManager();
        urlManager.setLostBookieRecoveryDelay(lostBookieRecoveryDelay);
    }

    public int getLostBookieRecoveryDelay() throws ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException {
        LedgerUnderreplicationManager urlManager = this.getUnderreplicationManager();
        return urlManager.getLostBookieRecoveryDelay();
    }

    public void triggerAudit() throws ReplicationException.CompatibilityException, KeeperException, InterruptedException, ReplicationException.UnavailableException, IOException {
        LedgerUnderreplicationManager urlManager = this.getUnderreplicationManager();
        if (!urlManager.isLedgerReplicationEnabled()) {
            LOG.error("Autorecovery is disabled. So giving up!");
            throw new ReplicationException.UnavailableException("Autorecovery is disabled. So giving up!");
        }
        BookieSocketAddress auditorId = AuditorElector.getCurrentAuditor(new ServerConfiguration(this.bkc.conf), this.zk);
        if (auditorId == null) {
            LOG.error("No auditor elected, though Autorecovery is enabled. So giving up.");
            throw new ReplicationException.UnavailableException("No auditor elected, though Autorecovery is enabled. So giving up.");
        }
        int previousLostBookieRecoveryDelayValue = urlManager.getLostBookieRecoveryDelay();
        LOG.info("Resetting LostBookieRecoveryDelay value: {}, to kickstart audit task", (Object)previousLostBookieRecoveryDelayValue);
        urlManager.setLostBookieRecoveryDelay(previousLostBookieRecoveryDelayValue);
    }

    public void decommissionBookie(BookieSocketAddress bookieAddress) throws ReplicationException.CompatibilityException, ReplicationException.UnavailableException, KeeperException, InterruptedException, IOException, ReplicationException.BKAuditException, TimeoutException, BKException {
        Predicate<List<String>> predicate;
        Iterator<Long> urLedgerIterator;
        if (this.getAvailableBookies().contains(bookieAddress) || this.getReadOnlyBookies().contains(bookieAddress)) {
            LOG.error("Bookie: {} is not shutdown yet", (Object)bookieAddress);
            throw BKException.create(-100);
        }
        this.triggerAudit();
        Thread.sleep(30000L);
        BookieLedgerIndexer bookieLedgerIndexer = new BookieLedgerIndexer(this.bkc.ledgerManager);
        Map<String, Set<Long>> bookieToLedgersMap = bookieLedgerIndexer.getBookieToLedgerIndex();
        Set<Long> ledgersStoredInThisBookie = bookieToLedgersMap.get(bookieAddress.toString());
        if (ledgersStoredInThisBookie != null && !ledgersStoredInThisBookie.isEmpty()) {
            this.waitForLedgersToBeReplicated(ledgersStoredInThisBookie, bookieAddress, this.bkc.ledgerManager);
        }
        if ((urLedgerIterator = this.underreplicationManager.listLedgersToRereplicate(predicate = replicasList -> replicasList.contains(bookieAddress.toString()))).hasNext()) {
            LOG.info("Still in some underreplicated ledgers metadata, this bookie is part of its ensemble. Have to make sure that those ledger fragments are rereplicated");
            ArrayList<Long> urLedgers = new ArrayList<Long>();
            urLedgerIterator.forEachRemaining(urLedgers::add);
            this.waitForLedgersToBeReplicated(urLedgers, bookieAddress, this.bkc.ledgerManager);
        }
    }

    private void waitForLedgersToBeReplicated(Collection<Long> ledgers, BookieSocketAddress thisBookieAddress, LedgerManager ledgerManager) throws InterruptedException, TimeoutException {
        int maxSleepTimeInBetweenChecks = 600000;
        int sleepTimePerLedger = 10000;
        Predicate<Long> validateBookieIsNotPartOfEnsemble = ledgerId -> !this.areEntriesOfLedgerStoredInTheBookie((long)ledgerId, thisBookieAddress, ledgerManager);
        while (!ledgers.isEmpty()) {
            LOG.info("Count of Ledgers which need to be rereplicated: {}", (Object)ledgers.size());
            int sleepTimeForThisCheck = ledgers.size() * sleepTimePerLedger > maxSleepTimeInBetweenChecks ? maxSleepTimeInBetweenChecks : ledgers.size() * sleepTimePerLedger;
            Thread.sleep(sleepTimeForThisCheck);
            LOG.debug("Making sure following ledgers replication to be completed: {}", ledgers);
            ledgers.removeIf(validateBookieIsNotPartOfEnsemble);
        }
    }

    private boolean areEntriesOfLedgerStoredInTheBookie(long ledgerId, BookieSocketAddress bookieAddress, LedgerManager ledgerManager) {
        ReadMetadataCallback cb = new ReadMetadataCallback(ledgerId);
        ledgerManager.readLedgerMetadata(ledgerId, cb);
        try {
            LedgerMetadata ledgerMetadata = (LedgerMetadata)cb.get();
            Collection<ArrayList<BookieSocketAddress>> ensemblesOfSegments = ledgerMetadata.getEnsembles().values();
            Iterator<ArrayList<BookieSocketAddress>> ensemblesOfSegmentsIterator = ensemblesOfSegments.iterator();
            int segmentNo = 0;
            while (ensemblesOfSegmentsIterator.hasNext()) {
                ArrayList<BookieSocketAddress> ensemble = ensemblesOfSegmentsIterator.next();
                if (!ensemble.contains(bookieAddress) || !this.areEntriesOfSegmentStoredInTheBookie(ledgerMetadata, bookieAddress, segmentNo++)) continue;
                return true;
            }
            return false;
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() != null && e.getCause().getClass().equals(BKException.BKNoSuchLedgerExistsException.class)) {
                LOG.debug("Ledger: {} has been deleted", (Object)ledgerId);
                return false;
            }
            LOG.error("Got exception while trying to read LedgerMeatadata of " + ledgerId, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean areEntriesOfSegmentStoredInTheBookie(LedgerMetadata ledgerMetadata, BookieSocketAddress bookieAddress, int segmentNo) {
        boolean lastSegment;
        boolean isLedgerClosed = ledgerMetadata.isClosed();
        int ensembleSize = ledgerMetadata.getEnsembleSize();
        int writeQuorumSize = ledgerMetadata.getWriteQuorumSize();
        LinkedList<Map.Entry<Long, ArrayList<BookieSocketAddress>>> segments = new LinkedList<Map.Entry<Long, ArrayList<BookieSocketAddress>>>(ledgerMetadata.getEnsembles().entrySet());
        boolean bl = lastSegment = segmentNo == segments.size() - 1;
        if (lastSegment && isLedgerClosed && ledgerMetadata.getLastEntryId() < (Long)((Map.Entry)segments.get(segmentNo)).getKey()) {
            return false;
        }
        if (lastSegment && !isLedgerClosed || ensembleSize == writeQuorumSize) {
            return true;
        }
        RoundRobinDistributionSchedule distributionSchedule = new RoundRobinDistributionSchedule(ledgerMetadata.getWriteQuorumSize(), ledgerMetadata.getAckQuorumSize(), ledgerMetadata.getEnsembleSize());
        ArrayList currentSegmentEnsemble = (ArrayList)((Map.Entry)segments.get(segmentNo)).getValue();
        int thisBookieIndexInCurrentEnsemble = currentSegmentEnsemble.indexOf(bookieAddress);
        long firstEntryId = (Long)((Map.Entry)segments.get(segmentNo)).getKey();
        long lastEntryId = lastSegment ? ledgerMetadata.getLastEntryId() : (Long)((Map.Entry)segments.get(segmentNo + 1)).getKey() - 1L;
        long firstStoredEntryId = -1L;
        long firstEntryIter = firstEntryId;
        for (int i = 0; i < ensembleSize && firstEntryIter <= lastEntryId; ++firstEntryIter, ++i) {
            if (!distributionSchedule.hasEntry(firstEntryIter, thisBookieIndexInCurrentEnsemble)) continue;
            firstStoredEntryId = firstEntryIter;
            break;
        }
        return firstStoredEntryId != -1L;
    }

    static class ReadMetadataCallback
    extends AbstractFuture<LedgerMetadata>
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> {
        final long ledgerId;

        ReadMetadataCallback(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        long getLedgerId() {
            return this.ledgerId;
        }

        @Override
        public void operationComplete(int rc, LedgerMetadata result) {
            if (rc != 0) {
                this.setException(BKException.create(rc));
            } else {
                this.set(result);
            }
        }
    }

    static class ResultCallBack
    implements AsyncCallback.VoidCallback {
        private final CompletableFuture<Void> sync;

        public ResultCallBack(CompletableFuture<Void> sync) {
            this.sync = sync;
        }

        public void processResult(int rc, String s, Object ctx) {
            SynchCallbackUtils.finish(rc, null, this.sync);
        }
    }

    static class SyncObject {
        boolean value = false;
        int rc = 0;
    }

    class LedgerEntriesIterator
    implements Iterator<LedgerEntry> {
        final LedgerHandle handle;
        final long ledgerId;
        final long lastEntryId;
        long nextEntryId;
        LedgerEntry currentEntry;

        public LedgerEntriesIterator(long ledgerId, long firstEntry, long lastEntry) throws InterruptedException, BKException {
            this.handle = BookKeeperAdmin.this.openLedgerNoRecovery(ledgerId);
            this.ledgerId = ledgerId;
            this.nextEntryId = firstEntry;
            this.lastEntryId = lastEntry;
            this.currentEntry = null;
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry != null) {
                return true;
            }
            if (this.lastEntryId == -1L || this.nextEntryId <= this.lastEntryId) {
                try {
                    CompletableFuture counter = new CompletableFuture();
                    this.handle.asyncReadEntriesInternal(this.nextEntryId, this.nextEntryId, new LedgerHandle.SyncReadCallback(), counter);
                    this.currentEntry = (LedgerEntry)((Enumeration)SynchCallbackUtils.waitForResult(counter)).nextElement();
                    return true;
                }
                catch (Exception e) {
                    if (e instanceof BKException.BKNoSuchEntryException && this.lastEntryId == -1L) {
                        this.close();
                        return false;
                    }
                    LOG.error("Error reading entry {} from ledger {}", (Object)new Object[]{this.nextEntryId, this.ledgerId}, (Object)e);
                    this.close();
                    throw new RuntimeException(e);
                }
            }
            this.close();
            return false;
        }

        @Override
        public LedgerEntry next() {
            if (this.lastEntryId > -1L && this.nextEntryId > this.lastEntryId) {
                throw new NoSuchElementException();
            }
            ++this.nextEntryId;
            LedgerEntry entry = this.currentEntry;
            this.currentEntry = null;
            return entry;
        }

        @Override
        public void remove() {
        }

        private void close() {
            if (this.handle != null) {
                try {
                    this.handle.close();
                }
                catch (Exception e) {
                    LOG.error("Error closing ledger handle {}", (Object)this.handle, (Object)e);
                }
            }
        }
    }

    class LedgerEntriesIterable
    implements Iterable<LedgerEntry> {
        final long ledgerId;
        final long firstEntryId;
        final long lastEntryId;

        public LedgerEntriesIterable(long ledgerId, long firstEntry) {
            this(ledgerId, firstEntry, -1L);
        }

        public LedgerEntriesIterable(long ledgerId, long firstEntry, long lastEntry) {
            this.ledgerId = ledgerId;
            this.firstEntryId = firstEntry;
            this.lastEntryId = lastEntry;
        }

        @Override
        public Iterator<LedgerEntry> iterator() {
            try {
                return new LedgerEntriesIterator(this.ledgerId, this.firstEntryId, this.lastEntryId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

