/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.collections;

import com.google.common.base.Preconditions;

public final class Bits {
    private static final int LSB = 0;
    private static final int INT_MSB = 31;
    private static final int LONG_MSB = 63;

    private Bits() {
    }

    public static boolean isBitSet(int value, int bit) {
        Preconditions.checkState((bit >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((bit <= 31 ? 1 : 0) != 0);
        int mask = 1 << bit;
        return (value & mask) != 0;
    }

    public static boolean isBitSet(long value, int bit) {
        Preconditions.checkState((bit >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((bit <= 63 ? 1 : 0) != 0);
        long mask = 1L << bit;
        return (value & mask) != 0L;
    }

    public static int setBit(int value, int bit) {
        Preconditions.checkState((bit >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((bit <= 31 ? 1 : 0) != 0);
        int mask = 1 << bit;
        return value | mask;
    }

    public static long setBit(long value, int bit) {
        Preconditions.checkState((bit >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((bit <= 63 ? 1 : 0) != 0);
        long mask = 1L << bit;
        return value | mask;
    }

    public static int clearBit(int value, int bit) {
        Preconditions.checkState((bit >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((bit <= 31 ? 1 : 0) != 0);
        int mask = ~Bits.setBit(0, bit);
        return value & mask;
    }

    public static long clearBit(long value, int bit) {
        Preconditions.checkState((bit >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((bit <= 63 ? 1 : 0) != 0);
        long mask = Bits.setBit(0L, bit) ^ 0xFFFFFFFFFFFFFFFFL;
        return value & mask;
    }
}

