/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.AsyncNotification;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogReadHandler;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.ReadAheadEntryReader;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.common.concurrent.FutureEventListener;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.exceptions.DLIllegalStateException;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.exceptions.EndOfStreamException;
import org.apache.distributedlog.exceptions.IdleReaderException;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.exceptions.ReadCancelledException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.util.OrderedScheduler;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BKAsyncLogReader
implements AsyncLogReader,
Runnable,
AsyncNotification {
    static final Logger LOG = LoggerFactory.getLogger(BKAsyncLogReader.class);
    private static final Function<List<LogRecordWithDLSN>, LogRecordWithDLSN> READ_NEXT_MAP_FUNCTION = records -> (LogRecordWithDLSN)records.get(0);
    private final String streamName;
    protected final BKDistributedLogManager bkDistributedLogManager;
    protected final BKLogReadHandler readHandler;
    private final AtomicReference<Throwable> lastException = new AtomicReference();
    private final OrderedScheduler scheduler;
    private final ConcurrentLinkedQueue<PendingReadRequest> pendingRequests = new ConcurrentLinkedQueue();
    private final Object scheduleLock = new Object();
    private final AtomicLong scheduleCount = new AtomicLong(0L);
    private final Stopwatch scheduleDelayStopwatch;
    private final Stopwatch readNextDelayStopwatch;
    private DLSN startDLSN;
    private ReadAheadEntryReader readAheadReader = null;
    private int lastPosition = 0;
    private final boolean positionGapDetectionEnabled;
    private final int idleErrorThresholdMillis;
    final ScheduledFuture<?> idleReaderTimeoutTask;
    private ScheduledFuture<?> backgroundScheduleTask = null;
    private final Stopwatch lastProcessTime;
    protected CompletableFuture<Void> closeFuture = null;
    private boolean lockStream = false;
    private final boolean returnEndOfStreamRecord;
    private final Runnable BACKGROUND_READ_SCHEDULER = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = BKAsyncLogReader.this.scheduleLock;
            synchronized (object) {
                BKAsyncLogReader.this.backgroundScheduleTask = null;
            }
            BKAsyncLogReader.this.scheduleBackgroundRead();
        }
    };
    private Entry.Reader currentEntry = null;
    private LogRecordWithDLSN nextRecord = null;
    private boolean disableProcessingReadRequests = false;
    private final OpStatsLogger readNextExecTime;
    private final OpStatsLogger delayUntilPromiseSatisfied;
    private final OpStatsLogger timeBetweenReadNexts;
    private final OpStatsLogger futureSetLatency;
    private final OpStatsLogger scheduleLatency;
    private final OpStatsLogger backgroundReaderRunTime;
    private final Counter idleReaderCheckCount;
    private final Counter idleReaderCheckIdleReadRequestCount;
    private final Counter idleReaderCheckIdleReadAheadCount;
    private final Counter idleReaderError;

    BKAsyncLogReader(BKDistributedLogManager bkdlm, OrderedScheduler scheduler, DLSN startDLSN, Optional<String> subscriberId, boolean returnEndOfStreamRecord, StatsLogger statsLogger) {
        this.streamName = bkdlm.getStreamName();
        this.bkDistributedLogManager = bkdlm;
        this.scheduler = scheduler;
        this.readHandler = this.bkDistributedLogManager.createReadHandler(subscriberId, this, true);
        LOG.debug("Starting async reader at {}", (Object)startDLSN);
        this.startDLSN = startDLSN;
        this.scheduleDelayStopwatch = Stopwatch.createUnstarted();
        this.readNextDelayStopwatch = Stopwatch.createStarted();
        this.positionGapDetectionEnabled = bkdlm.getConf().getPositionGapDetectionEnabled();
        this.idleErrorThresholdMillis = bkdlm.getConf().getReaderIdleErrorThresholdMillis();
        this.returnEndOfStreamRecord = returnEndOfStreamRecord;
        StatsLogger asyncReaderStatsLogger = statsLogger.scope("async_reader");
        this.futureSetLatency = asyncReaderStatsLogger.getOpStatsLogger("future_set");
        this.scheduleLatency = asyncReaderStatsLogger.getOpStatsLogger("schedule");
        this.backgroundReaderRunTime = asyncReaderStatsLogger.getOpStatsLogger("background_read");
        this.readNextExecTime = asyncReaderStatsLogger.getOpStatsLogger("read_next_exec");
        this.timeBetweenReadNexts = asyncReaderStatsLogger.getOpStatsLogger("time_between_read_next");
        this.delayUntilPromiseSatisfied = asyncReaderStatsLogger.getOpStatsLogger("delay_until_promise_satisfied");
        this.idleReaderError = asyncReaderStatsLogger.getCounter("idle_reader_error");
        this.idleReaderCheckCount = asyncReaderStatsLogger.getCounter("idle_reader_check_total");
        this.idleReaderCheckIdleReadRequestCount = asyncReaderStatsLogger.getCounter("idle_reader_check_idle_read_requests");
        this.idleReaderCheckIdleReadAheadCount = asyncReaderStatsLogger.getCounter("idle_reader_check_idle_readahead");
        this.lockStream = false;
        this.idleReaderTimeoutTask = this.scheduleIdleReaderTaskIfNecessary();
        this.lastProcessTime = Stopwatch.createStarted();
    }

    synchronized void releaseCurrentEntry() {
        if (null != this.currentEntry) {
            this.currentEntry.release();
            this.currentEntry = null;
        }
    }

    private ScheduledFuture<?> scheduleIdleReaderTaskIfNecessary() {
        if (this.idleErrorThresholdMillis < Integer.MAX_VALUE) {
            long period = Math.max(this.idleErrorThresholdMillis / 10, 1000);
            period = Math.min(period, (long)(this.idleErrorThresholdMillis / 5));
            return this.scheduler.scheduleAtFixedRate((Object)this.streamName, new Runnable(){

                @Override
                public void run() {
                    PendingReadRequest nextRequest = (PendingReadRequest)BKAsyncLogReader.this.pendingRequests.peek();
                    BKAsyncLogReader.this.idleReaderCheckCount.inc();
                    if (null == nextRequest) {
                        return;
                    }
                    BKAsyncLogReader.this.idleReaderCheckIdleReadRequestCount.inc();
                    if (nextRequest.elapsedSinceEnqueue(TimeUnit.MILLISECONDS) < (long)BKAsyncLogReader.this.idleErrorThresholdMillis) {
                        return;
                    }
                    ReadAheadEntryReader readAheadReader = BKAsyncLogReader.this.getReadAheadReader();
                    BKAsyncLogReader.this.idleReaderCheckIdleReadAheadCount.inc();
                    try {
                        if (null == readAheadReader || !BKAsyncLogReader.this.hasMoreRecords() && readAheadReader.isReaderIdle(BKAsyncLogReader.this.idleErrorThresholdMillis, TimeUnit.MILLISECONDS)) {
                            BKAsyncLogReader.this.markReaderAsIdle();
                            return;
                        }
                        if (BKAsyncLogReader.this.lastProcessTime.elapsed(TimeUnit.MILLISECONDS) > (long)BKAsyncLogReader.this.idleErrorThresholdMillis) {
                            BKAsyncLogReader.this.markReaderAsIdle();
                        }
                    }
                    catch (IOException e) {
                        BKAsyncLogReader.this.setLastException(e);
                        return;
                    }
                }
            }, period, period, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    synchronized ReadAheadEntryReader getReadAheadReader() {
        return this.readAheadReader;
    }

    void cancelIdleReaderTask() {
        try {
            if (null != this.idleReaderTimeoutTask) {
                this.idleReaderTimeoutTask.cancel(true);
            }
        }
        catch (Exception exc) {
            LOG.info("{}: Failed to cancel the background idle reader timeout task", (Object)this.readHandler.getFullyQualifiedName());
        }
    }

    private void markReaderAsIdle() {
        this.idleReaderError.inc();
        IdleReaderException ire = new IdleReaderException("Reader on stream " + this.readHandler.getFullyQualifiedName() + " is idle for " + this.idleErrorThresholdMillis + " ms");
        this.setLastException((IOException)ire);
        this.cancelAllPendingReads((Throwable)ire);
    }

    protected synchronized void setStartDLSN(DLSN fromDLSN) throws UnexpectedException {
        if (null != this.readAheadReader) {
            throw new UnexpectedException("Could't reset from dlsn after reader already starts reading.");
        }
        this.startDLSN = fromDLSN;
    }

    @VisibleForTesting
    public synchronized DLSN getStartDLSN() {
        return this.startDLSN;
    }

    public CompletableFuture<Void> lockStream() {
        this.lockStream = true;
        return this.readHandler.lockStream();
    }

    private boolean checkClosedOrInError(String operation) {
        if (null == this.lastException.get()) {
            try {
                if (null != this.readHandler && null != this.getReadAheadReader()) {
                    this.getReadAheadReader().checkLastException();
                }
                this.bkDistributedLogManager.checkClosedOrInError(operation);
            }
            catch (IOException exc) {
                this.setLastException(exc);
            }
        }
        if (this.lockStream) {
            try {
                this.readHandler.checkReadLock();
            }
            catch (IOException ex) {
                this.setLastException(ex);
            }
        }
        if (null != this.lastException.get()) {
            LOG.trace("Cancelling pending reads");
            this.cancelAllPendingReads(this.lastException.get());
            return true;
        }
        return false;
    }

    private void setLastException(IOException exc) {
        this.lastException.compareAndSet(null, exc);
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public synchronized CompletableFuture<LogRecordWithDLSN> readNext() {
        return this.readInternal(1, 0L, TimeUnit.MILLISECONDS).thenApply(READ_NEXT_MAP_FUNCTION);
    }

    @Override
    public synchronized CompletableFuture<List<LogRecordWithDLSN>> readBulk(int numEntries) {
        return this.readInternal(numEntries, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized CompletableFuture<List<LogRecordWithDLSN>> readBulk(int numEntries, long waitTime, TimeUnit timeUnit) {
        return this.readInternal(numEntries, waitTime, timeUnit);
    }

    private synchronized CompletableFuture<List<LogRecordWithDLSN>> readInternal(int numEntries, long deadlineTime, TimeUnit deadlineTimeUnit) {
        this.timeBetweenReadNexts.registerSuccessfulEvent(this.readNextDelayStopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        this.readNextDelayStopwatch.reset().start();
        PendingReadRequest readRequest = new PendingReadRequest(numEntries, deadlineTime, deadlineTimeUnit);
        if (null == this.readAheadReader) {
            final ReadAheadEntryReader readAheadEntryReader = this.readAheadReader = new ReadAheadEntryReader(this.getStreamName(), this.getStartDLSN(), this.bkDistributedLogManager.getConf(), this.readHandler, this.bkDistributedLogManager.getReaderEntryStore(), this.bkDistributedLogManager.getScheduler(), Ticker.systemTicker(), this.bkDistributedLogManager.alertStatsLogger);
            this.readHandler.checkLogStreamExists().whenComplete((BiConsumer)new FutureEventListener<Void>(){

                public void onSuccess(Void value) {
                    try {
                        BKAsyncLogReader.this.readHandler.registerListener(readAheadEntryReader);
                        BKAsyncLogReader.this.readHandler.asyncStartFetchLogSegments().thenAccept(logSegments -> {
                            readAheadEntryReader.addStateChangeNotification(BKAsyncLogReader.this);
                            readAheadEntryReader.start((List)logSegments.getValue());
                        });
                    }
                    catch (Exception exc) {
                        BKAsyncLogReader.this.notifyOnError(exc);
                    }
                }

                public void onFailure(Throwable cause) {
                    BKAsyncLogReader.this.notifyOnError(cause);
                }
            });
        }
        if (this.checkClosedOrInError("readNext")) {
            readRequest.completeExceptionally(this.lastException.get());
        } else {
            boolean queueEmpty = this.pendingRequests.isEmpty();
            this.pendingRequests.add(readRequest);
            if (queueEmpty) {
                this.scheduleBackgroundRead();
            }
        }
        this.readNextExecTime.registerSuccessfulEvent(this.readNextDelayStopwatch.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        this.readNextDelayStopwatch.reset().start();
        return readRequest.getPromise();
    }

    public synchronized void scheduleBackgroundRead() {
        if (null != this.closeFuture) {
            return;
        }
        long prevCount = this.scheduleCount.getAndIncrement();
        if (0L == prevCount) {
            this.scheduleDelayStopwatch.reset().start();
            this.scheduler.submit((Object)this.streamName, (Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> asyncClose() {
        ReadCancelledException exception;
        CompletableFuture<Void> closePromise;
        Object object = this;
        synchronized (object) {
            if (null != this.closeFuture) {
                return this.closeFuture;
            }
            this.closeFuture = new CompletableFuture<Void>();
            closePromise = this.closeFuture;
            exception = new ReadCancelledException(this.readHandler.getFullyQualifiedName(), "Reader was closed");
            this.setLastException((IOException)exception);
            this.releaseCurrentEntry();
        }
        this.cancelIdleReaderTask();
        object = this.scheduleLock;
        synchronized (object) {
            if (null != this.backgroundScheduleTask) {
                this.backgroundScheduleTask.cancel(true);
            }
        }
        this.cancelAllPendingReads((Throwable)exception);
        ReadAheadEntryReader readAheadReader = this.getReadAheadReader();
        if (null != readAheadReader) {
            this.readHandler.unregisterListener(readAheadReader);
            readAheadReader.removeStateChangeNotification(this);
        }
        FutureUtils.proxyTo(Utils.closeSequence((ExecutorService)this.bkDistributedLogManager.getScheduler(), true, readAheadReader, this.readHandler), closePromise);
        return closePromise;
    }

    private void cancelAllPendingReads(Throwable throwExc) {
        for (PendingReadRequest promise : this.pendingRequests) {
            promise.completeExceptionally(throwExc);
        }
        this.pendingRequests.clear();
    }

    synchronized boolean hasMoreRecords() throws IOException {
        if (null == this.readAheadReader) {
            return false;
        }
        if (this.readAheadReader.getNumCachedEntries() > 0 || null != this.nextRecord) {
            return true;
        }
        if (null != this.currentEntry) {
            this.nextRecord = this.currentEntry.nextRecord();
            return null != this.nextRecord;
        }
        return false;
    }

    private synchronized LogRecordWithDLSN readNextRecord() throws IOException {
        if (null == this.readAheadReader) {
            return null;
        }
        if (null == this.currentEntry) {
            this.currentEntry = this.readAheadReader.getNextReadAheadEntry(0L, TimeUnit.MILLISECONDS);
            if (null == this.currentEntry) {
                return null;
            }
        }
        if (null == this.nextRecord) {
            this.nextRecord = this.currentEntry.nextRecord();
            if (null == this.nextRecord) {
                this.currentEntry = null;
                return this.readNextRecord();
            }
        }
        LogRecordWithDLSN recordToReturn = this.nextRecord;
        this.nextRecord = this.currentEntry.nextRecord();
        return recordToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.scheduleLock;
        synchronized (object) {
            if (this.scheduleDelayStopwatch.isRunning()) {
                this.scheduleLatency.registerSuccessfulEvent(this.scheduleDelayStopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
            Stopwatch runTime = Stopwatch.createStarted();
            int iterations = 0;
            long scheduleCountLocal = this.scheduleCount.get();
            LOG.debug("{}: Scheduled Background Reader", (Object)this.readHandler.getFullyQualifiedName());
            while (true) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{}: Executing Iteration: {}", (Object)this.readHandler.getFullyQualifiedName(), (Object)iterations++);
                }
                PendingReadRequest nextRequest = null;
                BKAsyncLogReader bKAsyncLogReader = this;
                synchronized (bKAsyncLogReader) {
                    nextRequest = this.pendingRequests.peek();
                    if (null == nextRequest) {
                        LOG.trace("{}: Queue Empty waiting for Input", (Object)this.readHandler.getFullyQualifiedName());
                        this.scheduleCount.set(0L);
                        this.backgroundReaderRunTime.registerSuccessfulEvent(runTime.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                        return;
                    }
                    if (this.disableProcessingReadRequests) {
                        LOG.info("Reader of {} is forced to stop processing read requests", (Object)this.readHandler.getFullyQualifiedName());
                        return;
                    }
                }
                this.lastProcessTime.reset().start();
                if (null == this.lastException.get() && nextRequest.getPromise().isCancelled()) {
                    this.setLastException((IOException)((Object)new DLInterruptedException("Interrupted on reading " + this.readHandler.getFullyQualifiedName())));
                }
                if (this.checkClosedOrInError("readNext")) {
                    if (!(this.lastException.get().getCause() instanceof LogNotFoundException)) {
                        LOG.warn("{}: Exception", (Object)this.readHandler.getFullyQualifiedName(), (Object)this.lastException.get());
                    }
                    this.backgroundReaderRunTime.registerFailedEvent(runTime.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                    return;
                }
                try {
                    if (this.bkDistributedLogManager.getFailureInjector().shouldInjectErrors()) {
                        throw new IOException("Reader Simulated Exception");
                    }
                    while (!nextRequest.hasReadEnoughRecords()) {
                        LogRecordWithDLSN record;
                        while (null != (record = this.readNextRecord()) && (record.isControl() || record.getDlsn().compareTo(this.getStartDLSN()) < 0)) {
                        }
                        if (null == record) break;
                        if (record.isEndOfStream() && !this.returnEndOfStreamRecord) {
                            this.setLastException((IOException)new EndOfStreamException("End of Stream Reached for " + this.readHandler.getFullyQualifiedName()));
                            break;
                        }
                        if (this.recordPositionsContainsGap(record, this.lastPosition)) {
                            this.bkDistributedLogManager.raiseAlert("Gap detected between records at record = {}", record);
                            if (this.positionGapDetectionEnabled) {
                                throw new DLIllegalStateException("Gap detected between records at record = " + record);
                            }
                        }
                        this.lastPosition = record.getLastPositionWithinLogSegment();
                        nextRequest.addRecord(record);
                    }
                }
                catch (IOException exc) {
                    this.setLastException(exc);
                    if (exc instanceof LogNotFoundException) continue;
                    LOG.warn("{} : read with skip Exception", (Object)this.readHandler.getFullyQualifiedName(), (Object)this.lastException.get());
                    continue;
                }
                if (nextRequest.hasReadRecords()) {
                    long remainingWaitTime = nextRequest.getRemainingWaitTime();
                    if (remainingWaitTime > 0L && !nextRequest.hasReadEnoughRecords()) {
                        this.backgroundReaderRunTime.registerSuccessfulEvent(runTime.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                        this.scheduleDelayStopwatch.reset().start();
                        this.scheduleCount.set(0L);
                        this.backgroundScheduleTask = this.scheduler.schedule((Object)this.streamName, this.BACKGROUND_READ_SCHEDULER, remainingWaitTime, nextRequest.deadlineTimeUnit);
                        return;
                    }
                    PendingReadRequest request = this.pendingRequests.poll();
                    if (null != request && nextRequest == request) {
                        request.complete();
                        if (null == this.backgroundScheduleTask) continue;
                        this.backgroundScheduleTask.cancel(true);
                        this.backgroundScheduleTask = null;
                        continue;
                    }
                    DLIllegalStateException ise = new DLIllegalStateException("Unexpected condition at dlsn = " + ((LogRecordWithDLSN)nextRequest.records.get(0)).getDlsn());
                    nextRequest.completeExceptionally((Throwable)ise);
                    if (null != request) {
                        request.completeExceptionally((Throwable)ise);
                    }
                    this.bkDistributedLogManager.raiseAlert("Unexpected condition at dlsn = {}", ((LogRecordWithDLSN)nextRequest.records.get(0)).getDlsn());
                    this.setLastException((IOException)ise);
                    continue;
                }
                if (0L == scheduleCountLocal) {
                    LOG.trace("Schedule count dropping to zero", this.lastException.get());
                    this.backgroundReaderRunTime.registerSuccessfulEvent(runTime.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                    return;
                }
                scheduleCountLocal = this.scheduleCount.decrementAndGet();
            }
        }
    }

    private boolean recordPositionsContainsGap(LogRecordWithDLSN record, long lastPosition) {
        boolean firstLogRecord = 1 == record.getPositionWithinLogSegment();
        boolean endOfStreamRecord = record.isEndOfStream();
        boolean emptyLogSegment = 0L == lastPosition;
        boolean positionIncreasedByOne = (long)record.getPositionWithinLogSegment() == lastPosition + 1L;
        return !firstLogRecord && !endOfStreamRecord && !emptyLogSegment && !positionIncreasedByOne;
    }

    @Override
    public void notifyOnError(Throwable cause) {
        if (cause instanceof IOException) {
            this.setLastException((IOException)cause);
        } else {
            this.setLastException(new IOException(cause));
        }
        this.scheduleBackgroundRead();
    }

    @Override
    public void notifyOnOperationComplete() {
        this.scheduleBackgroundRead();
    }

    @VisibleForTesting
    void simulateErrors() {
        this.bkDistributedLogManager.getFailureInjector().injectErrors(true);
    }

    @VisibleForTesting
    synchronized void disableReadAheadLogSegmentsNotification() {
        this.readHandler.disableReadAheadLogSegmentsNotification();
    }

    @VisibleForTesting
    synchronized void disableProcessingReadRequests() {
        this.disableProcessingReadRequests = true;
    }

    private class PendingReadRequest {
        private final Stopwatch enqueueTime;
        private final int numEntries;
        private final List<LogRecordWithDLSN> records;
        private final CompletableFuture<List<LogRecordWithDLSN>> promise;
        private final long deadlineTime;
        private final TimeUnit deadlineTimeUnit;

        PendingReadRequest(int numEntries, long deadlineTime, TimeUnit deadlineTimeUnit) {
            this.numEntries = numEntries;
            this.enqueueTime = Stopwatch.createStarted();
            this.records = numEntries == 1 ? new ArrayList<LogRecordWithDLSN>(1) : new ArrayList<LogRecordWithDLSN>();
            this.promise = new CompletableFuture();
            this.deadlineTime = deadlineTime;
            this.deadlineTimeUnit = deadlineTimeUnit;
        }

        CompletableFuture<List<LogRecordWithDLSN>> getPromise() {
            return this.promise;
        }

        long elapsedSinceEnqueue(TimeUnit timeUnit) {
            return this.enqueueTime.elapsed(timeUnit);
        }

        void completeExceptionally(Throwable throwable) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            if (this.promise.completeExceptionally(throwable)) {
                BKAsyncLogReader.this.futureSetLatency.registerFailedEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                BKAsyncLogReader.this.delayUntilPromiseSatisfied.registerFailedEvent(this.enqueueTime.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
        }

        boolean hasReadRecords() {
            return this.records.size() > 0;
        }

        boolean hasReadEnoughRecords() {
            return this.records.size() >= this.numEntries;
        }

        long getRemainingWaitTime() {
            if (this.deadlineTime <= 0L) {
                return 0L;
            }
            return this.deadlineTime - this.elapsedSinceEnqueue(this.deadlineTimeUnit);
        }

        void addRecord(LogRecordWithDLSN record) {
            this.records.add(record);
        }

        void complete() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} : Satisfied promise with {} records", (Object)BKAsyncLogReader.this.readHandler.getFullyQualifiedName(), (Object)this.records.size());
            }
            BKAsyncLogReader.this.delayUntilPromiseSatisfied.registerSuccessfulEvent(this.enqueueTime.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.promise.complete(this.records);
            BKAsyncLogReader.this.futureSetLatency.registerSuccessfulEvent(stopwatch.stop().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
        }
    }
}

