/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Data;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.ApproximateHistogram;
import com.twitter.common.stats.Histogram;
import com.twitter.common.stats.Precision;
import com.twitter.common.stats.WindowedHistogram;
import com.twitter.common.util.Clock;
import com.twitter.common.util.LowResClock;

public class WindowedApproxHistogram
extends WindowedHistogram<ApproximateHistogram> {
    @VisibleForTesting
    public static final int DEFAULT_SLICES = 3;
    @VisibleForTesting
    public static final Amount<Long, Time> DEFAULT_WINDOW = Amount.of((long)1L, (Unit)Time.MINUTES);
    @VisibleForTesting
    public static final Amount<Long, Data> DEFAULT_MAX_MEMORY = Amount.of((long)(4L * (Long)ApproximateHistogram.DEFAULT_MAX_MEMORY.as((Unit)Data.BYTES)), (Unit)Data.BYTES);

    public WindowedApproxHistogram(Amount<Long, Time> amount, final int n, final Amount<Long, Data> amount2, Clock clock) {
        super(ApproximateHistogram.class, amount, n, new Supplier<ApproximateHistogram>(){
            private Amount<Long, Data> perHistogramMemory;
            {
                this.perHistogramMemory = Amount.of((long)((Long)amount2.as((Unit)Data.BYTES) / (long)(n + 1)), (Unit)Data.BYTES);
            }

            public ApproximateHistogram get() {
                return new ApproximateHistogram(this.perHistogramMemory);
            }
        }, (Function<H[], Histogram>)new Function<ApproximateHistogram[], Histogram>(){

            public Histogram apply(ApproximateHistogram[] approximateHistogramArray) {
                return ApproximateHistogram.merge(approximateHistogramArray);
            }
        }, clock);
    }

    public WindowedApproxHistogram(Amount<Long, Time> amount, final int n, final Precision precision, Clock clock) {
        super(ApproximateHistogram.class, amount, n, new Supplier<ApproximateHistogram>(){
            private Precision perHistogramPrecision;
            {
                this.perHistogramPrecision = new Precision(precision.getEpsilon(), precision.getN() / (n + 1));
            }

            public ApproximateHistogram get() {
                return new ApproximateHistogram(this.perHistogramPrecision);
            }
        }, (Function<H[], Histogram>)new Function<ApproximateHistogram[], Histogram>(){

            public Histogram apply(ApproximateHistogram[] approximateHistogramArray) {
                return ApproximateHistogram.merge(approximateHistogramArray);
            }
        }, clock);
    }

    public WindowedApproxHistogram(Amount<Long, Time> amount, int n, Amount<Long, Data> amount2) {
        this(amount, n, amount2, LowResClock.DEFAULT);
    }

    public WindowedApproxHistogram(Amount<Long, Data> amount) {
        this(DEFAULT_WINDOW, 3, amount);
    }

    public WindowedApproxHistogram(Amount<Long, Time> amount, int n, Precision precision) {
        this(amount, n, precision, LowResClock.DEFAULT);
    }

    public WindowedApproxHistogram(Precision precision) {
        this(DEFAULT_WINDOW, 3, precision);
    }

    public WindowedApproxHistogram(Amount<Long, Time> amount, int n) {
        this(amount, n, DEFAULT_MAX_MEMORY, LowResClock.DEFAULT);
    }

    public WindowedApproxHistogram() {
        this(DEFAULT_WINDOW, 3, DEFAULT_MAX_MEMORY, LowResClock.DEFAULT);
    }

    @VisibleForTesting
    public WindowedApproxHistogram(Clock clock) {
        this(DEFAULT_WINDOW, 3, DEFAULT_MAX_MEMORY, clock);
    }
}

