/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.builders;

import java.util.Iterator;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeFieldWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractMemberBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.XMLNode;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class AnnotationTypeFieldBuilder
extends AbstractMemberBuilder {
    protected TypeElement typeElement;
    protected VisibleMemberMap visibleMemberMap;
    protected AnnotationTypeFieldWriter writer;
    protected SortedSet<Element> members;
    protected Element currentMember;

    protected AnnotationTypeFieldBuilder(AbstractBuilder.Context context, TypeElement typeElement, AnnotationTypeFieldWriter writer, VisibleMemberMap.Kind memberType) {
        super(context);
        this.typeElement = typeElement;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(typeElement, memberType, this.configuration);
        this.members = this.visibleMemberMap.getMembersFor(typeElement);
    }

    public static AnnotationTypeFieldBuilder getInstance(AbstractBuilder.Context context, TypeElement typeElement, AnnotationTypeFieldWriter writer) {
        return new AnnotationTypeFieldBuilder(context, typeElement, writer, VisibleMemberMap.Kind.ANNOTATION_TYPE_FIELDS);
    }

    @Override
    public String getName() {
        return "AnnotationTypeFieldDetails";
    }

    public SortedSet<Element> members(TypeElement typeElement) {
        return this.visibleMemberMap.getMembersFor(typeElement);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.members.size() > 0;
    }

    public void buildAnnotationTypeField(XMLNode node, Content memberDetailsTree) {
        this.buildAnnotationTypeMember(node, memberDetailsTree);
    }

    public void buildAnnotationTypeMember(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        if (!this.members.isEmpty()) {
            this.writer.addAnnotationFieldDetailsMarker(memberDetailsTree);
            Iterator iterator = this.members.iterator();
            while (iterator.hasNext()) {
                Element element;
                this.currentMember = element = (Element)iterator.next();
                Content detailsTree = this.writer.getMemberTreeHeader();
                this.writer.addAnnotationDetailsTreeHeader(this.typeElement, detailsTree);
                Content annotationDocTree = this.writer.getAnnotationDocTreeHeader(element, detailsTree);
                this.buildChildren(node, annotationDocTree);
                detailsTree.addContent(this.writer.getAnnotationDoc(annotationDocTree, this.currentMember == this.members.last()));
                memberDetailsTree.addContent(this.writer.getAnnotationDetails(detailsTree));
            }
        }
    }

    public void buildSignature(XMLNode node, Content annotationDocTree) {
        annotationDocTree.addContent(this.writer.getSignature(this.currentMember));
    }

    public void buildDeprecationInfo(XMLNode node, Content annotationDocTree) {
        this.writer.addDeprecated(this.currentMember, annotationDocTree);
    }

    public void buildMemberComments(XMLNode node, Content annotationDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments(this.currentMember, annotationDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content annotationDocTree) {
        this.writer.addTags(this.currentMember, annotationDocTree);
    }

    public AnnotationTypeFieldWriter getWriter() {
        return this.writer;
    }
}

