/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets;

import java.util.List;
import javax.lang.model.element.Element;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.BaseTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.InheritableTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFinder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class SimpleTaglet
extends BaseTaglet
implements InheritableTaglet {
    public static final String EXCLUDED = "x";
    public static final String PACKAGE = "p";
    public static final String TYPE = "t";
    public static final String CONSTRUCTOR = "c";
    public static final String FIELD = "f";
    public static final String METHOD = "m";
    public static final String OVERVIEW = "o";
    public static final String ALL = "a";
    protected String tagName;
    protected String header;
    protected String locations;

    public SimpleTaglet(String tagName, String header, String locations) {
        this.tagName = tagName;
        this.header = header;
        locations = Utils.toLowerCase(locations);
        this.locations = locations.contains(ALL) && !locations.contains(EXCLUDED) ? "ptfmco" : locations;
    }

    @Override
    public String getName() {
        return this.tagName;
    }

    @Override
    public boolean inConstructor() {
        return this.locations.contains(CONSTRUCTOR) && !this.locations.contains(EXCLUDED);
    }

    @Override
    public boolean inField() {
        return this.locations.contains(FIELD) && !this.locations.contains(EXCLUDED);
    }

    @Override
    public boolean inMethod() {
        return this.locations.contains(METHOD) && !this.locations.contains(EXCLUDED);
    }

    @Override
    public boolean inOverview() {
        return this.locations.contains(OVERVIEW) && !this.locations.contains(EXCLUDED);
    }

    @Override
    public boolean inPackage() {
        return this.locations.contains(PACKAGE) && !this.locations.contains(EXCLUDED);
    }

    @Override
    public boolean inType() {
        return this.locations.contains(TYPE) && !this.locations.contains(EXCLUDED);
    }

    @Override
    public boolean isInlineTag() {
        return false;
    }

    @Override
    public void inherit(DocFinder.Input input, DocFinder.Output output) {
        List<? extends DocTree> tags = input.utils.getBlockTags(input.element, this.tagName);
        if (!tags.isEmpty()) {
            output.holder = input.element;
            output.holderTag = tags.get(0);
            CommentHelper ch = input.utils.getCommentHelper(output.holder);
            output.inlineTags = input.isFirstSentence ? ch.getFirstSentenceTrees(input.utils.configuration, output.holderTag) : ch.getTags(input.utils.configuration, output.holderTag);
        }
    }

    @Override
    public Content getTagletOutput(Element element, DocTree tag, TagletWriter writer) {
        return this.header == null || tag == null ? null : writer.simpleTagOutput(element, tag, this.header);
    }

    @Override
    public Content getTagletOutput(Element holder, TagletWriter writer) {
        Utils utils = writer.configuration().utils;
        List<? extends DocTree> tags = utils.getBlockTags(holder, this.getName());
        if (this.header == null || tags.isEmpty()) {
            return null;
        }
        return writer.simpleTagOutput(holder, tags, this.header);
    }
}

