/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.twitter.util.Future;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.acl.AccessControlManager;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.common.util.Sequencer;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.RequestDeniedException;
import org.apache.distributedlog.protocol.util.ProtocolUtils;
import org.apache.distributedlog.protocol.util.TwitterFutureUtils;
import org.apache.distributedlog.service.ResponseUtils;
import org.apache.distributedlog.service.stream.AbstractWriteOp;
import org.apache.distributedlog.service.stream.StreamOpStats;
import org.apache.distributedlog.thrift.service.WriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateOp
extends AbstractWriteOp {
    private static final Logger logger = LoggerFactory.getLogger(TruncateOp.class);
    private final Counter deniedTruncateCounter;
    private final DLSN dlsn;
    private final AccessControlManager accessControlManager;

    public TruncateOp(String stream, DLSN dlsn, StatsLogger statsLogger, StatsLogger perStreamStatsLogger, Long checksum, Feature checksumDisabledFeature, AccessControlManager accessControlManager) {
        super(stream, TruncateOp.requestStat(statsLogger, "truncate"), checksum, checksumDisabledFeature);
        StreamOpStats streamOpStats = new StreamOpStats(statsLogger, perStreamStatsLogger);
        this.deniedTruncateCounter = streamOpStats.requestDeniedCounter("truncate");
        this.accessControlManager = accessControlManager;
        this.dlsn = dlsn;
    }

    @Override
    public Long computeChecksum() {
        return ProtocolUtils.truncateOpCRC32((String)this.stream, (DLSN)this.dlsn);
    }

    @Override
    protected Future<WriteResponse> executeOp(AsyncLogWriter writer, Sequencer sequencer, Object txnLock) {
        if (!this.stream.equals(writer.getStreamName())) {
            logger.error("Truncate: Stream Name Mismatch in the Stream Map {}, {}", (Object)this.stream, (Object)writer.getStreamName());
            return Future.exception((Throwable)new IllegalStateException("The stream mapping is incorrect, fail the request"));
        }
        return TwitterFutureUtils.newTFuture((CompletableFuture)writer.truncate(this.dlsn).thenApply(value -> ResponseUtils.writeSuccess()));
    }

    @Override
    public void preExecute() throws DLException {
        if (!this.accessControlManager.allowTruncate(this.stream)) {
            this.deniedTruncateCounter.inc();
            throw new RequestDeniedException(this.stream, "truncate");
        }
        super.preExecute();
    }
}

