/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.dynamic;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.dynamic.DynamicLocation;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Beta
public interface LocationOwner<L extends Location & DynamicLocation<E, L>, E extends Entity & LocationOwner<L, E>> {
    @SetFromFlag(value="locationPrefix")
    public static final ConfigKey<String> LOCATION_NAME_PREFIX = ConfigKeys.newStringConfigKey("entity.dynamicLocation.prefix", "The name prefix for the location owned by this entity", "dynamic");
    @SetFromFlag(value="locationSuffix")
    public static final ConfigKey<String> LOCATION_NAME_SUFFIX = ConfigKeys.newStringConfigKey("entity.dynamicLocation.suffix", "The name suffix for the location owned by this entity");
    @SetFromFlag(value="locationName")
    public static final BasicAttributeSensorAndConfigKey<String> LOCATION_NAME = new BasicAttributeSensorAndConfigKey<String>(String.class, "entity.dynamicLocation.name", "The name of the location owned by this entity (default is auto-generated using prefix and suffix keys)");
    public static final ConfigKey<Map<String, Object>> LOCATION_FLAGS = ConfigKeys.newConfigKey(new TypeToken<Map<String, Object>>(){}, "entity.dynamicLocation.flags", "Extra creation flags for the Location owned by this entity", ImmutableMap.of());
    public static final AttributeSensor<Location> DYNAMIC_LOCATION = Sensors.newSensor(Location.class, "entity.dynamicLocation", "The location owned by this entity");
    public static final AttributeSensor<String> LOCATION_SPEC = Sensors.newStringSensor("entity.dynamicLocation.spec", "The specification string for the location owned by this entity");
    public static final AttributeSensor<Boolean> DYNAMIC_LOCATION_STATUS = Sensors.newBooleanSensor("entity.dynamicLocation.status", "The status of the location owned by this entity");

    public L getDynamicLocation();

    public L createLocation(Map<String, ?> var1);

    public boolean isLocationAvailable();

    public void deleteLocation();
}

