/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecordPersister;

@Beta
public class ManagementPlaneSyncRecordDeltaImpl
implements ManagementPlaneSyncRecordPersister.Delta {
    private final Collection<ManagementNodeSyncRecord> nodes;
    private final Collection<String> removedNodeIds;
    private final ManagementPlaneSyncRecordPersister.Delta.MasterChange masterChange;
    private String masterId;
    private String expectedOldMaster;

    public static Builder builder() {
        return new Builder();
    }

    ManagementPlaneSyncRecordDeltaImpl(Builder builder) {
        this.nodes = builder.nodes;
        this.removedNodeIds = builder.removedNodeIds;
        this.masterChange = builder.masterChange;
        this.masterId = builder.master;
        this.expectedOldMaster = builder.expectedOldMaster;
        Preconditions.checkState((boolean)(this.masterChange == ManagementPlaneSyncRecordPersister.Delta.MasterChange.SET_MASTER ? this.masterId != null : this.masterId == null), (String)"invalid combination: change=%s; masterId=%s", (Object[])new Object[]{this.masterChange, this.masterId});
    }

    public Collection<ManagementNodeSyncRecord> getNodes() {
        return this.nodes;
    }

    public Collection<String> getRemovedNodeIds() {
        return this.removedNodeIds;
    }

    public ManagementPlaneSyncRecordPersister.Delta.MasterChange getMasterChange() {
        return this.masterChange;
    }

    public String getNewMasterOrNull() {
        return this.masterId;
    }

    public String getExpectedMasterToClear() {
        return this.expectedOldMaster;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + (this.masterChange != null && this.masterChange != ManagementPlaneSyncRecordPersister.Delta.MasterChange.NO_CHANGE ? this.masterChange + ": " + this.expectedOldMaster + "->" + this.masterId + "; " : "") + "nodes: " + this.nodes + (this.removedNodeIds != null && !this.removedNodeIds.isEmpty() ? "; removing: " + this.removedNodeIds : "") + "]";
    }

    public static class Builder {
        private Collection<ManagementNodeSyncRecord> nodes = Sets.newLinkedHashSet();
        private Collection<String> removedNodeIds = Sets.newLinkedHashSet();
        private ManagementPlaneSyncRecordPersister.Delta.MasterChange masterChange = ManagementPlaneSyncRecordPersister.Delta.MasterChange.NO_CHANGE;
        private String master;
        private String expectedOldMaster;

        public Builder node(ManagementNodeSyncRecord node) {
            this.nodes.add((ManagementNodeSyncRecord)Preconditions.checkNotNull((Object)node, (Object)"node"));
            return this;
        }

        public Builder removedNodeId(String id) {
            this.removedNodeIds.add((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
            return this;
        }

        public Builder setMaster(String nodeId) {
            this.masterChange = ManagementPlaneSyncRecordPersister.Delta.MasterChange.SET_MASTER;
            this.master = (String)Preconditions.checkNotNull((Object)nodeId, (Object)"masterId");
            return this;
        }

        public Builder clearMaster(String optionalExpectedNodeId) {
            this.masterChange = ManagementPlaneSyncRecordPersister.Delta.MasterChange.CLEAR_MASTER;
            this.expectedOldMaster = optionalExpectedNodeId;
            return this;
        }

        public ManagementPlaneSyncRecordPersister.Delta build() {
            return new ManagementPlaneSyncRecordDeltaImpl(this);
        }
    }
}

