/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.NaturalOrderComparator;
import org.apache.brooklyn.util.text.VersionComparator;

public class TypeSummary
implements Comparable<TypeSummary> {
    private final String symbolicName;
    private final String version;
    private final String containingBundle;
    private final BrooklynTypeRegistry.RegisteredTypeKind kind;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String displayName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String description;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String iconUrl;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> aliases;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> supertypes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<Object> tags;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean disabled = false;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean deprecated = false;
    @JsonIgnore
    private final Map<String, Object> others = MutableMap.of();

    TypeSummary() {
        this.symbolicName = null;
        this.version = null;
        this.containingBundle = null;
        this.kind = null;
        this.displayName = null;
        this.description = null;
    }

    public TypeSummary(RegisteredType t) {
        this.symbolicName = t.getSymbolicName();
        this.version = t.getVersion();
        this.containingBundle = t.getContainingBundle();
        this.kind = t.getKind();
        this.displayName = t.getDisplayName();
        this.description = t.getDescription();
        this.iconUrl = t.getIconUrl();
        this.aliases = t.getAliases();
        this.supertypes = ImmutableSet.copyOf(t.getSuperTypes().stream().map(s -> s instanceof Class ? ((Class)s).getName() : (s instanceof RegisteredType ? ((RegisteredType)s).getId() : s.toString())).iterator());
        this.tags = t.getTags();
        this.deprecated = t.isDeprecated();
        this.disabled = t.isDisabled();
    }

    public TypeSummary(TypeSummary t) {
        this.symbolicName = t.getSymbolicName();
        this.version = t.getVersion();
        this.containingBundle = t.getContainingBundle();
        this.kind = t.getKind();
        this.displayName = t.getDisplayName();
        this.description = t.getDescription();
        this.iconUrl = t.getIconUrl();
        this.aliases = t.getAliases();
        this.supertypes = t.getSupertypes();
        this.tags = t.getTags();
        this.deprecated = t.isDeprecated();
        this.disabled = t.isDisabled();
        this.others.putAll(t.getExtraFields());
    }

    @JsonAnyGetter
    public Map<String, Object> getExtraFields() {
        return this.others;
    }

    @JsonAnySetter
    public void setExtraField(String name, Object value) {
        this.others.put(name, value);
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @Override
    public int compareTo(TypeSummary o2) {
        TypeSummary o1 = this;
        return ComparisonChain.start().compare((Object)o1.symbolicName, (Object)o2.symbolicName, (Comparator)NaturalOrderComparator.INSTANCE).compareFalseFirst(o1.disabled, o2.disabled).compareFalseFirst(o1.deprecated, o2.deprecated).compare((Object)o2.version, (Object)o1.version, (Comparator)VersionComparator.INSTANCE).result();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getContainingBundle() {
        return this.containingBundle;
    }

    public BrooklynTypeRegistry.RegisteredTypeKind getKind() {
        return this.kind;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Set<String> getSupertypes() {
        return this.supertypes;
    }

    public Set<Object> getTags() {
        return this.tags;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliases == null ? 0 : this.aliases.hashCode());
        result = 31 * result + (this.containingBundle == null ? 0 : this.containingBundle.hashCode());
        result = 31 * result + (this.deprecated ? 1231 : 1237);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.disabled ? 1231 : 1237);
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.iconUrl == null ? 0 : this.iconUrl.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.supertypes == null ? 0 : this.supertypes.hashCode());
        result = 31 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeSummary other = (TypeSummary)obj;
        if (this.aliases == null ? other.aliases != null : !this.aliases.equals(other.aliases)) {
            return false;
        }
        if (this.containingBundle == null ? other.containingBundle != null : !this.containingBundle.equals(other.containingBundle)) {
            return false;
        }
        if (this.deprecated != other.deprecated) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.disabled != other.disabled) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.iconUrl == null ? other.iconUrl != null : !this.iconUrl.equals(other.iconUrl)) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        if (this.supertypes == null ? other.supertypes != null : !this.supertypes.equals(other.supertypes)) {
            return false;
        }
        if (this.symbolicName == null ? other.symbolicName != null : !this.symbolicName.equals(other.symbolicName)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return JavaClassNames.cleanSimpleClassName((Object)this) + "[" + this.symbolicName + ":" + this.version + ", containingBundle=" + this.containingBundle + ", kind=" + this.kind + ", displayName=" + this.displayName + "]";
    }
}

