/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.recipe;

import org.jclouds.karaf.recipe.RecipeManager;
import org.jclouds.karaf.recipe.RecipeManagerImpl;
import org.jclouds.karaf.recipe.RecipeProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private RecipeManager recipeManager = new RecipeManagerImpl();
    private ServiceTracker recipeProviderTracker;
    private ServiceRegistration recipeManagerRegistration;

    public void start(BundleContext context) throws Exception {
        this.recipeProviderTracker = new ServiceTracker(context, RecipeProvider.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object obj = super.addingService(reference);
                if (RecipeProvider.class.isAssignableFrom(obj.getClass())) {
                    Activator.this.recipeManager.bind((RecipeProvider)obj);
                }
                return obj;
            }

            public void removedService(ServiceReference reference, Object service) {
                if (RecipeProvider.class.isAssignableFrom(service.getClass())) {
                    Activator.this.recipeManager.unibind((RecipeProvider)service);
                }
                super.removedService(reference, service);
            }
        };
        this.recipeProviderTracker.open();
        this.recipeManagerRegistration = context.registerService(RecipeManager.class.getName(), (Object)this.recipeManager, null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.recipeProviderTracker != null) {
            this.recipeProviderTracker.close();
        }
        if (this.recipeManagerRegistration != null) {
            this.recipeManagerRegistration.unregister();
        }
    }
}

