/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchdb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.nosql.couchdb.CouchDBNode;
import org.apache.brooklyn.entity.nosql.couchdb.CouchDBNodeDriver;
import org.apache.brooklyn.entity.nosql.couchdb.CouchDBNodeImpl;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBNodeSshDriver
extends AbstractSoftwareProcessSshDriver
implements CouchDBNodeDriver {
    private static final Logger log = LoggerFactory.getLogger(CouchDBNodeSshDriver.class);

    public CouchDBNodeSshDriver(CouchDBNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
        entity.sensors().set(Attributes.LOG_FILE_LOCATION, (Object)this.getLogFileLocation());
    }

    public String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "couchdb.log"});
    }

    @Override
    public Integer getHttpPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)CouchDBNode.HTTP_PORT);
    }

    @Override
    public Integer getHttpsPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)CouchDBNode.HTTPS_PORT);
    }

    @Override
    public String getClusterName() {
        return (String)this.entity.getAttribute(CouchDBNode.CLUSTER_NAME);
    }

    @Override
    public String getCouchDBConfigTemplateUrl() {
        return (String)this.entity.getAttribute(CouchDBNode.COUCHDB_CONFIG_TEMPLATE_URL);
    }

    @Override
    public String getCouchDBUriTemplateUrl() {
        return (String)this.entity.getAttribute(CouchDBNode.COUCHDB_URI_TEMPLATE_URL);
    }

    @Override
    public String getCouchDBConfigFileName() {
        return (String)this.entity.getAttribute(CouchDBNode.COUCHDB_CONFIG_FILE_NAME);
    }

    public String getErlangVersion() {
        return (String)this.entity.getConfig(CouchDBNode.ERLANG_VERSION);
    }

    protected boolean isV2() {
        String version = this.getVersion();
        return version.startsWith("2.");
    }

    public void install() {
        log.info("Installing {}", (Object)this.entity);
        List couchdbUrls = this.resolver.getTargets();
        String coudhdbSaveAs = this.resolver.getFilename();
        MutableMap installGccPackageFlags = MutableMap.of((Object)"onlyifmissing", (Object)"gcc", (Object)"yum", (Object)"gcc", (Object)"apt", (Object)"gcc", (Object)"zypper", (Object)"gcc gcc-c++", (Object)"port", null);
        MutableMap installMakePackageFlags = MutableMap.of((Object)"onlyifmissing", (Object)"make", (Object)"yum", (Object)"make", (Object)"apt", (Object)"make", (Object)"zypper", (Object)"make", (Object)"port", null);
        MutableMap installPackageFlags = MutableMap.of((Object)"yum", (Object)"js-devel openssl-devel libicu-devel libcurl-devel erlang-erts erlang-public_key erlang-eunit erlang-sasl erlang-os_mon erlang-asn1 erlang-xmerl erlang erlangrebar", (Object)"apt", (Object)"erlang-nox erlang-dev libicu-dev libmozjs185-dev libcurl4-openssl-dev", (Object)"zypper", (Object)"erlang libicu-devel js-devel libopenssl-devel pcre-devel", (Object)"port", (Object)"icu erlang spidermonkey curl");
        ArrayList cmds = Lists.newArrayList();
        cmds.add(BashCommands.INSTALL_TAR);
        cmds.add(BashCommands.ifExecutableElse0((String)"apt-get", (String)BashCommands.installPackage((String)"build-essential")));
        cmds.add(BashCommands.ifExecutableElse0((String)"yum", (String)BashCommands.sudo((String)"yum -y --nogpgcheck groupinstall \"Development Tools\"")));
        cmds.add(BashCommands.ifExecutableElse0((String)"zypper", (String)BashCommands.sudo((String)this.getZypperRepository())));
        cmds.add(BashCommands.installPackage((Map)installGccPackageFlags, (String)"couchdb-prerequisites-gcc"));
        cmds.add(BashCommands.installPackage((Map)installMakePackageFlags, (String)"couchdb-prerequisites-make"));
        cmds.add(BashCommands.installPackage((Map)installPackageFlags, (String)"couchdb-prerequisites"));
        cmds.addAll(BashCommands.commandsToDownloadUrlsAs((List)couchdbUrls, (String)coudhdbSaveAs));
        cmds.add(String.format("tar xvzf %s", coudhdbSaveAs));
        cmds.add(String.format("cd %s", this.getExpandedInstallDir()));
        StringBuilder configureCommand = new StringBuilder("./configure").append(String.format(" --prefix=%s/dist", this.getExpandedInstallDir())).append(" --with-erlang=/usr/lib64/erlang/usr/include ");
        cmds.addAll(ImmutableList.of((Object)"mkdir -p dist", (Object)configureCommand.toString(), (Object)(this.isV2() ? "make release" : "make install")));
        ScriptHelper script = this.newScript((String)"installing").body.append((Collection)cmds).header.prepend((CharSequence)"set -x").gatherOutput().failOnNonZeroResultCode(false);
        int result = script.execute();
        if (result != 0) {
            String notes = "likely an error building couchdb. consult the brooklyn log ssh output for further details.\nnote that this Brooklyn couchdb driver compiles couchdb from source. it attempts to install common prerequisites but this does not always succeed.\n";
            OsDetails os = this.getMachine().getOsDetails();
            if (os.isMac()) {
                notes = notes + "deploying to Mac OS X, you will require Xcode and Xcode command-line tools, and on some versions the pcre library (e.g. using macports, sudo port install pcre).\n";
            }
            if (os.isWindows()) {
                notes = notes + "this couchdb driver is not designed for windows, unless cygwin is installed, and you are patient.\n";
            }
            if (!script.getResultStderr().isEmpty()) {
                notes = notes + "\nSTDERR\n" + script.getResultStderr() + "\n";
                Streams.logStreamTail((Logger)log, (String)("STDERR of problem in " + Tasks.current()), (ByteArrayOutputStream)Streams.byteArrayOfString((String)script.getResultStderr()), (int)1024);
            }
            if (!script.getResultStdout().isEmpty()) {
                notes = notes + "\nSTDOUT\n" + script.getResultStdout() + "\n";
                Streams.logStreamTail((Logger)log, (String)("STDOUT of problem in " + Tasks.current()), (ByteArrayOutputStream)Streams.byteArrayOfString((String)script.getResultStdout()), (int)1024);
            }
            Tasks.setExtraStatusDetails((String)notes.trim());
            throw new IllegalStateException("Installation of couchdb failed (shell returned non-zero result " + result + ")");
        }
    }

    public Set<Integer> getPortsUsed() {
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)super.getPortsUsed());
        result.addAll(this.getPortMap().values());
        return result;
    }

    private Map<String, Integer> getPortMap() {
        return ImmutableMap.builder().put((Object)"httpPort", (Object)this.getHttpPort()).build();
    }

    public void customize() {
        log.info("Customizing {} (Cluster {})", (Object)this.entity, (Object)this.getClusterName());
        Networking.checkPortsValid(this.getPortMap());
        ScriptHelper script = this.newScript((String)"customizing").body.append((CharSequence)String.format("mkdir -p %s", this.getRunDir()));
        if (this.isV2()) {
            script.body.append((CharSequence)String.format("mkdir -p %s/rel/couchdb/etc/local.d", this.getExpandedInstallDir()));
        } else {
            script.body.append((CharSequence)String.format("cp -R %s/dist/{bin,etc,lib,share,var} %s", this.getExpandedInstallDir(), this.getRunDir()));
        }
        script.execute();
        String destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), this.getCouchDBConfigFileName()});
        if (this.isV2()) {
            destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getExpandedInstallDir(), "/rel/couchdb/etc/local.d", this.getCouchDBConfigFileName()});
        }
        this.copyTemplate(this.getCouchDBConfigTemplateUrl(), destinationConfigFile);
        String destinationUriFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "couch.uri"});
        this.copyTemplate(this.getCouchDBUriTemplateUrl(), destinationUriFile);
    }

    public void launch() {
        log.info("Launching  {}", (Object)this.entity);
        String couchDBPath = this.isV2() ? this.getExpandedInstallDir() + "/rel/couchdb/bin/couchdb" : "./bin/couchdb";
        ScriptHelper script = this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)false), "launching");
        script.body.append((CharSequence)String.format("nohup %s -p %s -a %s -o couchdb-console.log -e couchdb-error.log -b > console.out 2>&1 &", couchDBPath, this.getPidFile(), Os.mergePathsUnix((String[])new String[]{this.getRunDir(), this.getCouchDBConfigFileName()})));
        if (this.isV2()) {
            script.body.append((CharSequence)String.format("echo $! > %s", this.getPidFile()));
        }
        script.execute();
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "couchdb.pid"});
    }

    public boolean isRunning() {
        String command = "./bin/couchdb -p %s -s";
        if (this.isV2()) {
            command = "kill -0 `cat %s`";
        }
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)String.format(command, this.getPidFile())).execute() == 0;
    }

    public void stop() {
        String command = "./bin/couchdb -p %s -k";
        if (this.isV2()) {
            command = "kill `cat %s`";
        }
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)String.format(command, this.getPidFile())).failOnNonZeroResultCode().execute();
    }

    public String getBindSection() {
        return this.isV2() ? "chttpd" : "httpd";
    }

    private String getZypperRepository() {
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        String osMajorVersion = osDetails.getVersion();
        String command = "zypper --non-interactive addrepo -f \"http://download.opensuse.org/repositories/home:/csbuild:/DBA/%1$s/\" %1$s";
        switch (osMajorVersion) {
            case "11.4": {
                command = String.format(command, "SLE_11_SP4");
                break;
            }
            case "12.0": {
                command = String.format(command, "SLE_12");
                break;
            }
            case "13.1": {
                command = String.format(command, "openSUSE_13.1");
                break;
            }
            case "13.2": {
                command = String.format(command, "openSUSE_13.2");
                break;
            }
            default: {
                command = "echo UNSUPPORTED SuSE version && exit 1";
            }
        }
        return command;
    }
}

