/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.objs;

import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.objs.Identifiable;
import org.apache.brooklyn.api.relations.RelationshipType;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEventListener;

public interface BrooklynObject
extends Identifiable,
Configurable {
    public String getDisplayName();

    public String getCatalogItemId();

    public List<String> getCatalogItemIdSearchPath();

    public TagSupport tags();

    public SubscriptionSupport subscriptions();

    public RelationSupport<?> relations();

    public static interface RelationSupport<T extends BrooklynObject> {
        public <U extends BrooklynObject> void add(RelationshipType<? super T, ? super U> var1, U var2);

        public <U extends BrooklynObject> void remove(RelationshipType<? super T, ? super U> var1, U var2);

        public Set<RelationshipType<? super T, ? extends BrooklynObject>> getRelationshipTypes();

        public <U extends BrooklynObject> Set<U> getRelations(RelationshipType<? super T, U> var1);
    }

    @Beta
    public static interface SubscriptionSupport {
        @Beta
        public <T> SubscriptionHandle subscribe(Entity var1, Sensor<T> var2, SensorEventListener<? super T> var3);

        @Beta
        public <T> SubscriptionHandle subscribe(Map<String, ?> var1, Entity var2, Sensor<T> var3, SensorEventListener<? super T> var4);

        @Beta
        public <T> SubscriptionHandle subscribeToChildren(Entity var1, Sensor<T> var2, SensorEventListener<? super T> var3);

        @Beta
        public <T> SubscriptionHandle subscribeToMembers(Group var1, Sensor<T> var2, SensorEventListener<? super T> var3);

        @Beta
        public boolean unsubscribe(Entity var1);

        @Beta
        public boolean unsubscribe(Entity var1, SubscriptionHandle var2);

        public boolean unsubscribe(SubscriptionHandle var1);
    }

    public static interface TagSupport {
        @Nonnull
        public Set<Object> getTags();

        public boolean containsTag(@Nonnull Object var1);

        public boolean addTag(@Nonnull Object var1);

        public boolean addTags(@Nonnull Iterable<?> var1);

        public boolean removeTag(@Nonnull Object var1);
    }
}

