/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.javax.annotation.Nullable;

public class FirewallRule
implements Comparable<FirewallRule> {
    private final String id;
    private final Set<String> CIDRs;
    private final int startPort;
    private final int endPort;
    private final String icmpCode;
    private final String icmpType;
    private final String ipAddress;
    private final String ipAddressId;
    private final Protocol protocol;
    private final State state;
    private final Set<Tag> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromFirewallRule(this);
    }

    @ConstructorProperties(value={"id", "cidrlist", "startport", "endport", "icmpcode", "icmptype", "ipaddress", "ipaddressid", "protocol", "state", "tags"})
    private FirewallRule(String id, @Nullable String CIDRs, int startPort, int endPort, @Nullable String icmpCode, @Nullable String icmpType, @Nullable String ipAddress, @Nullable String ipAddressId, @Nullable Protocol protocol, @Nullable State state, @Nullable Set<Tag> tags) {
        this(id, FirewallRule.splitStringOnCommas(CIDRs), startPort, endPort, icmpCode, icmpType, ipAddress, ipAddressId, protocol, state, tags);
    }

    private static Set<String> splitStringOnCommas(String in) {
        return in == null ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])in.split(","));
    }

    protected FirewallRule(String id, @Nullable Iterable<String> CIDRs, int startPort, int endPort, @Nullable String icmpCode, @Nullable String icmpType, @Nullable String ipAddress, @Nullable String ipAddressId, @Nullable Protocol protocol, @Nullable State state, @Nullable Set<Tag> tags) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.CIDRs = CIDRs == null ? ImmutableSet.of() : ImmutableSet.copyOf(CIDRs);
        this.startPort = startPort;
        this.endPort = endPort;
        this.icmpCode = icmpCode;
        this.icmpType = icmpType;
        this.ipAddress = ipAddress;
        this.ipAddressId = ipAddressId;
        this.protocol = protocol;
        this.state = state;
        this.tags = tags == null ? ImmutableSet.of() : ImmutableSet.copyOf(tags);
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    @Nullable
    public String getIcmpCode() {
        return this.icmpCode;
    }

    @Nullable
    public String getIcmpType() {
        return this.icmpType;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Nullable
    public String getIpAddressId() {
        return this.ipAddressId;
    }

    @Nullable
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public Set<Tag> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.CIDRs, this.startPort, this.endPort, this.icmpCode, this.icmpType, this.ipAddress, this.ipAddressId, this.protocol, this.state, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallRule that = (FirewallRule)FirewallRule.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal(this.CIDRs, that.CIDRs) && Objects.equal((Object)this.startPort, (Object)that.startPort) && Objects.equal((Object)this.endPort, (Object)that.endPort) && Objects.equal((Object)this.icmpCode, (Object)that.icmpCode) && Objects.equal((Object)this.icmpType, (Object)that.icmpType) && Objects.equal((Object)this.ipAddress, (Object)that.ipAddress) && Objects.equal((Object)this.ipAddressId, (Object)that.ipAddressId) && Objects.equal((Object)((Object)this.protocol), (Object)((Object)that.protocol)) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal(this.tags, that.tags);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("CIDRs", this.CIDRs).add("startPort", this.startPort).add("endPort", this.endPort).add("icmpCode", (Object)this.icmpCode).add("icmpType", (Object)this.icmpType).add("ipAddress", (Object)this.ipAddress).add("ipAddressId", (Object)this.ipAddressId).add("protocol", (Object)this.protocol).add("state", (Object)this.state).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(FirewallRule other) {
        return this.id.compareTo(other.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected Set<String> CIDRs = ImmutableSet.of();
        protected int startPort;
        protected int endPort;
        protected String icmpCode;
        protected String icmpType;
        protected String ipAddress;
        protected String ipAddressId;
        protected Protocol protocol;
        protected State state;
        protected Set<Tag> tags = ImmutableSet.of();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T CIDRs(Set<String> CIDRs) {
            this.CIDRs = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(CIDRs, (Object)"CIDRs")));
            return this.self();
        }

        public T CIDRs(String ... in) {
            return this.CIDRs((Set<String>)ImmutableSet.copyOf((Object[])in));
        }

        public T startPort(int startPort) {
            this.startPort = startPort;
            return this.self();
        }

        public T endPort(int endPort) {
            this.endPort = endPort;
            return this.self();
        }

        public T icmpCode(String icmpCode) {
            this.icmpCode = icmpCode;
            return this.self();
        }

        public T icmpType(String icmpType) {
            this.icmpType = icmpType;
            return this.self();
        }

        public T ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this.self();
        }

        public T ipAddressId(String ipAddressId) {
            this.ipAddressId = ipAddressId;
            return this.self();
        }

        public T protocol(Protocol protocol) {
            this.protocol = protocol;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T tags(Set<Tag> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this.self();
        }

        public T tags(Tag ... in) {
            return this.tags((Set<Tag>)ImmutableSet.copyOf((Object[])in));
        }

        public FirewallRule build() {
            return new FirewallRule(this.id, this.CIDRs, this.startPort, this.endPort, this.icmpCode, this.icmpType, this.ipAddress, this.ipAddressId, this.protocol, this.state, this.tags);
        }

        public T fromFirewallRule(FirewallRule in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).CIDRs(in.getCIDRs())).startPort(in.getStartPort())).endPort(in.getEndPort())).icmpCode(in.getIcmpCode())).icmpType(in.getIcmpType())).ipAddress(in.getIpAddress())).ipAddressId(in.getIpAddressId())).protocol(in.getProtocol())).state(in.getState())).tags(in.getTags());
        }
    }

    public static enum State {
        STAGED,
        ADD,
        ACTIVE,
        DELETING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        ICMP,
        UNKNOWN;


        public static Protocol fromValue(String value) {
            try {
                return Protocol.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toUpperCase();
        }
    }
}

