/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class BashCommands {
    public static final String INSTALL_TAR = BashCommands.installExecutable("tar");
    public static final String INSTALL_CURL = BashCommands.installExecutable("curl");
    public static final String INSTALL_WGET = BashCommands.installExecutable("wget");
    public static final String INSTALL_ZIP = BashCommands.installExecutable("zip");
    public static final String INSTALL_UNZIP = BashCommands.alternatives(BashCommands.installExecutable("unzip"), BashCommands.installExecutable("zip"));
    public static final String INSTALL_SYSSTAT = BashCommands.installPackage(ImmutableMap.of((Object)"onlyifmissing", (Object)"iostat"), "sysstat");

    public static String installExecutable(Map<?, ?> flags, String executable) {
        return BashCommands.onlyIfExecutableMissing(executable, BashCommands.installPackage(flags, executable));
    }

    public static String installExecutable(String executable) {
        return BashCommands.installExecutable(MutableMap.of(), executable);
    }

    public static String quiet(String command) {
        return String.format("(%s > /dev/null 2>&1)", command);
    }

    public static String ok(String command) {
        return String.format("(%s || true)", command);
    }

    public static String sudo(String command) {
        if (command == null) {
            return null;
        }
        if (command.startsWith("( ") || command.endsWith(" &")) {
            return BashCommands.sudoNew(command);
        }
        return BashCommands.sudoOld(command);
    }

    public static String authSudo(String command, String password) {
        Preconditions.checkNotNull((Object)password, (Object)"password must not be null");
        if (command == null) {
            return null;
        }
        if (command.startsWith("( ") || command.endsWith(" &")) {
            throw new UnsupportedOperationException("authSudo supports only simple commands, not those wrapped in parentheses or backgrounded: cmd=" + command);
        }
        return String.format("( if test \"$UID\" -eq 0; then ( %s ); else echo -e '%s\\n' | sudo -E -S -- %s; fi )", command, password, command);
    }

    private static String sudoOld(String command) {
        if (command == null) {
            return null;
        }
        return String.format("( if test \"$UID\" -eq 0; then ( %s ); else sudo -E -n -S -- %s; fi )", command, command);
    }

    private static String sudoNew(String command) {
        if (command == null) {
            return null;
        }
        return "( if test \"$UID\" -eq 0; then ( " + command + " ); else echo " + StringEscapes.BashStringEscapes.wrapBash(command) + " | sudo -E -n -S -s -- bash ; fi )";
    }

    @Deprecated
    @Beta
    public static String sudoAsUser(String user, String command) {
        return BashCommands.sudoAsUserOld(user, command);
    }

    private static String sudoAsUserOld(String user, String command) {
        if (command == null) {
            return null;
        }
        return String.format("{ sudo -E -n -u %s -s -- %s ; }", user, command);
    }

    public static String addSbinPathCommand() {
        return "export PATH=" + BashCommands.sbinPath();
    }

    public static String sbinPath() {
        return "$PATH:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin";
    }

    public static String executeCommandThenAsUserTeeOutputToFile(String commandWhoseOutputToWrite, String user, String file) {
        return String.format("{ %s | sudo -E -n -u %s -s -- tee -a %s ; }", commandWhoseOutputToWrite, user, file);
    }

    public static String dontRequireTtyForSudo() {
        String sudoersFileName = "/etc/sudoers";
        String tmpSuffix = Identifiers.makeRandomLowercaseId(6);
        return BashCommands.ifFileExistsElse0(sudoersFileName, BashCommands.alternatives(BashCommands.sudo(String.format("grep brooklyn-removed-require-tty %s", sudoersFileName)), BashCommands.chainGroup(BashCommands.sudo(String.format("cp %1$s %1$s.%2$s", sudoersFileName, tmpSuffix)), BashCommands.sudo(String.format("sed -i.brooklyn.bak 's/.*requiretty.*/#brooklyn-removed-require-tty/' %1$s.%2$s", sudoersFileName, tmpSuffix)), BashCommands.sudo(String.format("visudo -c -f %1$s.%2$s", sudoersFileName, tmpSuffix)), BashCommands.sudo(String.format("mv %1$s.%2$s %1$s", sudoersFileName, tmpSuffix)))));
    }

    public static String generateKeyInDotSshIdRsaIfNotThere() {
        return "[ -f ~/.ssh/id_rsa ] || ( mkdir -p ~/.ssh ; chmod 700 ~/.ssh ; ssh-keygen -t rsa -N '' -f ~/.ssh/id_rsa )";
    }

    public static String ifFileExistsElse0(String path, String command) {
        return BashCommands.alternativesGroup(BashCommands.chainGroup(String.format("test ! -e %s", path), "true"), command);
    }

    public static String ifFileExistsElse1(String path, String command) {
        return BashCommands.chainGroup(String.format("test -e %s", path), command);
    }

    public static String ifExecutableElse0(String executable, String command) {
        return BashCommands.alternativesGroup(BashCommands.chainGroup(String.format("test -z `which %s`", executable), "true"), command);
    }

    public static String ifExecutableElse1(String executable, String command) {
        return BashCommands.chainGroup(String.format("which %s", executable), command);
    }

    public static String ifNotExecutable(String command, String statement) {
        return String.format("{ { test ! -z `which %s`; } || { %s; } }", command, statement);
    }

    public static String onlyIfExecutableMissing(String executable, String command) {
        return BashCommands.alternativesGroup(String.format("which %s", executable), command);
    }

    @Deprecated
    public static String ifExecutableElse(String command, String ifNotExist, String ifExist) {
        return BashCommands.ifExecutableDoesNotExistElse(command, ifNotExist, ifExist);
    }

    public static String ifExecutableDoesNotExistElse(String command, String ifNotExist, String ifExist) {
        return Joiner.on((char)'\n').join(BashCommands.ifExecutableDoesNotExistElse(command, (List<String>)ImmutableList.of((Object)ifNotExist), (List<String>)ImmutableList.of((Object)ifExist)));
    }

    @Deprecated
    public static ImmutableList<String> ifExecutableElse(String command, List<String> ifNotExist, List<String> ifExist) {
        return BashCommands.ifExecutableDoesNotExistElse(command, ifNotExist, ifExist);
    }

    public static ImmutableList<String> ifExecutableDoesNotExistElse(String command, List<String> ifNotExist, List<String> ifExist) {
        return ImmutableList.builder().add((Object)String.format("if test -z `which %s`; then", command)).addAll(ifNotExist).add((Object)"else").addAll(ifExist).add((Object)"fi").build();
    }

    public static String chain(Collection<String> commands) {
        return "( " + Strings.join(commands, " && ") + " )";
    }

    public static String chain(String ... commands) {
        return "( " + Strings.join(commands, " && ") + " )";
    }

    public static String chainGroup(Collection<String> commands) {
        return "{ " + Strings.join(commands, " && ") + " ; }";
    }

    public static String chainGroup(String ... commands) {
        return "{ " + Strings.join(commands, " && ") + " ; }";
    }

    public static String chainSubshell(Collection<String> commands) {
        return "( " + Strings.join(commands, " && ") + " )";
    }

    public static String chainSubshell(String ... commands) {
        return "( " + Strings.join(commands, " && ") + "  )";
    }

    public static String alternatives(Collection<String> commands) {
        return "( " + Strings.join(commands, " || ") + " )";
    }

    public static String alternatives(String ... commands) {
        return "( " + Strings.join(commands, " || ") + " )";
    }

    public static String alternativesGroup(Collection<String> commands) {
        return "{ " + Strings.join(commands, " || ") + " ; }";
    }

    public static String alternativesGroup(String ... commands) {
        return "{ " + Strings.join(commands, " || ") + " ; }";
    }

    public static String alternativesSubshell(Collection<String> commands) {
        return "( " + Strings.join(commands, " || ") + " )";
    }

    public static String alternativesSubshell(String ... commands) {
        return "( " + Strings.join(commands, " || ") + "  )";
    }

    public static String formatIfNotNull(String pattern, Object arg) {
        if (arg == null) {
            return null;
        }
        return String.format(pattern, arg);
    }

    public static String installPackage(String packageDefaultName) {
        return BashCommands.installPackage(MutableMap.of(), packageDefaultName);
    }

    public static String installPackage(Map<?, ?> flags, String packageDefaultName) {
        return BashCommands.installPackageOr(flags, packageDefaultName, null);
    }

    public static String installPackageOrFail(Map<?, ?> flags, String packageDefaultName) {
        return BashCommands.installPackageOr(flags, packageDefaultName, "exit 9");
    }

    public static String installPackageOr(Map<?, ?> flags, String packageDefaultName, String optionalCommandToRunIfNone) {
        String ifMissing = (String)flags.get("onlyifmissing");
        String zypperInstall = BashCommands.formatIfNotNull("zypper --non-interactive --no-gpg-checks install %s", BashCommands.getFlag(flags, "zypper", packageDefaultName));
        String aptInstall = BashCommands.formatIfNotNull("apt-get install -y --allow-unauthenticated %s", BashCommands.getFlag(flags, "apt", packageDefaultName));
        String yumInstall = BashCommands.formatIfNotNull("yum -y --nogpgcheck install %s", BashCommands.getFlag(flags, "yum", packageDefaultName));
        String brewInstall = BashCommands.formatIfNotNull("brew install %s", BashCommands.getFlag(flags, "brew", packageDefaultName));
        String portInstall = BashCommands.formatIfNotNull("port install %s", BashCommands.getFlag(flags, "port", packageDefaultName));
        LinkedList<String> commands = new LinkedList<String>();
        if (ifMissing != null) {
            commands.add(String.format("which %s", ifMissing));
        }
        if (zypperInstall != null) {
            commands.add(BashCommands.ifExecutableElse1("zypper", BashCommands.chainGroup("echo zypper exists, doing refresh", BashCommands.ok(BashCommands.sudo("zypper --non-interactive --no-gpg-checks refresh")), BashCommands.sudo(zypperInstall))));
        }
        if (aptInstall != null) {
            commands.add(BashCommands.ifExecutableElse1("apt-get", BashCommands.chainGroup("echo apt-get exists, doing update", "export DEBIAN_FRONTEND=noninteractive", BashCommands.ok(BashCommands.sudo("apt-get update")), BashCommands.sudo(aptInstall))));
        }
        if (yumInstall != null) {
            commands.add(BashCommands.ifExecutableElse1("yum", BashCommands.chainGroup("echo yum exists, doing update", BashCommands.ok(BashCommands.sudo("yum check-update")), BashCommands.ok(BashCommands.sudo("yum -y install epel-release")), BashCommands.ok(BashCommands.sudo("yum upgrade -y ca-certificates --disablerepo=epel")), BashCommands.sudo(yumInstall))));
        }
        if (brewInstall != null) {
            commands.add(BashCommands.ifExecutableElse1("brew", brewInstall));
        }
        if (portInstall != null) {
            commands.add(BashCommands.ifExecutableElse1("port", BashCommands.sudo(portInstall)));
        }
        String lastCommand = BashCommands.ok(BashCommands.warn("WARNING: no known/successful package manager to install " + (packageDefaultName != null ? packageDefaultName : flags.toString()) + ", may fail subsequently"));
        if (optionalCommandToRunIfNone != null) {
            lastCommand = BashCommands.chain(lastCommand, optionalCommandToRunIfNone);
        }
        commands.add(lastCommand);
        return BashCommands.alternatives(commands);
    }

    public static String warn(String message) {
        return "( echo " + StringEscapes.BashStringEscapes.wrapBash(message) + " | tee /dev/stderr )";
    }

    public static String fail(String message, int code) {
        return BashCommands.chainGroup(BashCommands.warn(message), "exit " + code);
    }

    public static String require(String command, String failureMessage, int exitCode) {
        return BashCommands.alternativesGroup(command, BashCommands.fail(failureMessage, exitCode));
    }

    public static String require(String command, String failureMessage) {
        return BashCommands.alternativesGroup(command, BashCommands.chainGroup("EXIT_CODE=$?", BashCommands.warn(failureMessage), "exit $EXIT_CODE"));
    }

    public static String requireTest(String test, String failureMessage, int exitCode) {
        return BashCommands.require("test " + test, failureMessage, exitCode);
    }

    public static String requireTest(String test, String failureMessage) {
        return BashCommands.require("test " + test, failureMessage);
    }

    public static String requireFile(String file) {
        return BashCommands.requireTest("-f " + StringEscapes.BashStringEscapes.wrapBash(file), "The required file \"" + file + "\" does not exist");
    }

    public static String requireExecutable(String command) {
        return BashCommands.require("which " + StringEscapes.BashStringEscapes.wrapBash(command), "The required executable \"" + command + "\" does not exist");
    }

    public static String waitForFileContents(String file, String desiredContent, Duration timeout, boolean failOnTimeout) {
        long secs = Math.max(timeout.toSeconds(), 1L);
        ImmutableList commands = ImmutableList.of((Object)("for i in {1.." + secs + "}; do"), (Object)("    grep '" + desiredContent + "' " + file + " && result=0 || result=$?"), (Object)"    [ \"$result\" == 0 ] && break", (Object)"    sleep 1", (Object)"done", (Object)"if test \"$result\" -ne 0; then", (Object)("    ls -l " + file + " || true"), (Object)("    cat " + file + " || true"), (Object)("    " + (failOnTimeout ? "echo \"Couldn't find " + desiredContent + " in " + file + "; aborting\" && exit 1" : "echo \"Couldn't find " + desiredContent + " in " + file + "; continuing\"")), (Object)"fi");
        return Joiner.on((String)"\n").join((Iterable)commands);
    }

    public static String waitForFileExists(String file, Duration timeout, boolean failOnTimeout) {
        long secs = Math.max(timeout.toSeconds(), 1L);
        ImmutableList commands = ImmutableList.of((Object)("for i in {1.." + secs + "}; do"), (Object)("    [[ -f " + file + " ]] && result=0 || result=$?"), (Object)"    [ \"$result\" == 0 ] && break", (Object)"    sleep 1", (Object)"done", (Object)"if test \"$result\" -ne 0; then", (Object)("    " + (failOnTimeout ? "echo \"Couldn't find file " + file + "; aborting\" && exit 1" : "echo \"Couldn't find file " + file + "; continuing\"")), (Object)"fi");
        return Joiner.on((String)"\n").join((Iterable)commands);
    }

    public static String waitForPortFree(int port, Duration timeout, boolean failOnTimeout) {
        long secs = Math.max(timeout.toSeconds(), 1L);
        String netstatCommand = BashCommands.alternativesGroup("sudo netstat -antp --tcp", "sudo netstat -antp TCP");
        String grepCommand = "grep -E '(:|\\.)" + port + "($|\\s)' > /dev/null";
        ImmutableList commands = ImmutableList.of((Object)("for i in {1.." + secs + "}; do"), (Object)("    " + BashCommands.requireExecutable("netstat")), (Object)("    " + BashCommands.alternativesGroup(BashCommands.chainGroup("which awk", "AWK_EXEC=awk"), BashCommands.chainGroup("which gawk", "AWK_EXEC=gawk"), BashCommands.chainGroup("which /usr/bin/awk", "AWK_EXEC=/usr/bin/awk"), BashCommands.chainGroup("echo \"No awk to determine if Port " + port + " still in use; aborting\"", "exit 1"))), (Object)("    " + netstatCommand + " | $AWK_EXEC '{print $4}' | " + grepCommand + " && result=0 || result=$?"), (Object)"    [ \"$result\" != 0 ] && break", (Object)"    sleep 1", (Object)"done", (Object)"if test \"$result\" -eq 0; then", (Object)("    " + (failOnTimeout ? "echo \"Port " + port + " still in use (according to netstat); aborting\" && exit 1" : "echo \"Port " + port + " still in use (according to netstat); continuing\"")), (Object)"fi");
        return Joiner.on((String)"\n").join((Iterable)commands);
    }

    public static String unzip(String file, String targetDir) {
        return "unzip " + file + (Strings.isNonBlank(targetDir) ? " -d " + targetDir : "");
    }

    public static List<String> commandsToDownloadUrlsAs(List<String> urls, String saveAs) {
        return Arrays.asList(INSTALL_CURL, BashCommands.require(BashCommands.simpleDownloadUrlAs(urls, saveAs), "Could not retrieve " + saveAs + ". Tried: " + Joiner.on((String)", ").join(urls), 9));
    }

    public static String commandToDownloadUrlsAs(List<String> urls, String saveAs) {
        return BashCommands.chain(INSTALL_CURL, BashCommands.require(BashCommands.simpleDownloadUrlAs(urls, saveAs), "Could not retrieve " + saveAs + ". Tried: " + Joiner.on((String)", ").join(urls), 9));
    }

    public static String commandToDownloadUrlAs(String url, String saveAs) {
        return BashCommands.chain(INSTALL_CURL, BashCommands.require(BashCommands.simpleDownloadUrlAs(Arrays.asList(url), saveAs), "Could not retrieve " + saveAs + " from " + url, 9));
    }

    public static String downloadToStdout(List<String> urls) {
        return BashCommands.chain(INSTALL_CURL + " > /dev/null", BashCommands.require(BashCommands.simpleDownloadUrlAs(urls, null), "Could not retrieve file. Tried: " + Joiner.on((String)", ").join(urls), 9));
    }

    public static String downloadToStdout(String ... urls) {
        return BashCommands.downloadToStdout(Arrays.asList(urls));
    }

    public static String simpleDownloadUrlAs(List<String> urls, String saveAs) {
        return BashCommands.simpleDownloadUrlAs(urls, null, null, saveAs);
    }

    public static String simpleDownloadUrlAs(List<String> urls, String user, String password, String saveAs) {
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("No URLs supplied to download " + saveAs);
        }
        ArrayList<String> commands = new ArrayList<String>();
        for (String url : urls) {
            String command = "curl -f -L -k --retry 10 --keepalive-time 30 --speed-time 30 ";
            if (user != null && password != null) {
                command = command + String.format("-u %s:%s ", user, password);
            }
            command = command + String.format("\"%s\"", url);
            if (saveAs != null) {
                command = command + String.format(" -o %s", saveAs);
            }
            commands.add(command);
        }
        return BashCommands.alternatives(commands);
    }

    private static Object getFlag(Map<?, ?> flags, String flagName, Object defaultValue) {
        Object found = flags.get(flagName);
        return found == null ? defaultValue : found;
    }

    public static String installJava(int version) {
        Preconditions.checkArgument((version == 6 || version == 7 || version == 8 ? 1 : 0) != 0, (Object)"Supported Java versions are 6, 7, or 8");
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(BashCommands.ok(BashCommands.addOpenJDKPPK()));
        commands.add(BashCommands.installPackageOr(MutableMap.of("apt", "openjdk-" + version + "-jdk", "yum", "java-1." + version + ".0-openjdk-devel"), null, BashCommands.ifExecutableElse1("zypper", BashCommands.chainGroup(BashCommands.ok(BashCommands.sudo("zypper --non-interactive addrepo http://download.opensuse.org/repositories/Java:/openjdk6:/Factory/SLE_11_SP3 java_sles_11")), BashCommands.ok(BashCommands.sudo("zypper --non-interactive addrepo http://download.opensuse.org/repositories/Java:/openjdk6:/Factory/openSUSE_11.4 java_suse_11")), BashCommands.ok(BashCommands.sudo("zypper --non-interactive addrepo http://download.opensuse.org/repositories/Java:/openjdk6:/Factory/openSUSE_12.3 java_suse_12")), BashCommands.ok(BashCommands.sudo("zypper --non-interactive addrepo http://download.opensuse.org/repositories/Java:/openjdk6:/Factory/openSUSE_13.1 java_suse_13")), BashCommands.alternatives(BashCommands.installPackageOrFail(MutableMap.of("zypper", "java-1_" + version + "_0-openjdk-devel"), null), BashCommands.installPackageOrFail(MutableMap.of("zypper", "java-1_" + version + "_0-ibm"), null))))));
        commands.add(BashCommands.ok(BashCommands.upgradeNSS()));
        return BashCommands.chainGroup(commands);
    }

    public static String installJava6() {
        return BashCommands.installJava(6);
    }

    public static String installJava7() {
        return BashCommands.installJava(7);
    }

    public static String installJava8() {
        return BashCommands.installJava(8);
    }

    public static String installJava6IfPossible() {
        return BashCommands.ok(BashCommands.installJava6());
    }

    public static String installJava7IfPossible() {
        return BashCommands.ok(BashCommands.installJava7());
    }

    public static String installJava8IfPossible() {
        return BashCommands.ok(BashCommands.installJava8());
    }

    public static String installJava6OrFail() {
        return BashCommands.alternatives(BashCommands.installJava6(), BashCommands.fail("java 6 install failed", 9));
    }

    public static String installJava7OrFail() {
        return BashCommands.alternatives(BashCommands.installJava7(), BashCommands.fail("java 7 install failed", 9));
    }

    public static String installJava7Or6OrFail() {
        return BashCommands.alternatives(BashCommands.installJava7(), BashCommands.installJava6(), BashCommands.fail("java install failed", 9));
    }

    public static String installJavaLatestOrFail() {
        return BashCommands.alternatives(BashCommands.installJava8(), BashCommands.installJava7(), BashCommands.installJava6(), BashCommands.fail("java latest install failed", 9));
    }

    public static String installJavaLatestOrWarn() {
        return BashCommands.alternatives(BashCommands.installJava8(), BashCommands.installJava7(), BashCommands.installJava6(), BashCommands.warn("java latest install failed, entity may subsequently fail"));
    }

    public static String addOpenJDKPPK() {
        return BashCommands.chainGroup(BashCommands.sudo("sudo add-apt-repository -y ppa:openjdk-r/ppa"), BashCommands.sudo("sudo apt-get update"));
    }

    public static String upgradeNSS() {
        return BashCommands.chainGroup("which yum", BashCommands.sudo("yum -y upgrade nss"));
    }

    public static String pipeTextTo(String text, String command) {
        return "cat << EOL_BROOKLYN | " + command + "\n" + text + "\nEOL_BROOKLYN\n";
    }

    public static String pipeTextToFile(String text, String filepath) {
        return "cat > \"" + filepath + "\" << EOF_BROOKLYN\n" + text + "\nEOF_BROOKLYN\n";
    }

    public static String prependToEtcHosts(String ip, String ... hostnames) {
        String tempFileId = "bak" + Identifiers.makeRandomId(4);
        return BashCommands.sudo(String.format("sed -i." + tempFileId + " -e '1i\\\n%s %s' /etc/hosts", ip, Joiner.on((String)" ").join((Object[])hostnames)));
    }

    public static String appendToEtcHosts(String ip, String ... hostnames) {
        String tempFileId = "bak" + Identifiers.makeRandomId(4);
        return BashCommands.sudo(String.format("sed -i." + tempFileId + " -e '$a\\\n%s %s' /etc/hosts", ip, Joiner.on((String)" ").join((Object[])hostnames)));
    }

    @Beta
    public static List<String> setHostname(String newHostname) {
        if (newHostname.indexOf(".") > 0) {
            String hostPart = newHostname.substring(0, newHostname.indexOf("."));
            String domainPart = newHostname.substring(hostPart.length() + 1);
            return BashCommands.setHostname(hostPart, domainPart);
        }
        return BashCommands.setHostname(newHostname, null);
    }

    @Beta
    public static List<String> setHostname(String hostPart, String domainPart) {
        Preconditions.checkNotNull((Object)hostPart, (Object)"hostPart");
        Preconditions.checkArgument((!hostPart.contains(".") ? 1 : 0) != 0, (String)"hostPart '%s' must not contain '.'", (Object[])new Object[]{hostPart});
        String tempFileId = "bak" + Identifiers.makeRandomId(4);
        ArrayList allhostnames = Lists.newArrayList();
        String fqdn = hostPart;
        if (Strings.isNonBlank(domainPart)) {
            fqdn = hostPart + "." + domainPart;
            allhostnames.add(fqdn);
        }
        allhostnames.add(hostPart);
        allhostnames.add("localhost");
        return ImmutableList.of((Object)BashCommands.sudo("sed -i." + tempFileId + " -e 's/^127.0.0.1/# Replaced by Brooklyn\\\n#127.0.0.1/' /etc/hosts"), (Object)BashCommands.prependToEtcHosts("127.0.0.1", allhostnames.toArray(new String[allhostnames.size()])), (Object)BashCommands.ifFileExistsElse0("/etc/sysconfig/network", BashCommands.sudo("sed -i." + tempFileId + " -e 's/^HOSTNAME=.*$/HOSTNAME=" + hostPart + "/' /etc/sysconfig/network")), (Object)BashCommands.ifFileExistsElse0("/etc/hostname", BashCommands.sudo("sed -i." + tempFileId + " -e 's/^[a-zA-Z_0-9].*$/" + hostPart + "/' /etc/hostname")), (Object)BashCommands.sudo("hostname " + hostPart));
    }
}

