/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import org.jclouds.compute.domain.ComputeMetadataBuilder;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;

public class SecurityGroupBuilder
extends ComputeMetadataBuilder {
    private ImmutableSet.Builder<IpPermission> ipPermissions = ImmutableSet.builder();
    private String ownerId;

    public SecurityGroupBuilder() {
        super(ComputeType.SECURITYGROUP);
    }

    public SecurityGroupBuilder ipPermissions() {
        this.ipPermissions = ImmutableSet.builder();
        return this;
    }

    public SecurityGroupBuilder ipPermissions(Iterable<IpPermission> ipPermissions) {
        this.ipPermissions.addAll((Iterable)Preconditions.checkNotNull(ipPermissions, (Object)"ipPermissions"));
        return this;
    }

    public SecurityGroupBuilder ipPermission(IpPermission ipPermission) {
        this.ipPermissions.add(Preconditions.checkNotNull((Object)ipPermission, (Object)"ipPermission"));
        return this;
    }

    public SecurityGroupBuilder ownerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @Override
    public SecurityGroupBuilder id(String id) {
        return (SecurityGroupBuilder)((Object)SecurityGroupBuilder.class.cast((Object)super.id(id)));
    }

    @Override
    public SecurityGroupBuilder tags(Iterable<String> tags) {
        return (SecurityGroupBuilder)((Object)SecurityGroupBuilder.class.cast((Object)super.tags(tags)));
    }

    @Override
    public SecurityGroupBuilder ids(String id) {
        return (SecurityGroupBuilder)((Object)SecurityGroupBuilder.class.cast((Object)super.ids(id)));
    }

    @Override
    public SecurityGroupBuilder providerId(String providerId) {
        return (SecurityGroupBuilder)((Object)SecurityGroupBuilder.class.cast((Object)super.providerId(providerId)));
    }

    @Override
    public SecurityGroupBuilder name(String name) {
        return (SecurityGroupBuilder)((Object)SecurityGroupBuilder.class.cast((Object)super.name(name)));
    }

    @Override
    public SecurityGroupBuilder location(Location location) {
        return (SecurityGroupBuilder)((Object)SecurityGroupBuilder.class.cast((Object)super.location(location)));
    }

    @Override
    public SecurityGroupBuilder uri(URI uri) {
        return (SecurityGroupBuilder)((Object)SecurityGroupBuilder.class.cast((Object)super.uri(uri)));
    }

    @Override
    public SecurityGroupBuilder userMetadata(Map<String, String> userMetadata) {
        return (SecurityGroupBuilder)((Object)SecurityGroupBuilder.class.cast(super.userMetadata((Map)userMetadata)));
    }

    @Override
    public SecurityGroup build() {
        return new SecurityGroup(this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata, this.tags, (Iterable<IpPermission>)this.ipPermissions.build(), this.ownerId);
    }

    public static SecurityGroupBuilder fromSecurityGroup(SecurityGroup group) {
        return ((SecurityGroupBuilder)((SecurityGroupBuilder)new SecurityGroupBuilder().providerId(group.getProviderId()).name(group.getName()).id(group.getId()).location(group.getLocation()).uri(group.getUri()).userMetadata(group.getUserMetadata())).tags(group.getTags())).ipPermissions(group.getIpPermissions()).ownerId(group.getOwnerId());
    }
}

