/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.proxy.nginx;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.feed.ConfigToAttributes;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.proxy.AbstractControllerImpl;
import org.apache.brooklyn.entity.proxy.ProxySslConfig;
import org.apache.brooklyn.entity.proxy.nginx.NginxConfigFileGenerator;
import org.apache.brooklyn.entity.proxy.nginx.NginxController;
import org.apache.brooklyn.entity.proxy.nginx.NginxDriver;
import org.apache.brooklyn.entity.proxy.nginx.NginxSshDriver;
import org.apache.brooklyn.entity.proxy.nginx.UrlMapping;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.file.ArchiveUtils;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NginxControllerImpl
extends AbstractControllerImpl
implements NginxController,
NginxController.NginxControllerInternal {
    private static final Logger LOG = LoggerFactory.getLogger(NginxControllerImpl.class);
    private volatile HttpFeed httpFeed;
    private final Set<String> installedKeysCache = Sets.newLinkedHashSet();
    protected UrlMappingsMemberTrackerPolicy urlMappingsMemberTrackerPolicy;
    protected SubscriptionHandle targetAddressesHandler;

    @Override
    public void reload() {
        NginxSshDriver driver = (NginxSshDriver)this.getDriver();
        if (driver == null) {
            Lifecycle state = (Lifecycle)this.getAttribute(NginxController.SERVICE_STATE_ACTUAL);
            throw new IllegalStateException("Cannot reload (no driver instance; stopped? (state=" + state + ")");
        }
        driver.reload();
    }

    @Override
    public boolean isSticky() {
        return (Boolean)this.getConfig(STICKY);
    }

    @Override
    public void connectSensors() {
        super.connectSensors();
        ConfigToAttributes.apply((Entity)this);
        this.httpFeed = (HttpFeed)this.addFeed((Feed)HttpFeed.builder().uniqueTag("nginx-poll").entity((Entity)this).period(((Long)this.getConfig(HTTP_POLL_PERIOD)).longValue()).baseUri((Supplier)new UrlInferencer(null)).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(NGINX_URL_ANSWERS_NICELY).checkSuccess(Predicates.alwaysTrue())).onResult(HttpValueFunctions.containsHeader((String)"Server"))).setOnException((Object)false)).suppressDuplicates(true)).build());
        new Function<HttpToolResponse, Boolean>(){

            public Boolean apply(HttpToolResponse input) {
                List actual = (List)input.getHeaderLists().get("Server");
                return actual != null && actual.size() == 1;
            }
        };
        if (!Lifecycle.RUNNING.equals(this.getAttribute(SERVICE_STATE_ACTUAL))) {
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, (Sensor)NGINX_URL_ANSWERS_NICELY, (Object)"No response from nginx yet");
        }
        this.enrichers().add(((Enrichers.UpdatingMapBuilder)((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).uniqueTag("not-up-unless-url-answers")).from(NGINX_URL_ANSWERS_NICELY).computing((Function)Functionals.ifNotEquals((Object)true).value((Object)"URL where nginx listens is not answering correctly (with expected header)"))).build());
        this.connectServiceUpIsRunning();
        Group urlMappings = (Group)this.getConfig(URL_MAPPINGS);
        if (urlMappings != null && this.urlMappingsMemberTrackerPolicy == null) {
            this.targetAddressesHandler = this.subscriptions().subscribeToMembers(urlMappings, UrlMapping.TARGET_ADDRESSES, (SensorEventListener)new SensorEventListener<Collection<String>>(){

                public void onEvent(SensorEvent<Collection<String>> event) {
                    NginxControllerImpl.this.updateNeeded();
                }
            });
            this.urlMappingsMemberTrackerPolicy = (UrlMappingsMemberTrackerPolicy)this.policies().add((PolicySpec)PolicySpec.create(UrlMappingsMemberTrackerPolicy.class).configure((CharSequence)"group", (Object)urlMappings));
        }
    }

    protected void removeUrlMappingsMemberTrackerPolicy() {
        Group urlMappings;
        if (this.urlMappingsMemberTrackerPolicy != null) {
            this.policies().remove((Policy)this.urlMappingsMemberTrackerPolicy);
            this.urlMappingsMemberTrackerPolicy = null;
        }
        if ((urlMappings = (Group)this.getConfig(URL_MAPPINGS)) != null && this.targetAddressesHandler != null) {
            this.subscriptions().unsubscribe((Entity)urlMappings, this.targetAddressesHandler);
            this.targetAddressesHandler = null;
        }
    }

    @Override
    protected void preStop() {
        super.preStop();
        this.removeUrlMappingsMemberTrackerPolicy();
    }

    protected void postStop() {
        super.postStop();
        this.sensors().set(SERVICE_UP, (Object)false);
    }

    protected void disconnectSensors() {
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    public Class<?> getDriverInterface() {
        return NginxDriver.class;
    }

    public NginxDriver getDriver() {
        return (NginxDriver)super.getDriver();
    }

    @Override
    public void doExtraConfigurationDuringStart() {
        this.computePortsAndUrls();
        this.reconfigureService();
        this.connectSensors();
    }

    @Override
    @Effector(description="Gets the current server configuration (by brooklyn recalculating what the config should be); does not affect the server")
    public String getCurrentConfiguration() {
        return this.getConfigFile();
    }

    @Override
    @Effector(description="Deploys an archive of static content to the server")
    public void deploy(String archiveUrl) {
        NginxSshDriver driver = (NginxSshDriver)this.getDriver();
        if (driver == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No driver for {}, so not deploying archive (is entity stopping? state={})", (Object)this, this.getAttribute(NginxController.SERVICE_STATE_ACTUAL));
            }
            return;
        }
        ArchiveUtils.deploy((String)archiveUrl, (SshMachineLocation)driver.getMachine(), (String)driver.getRunDir());
    }

    @Override
    public void reconfigureService() {
        NginxSshDriver driver;
        String cfg = this.getConfigFile();
        if (cfg == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reconfiguring {}, targetting {} and {}", new Object[]{this, this.getServerPoolAddresses(), this.getUrlMappings()});
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reconfiguring {}, config file:\n{}", (Object)this, (Object)cfg);
        }
        if (!(driver = (NginxSshDriver)this.getDriver()).isCustomizationCompleted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reconfiguring {}, but driver's customization not yet complete so aborting", (Object)this);
            }
            return;
        }
        driver.getMachine().copyTo(Streams.newInputStreamWithContents((String)cfg), driver.getRunDir() + "/conf/server.conf");
        this.installSslKeys("global", this.getSslConfig());
        for (UrlMapping mapping : this.getUrlMappings()) {
            this.installSslKeys(mapping.getDomain(), (ProxySslConfig)mapping.getConfig(UrlMapping.SSL_CONFIG));
        }
    }

    public void installSslKeys(String id, ProxySslConfig ssl) {
        if (ssl == null) {
            return;
        }
        if (this.installedKeysCache.contains(id)) {
            return;
        }
        NginxSshDriver driver = (NginxSshDriver)this.getDriver();
        if (!Strings.isEmpty((CharSequence)ssl.getCertificateSourceUrl())) {
            String certificateDestination = Strings.isEmpty((CharSequence)ssl.getCertificateDestination()) ? driver.getRunDir() + "/conf/" + id + ".crt" : ssl.getCertificateDestination();
            driver.getMachine().copyTo((Map)ImmutableMap.of((Object)"permissions", (Object)"0600"), ResourceUtils.create((Object)this).getResourceFromUrl(ssl.getCertificateSourceUrl()), certificateDestination);
        }
        if (!Strings.isEmpty((CharSequence)ssl.getKeySourceUrl())) {
            String keyDestination = Strings.isEmpty((CharSequence)ssl.getKeyDestination()) ? driver.getRunDir() + "/conf/" + id + ".key" : ssl.getKeyDestination();
            driver.getMachine().copyTo((Map)ImmutableMap.of((Object)"permissions", (Object)"0600"), ResourceUtils.create((Object)this).getResourceFromUrl(ssl.getKeySourceUrl()), keyDestination);
        }
        this.installedKeysCache.add(id);
    }

    @Override
    public String getConfigFile() {
        NginxSshDriver driver = (NginxSshDriver)this.getDriver();
        if (driver == null) {
            LOG.debug("No driver for {}, so not generating config file (is entity stopping? state={})", (Object)this, this.getAttribute(NginxController.SERVICE_STATE_ACTUAL));
            return null;
        }
        NginxConfigFileGenerator templateGenerator = (NginxConfigFileGenerator)this.getConfig(NginxController.SERVER_CONF_GENERATOR);
        return templateGenerator.generateConfigFile(driver, this);
    }

    @Override
    public Iterable<UrlMapping> getUrlMappings() {
        Group urlMappingGroup = (Group)this.getConfig(NginxController.URL_MAPPINGS);
        if (urlMappingGroup != null) {
            return Iterables.filter((Iterable)urlMappingGroup.getMembers(), UrlMapping.class);
        }
        return Collections.emptyList();
    }

    public String getShortName() {
        return "Nginx";
    }

    @Override
    public boolean appendSslConfig(String id, StringBuilder out, String prefix, ProxySslConfig ssl, boolean sslBlock, boolean certificateBlock) {
        if (ssl == null) {
            return false;
        }
        if (sslBlock) {
            out.append(prefix);
            out.append("ssl on;\n");
        }
        if (ssl.getReuseSessions()) {
            out.append(prefix);
            out.append("proxy_ssl_session_reuse on;");
        }
        if (certificateBlock) {
            String cert = Strings.isEmpty((CharSequence)ssl.getCertificateDestination()) ? "" + id + ".crt" : ssl.getCertificateDestination();
            out.append(prefix);
            out.append("ssl_certificate " + cert + ";\n");
            String key = !Strings.isEmpty((CharSequence)ssl.getKeyDestination()) ? ssl.getKeyDestination() : (!Strings.isEmpty((CharSequence)ssl.getKeySourceUrl()) ? "" + id + ".key" : null);
            if (key != null) {
                out.append(prefix);
                out.append("ssl_certificate_key " + key + ";\n");
            }
        }
        return true;
    }

    public static class UrlMappingsMemberTrackerPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity entity) {
            this.defaultHighlightAction(type, entity);
            ((NginxControllerImpl)this.entity).updateNeeded();
        }
    }

    private class UrlInferencer
    implements Supplier<URI> {
        private Map<String, String> parameters;

        private UrlInferencer(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        public URI get() {
            String baseUrl = NginxControllerImpl.this.inferUrl(true);
            if (this.parameters == null || this.parameters.isEmpty()) {
                return URI.create(baseUrl);
            }
            return URI.create(baseUrl + "?" + HttpTool.encodeUrlParams(this.parameters));
        }
    }
}

