/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class DeleteTagsOptions
extends BaseHttpRequestOptions {
    public static final DeleteTagsOptions NONE = new DeleteTagsOptions();

    public DeleteTagsOptions resourceIds(Set<String> resourceIds) {
        this.queryParameters.replaceValues((Object)"resourceids", (Iterable)ImmutableSet.of((Object)Joiner.on((String)",").join(resourceIds)));
        return this;
    }

    public DeleteTagsOptions resourceIds(String ... resourceIds) {
        this.queryParameters.replaceValues((Object)"resourceids", (Iterable)ImmutableSet.of((Object)Joiner.on((String)",").join((Object[])resourceIds)));
        return this;
    }

    public DeleteTagsOptions resourceType(String resourceType) {
        this.queryParameters.replaceValues((Object)"resourcetype", (Iterable)ImmutableSet.of((Object)resourceType));
        return this;
    }

    public DeleteTagsOptions resourceType(Tag.ResourceType resourceType) {
        this.queryParameters.replaceValues((Object)"resourcetype", (Iterable)ImmutableSet.of((Object)resourceType.toString()));
        return this;
    }

    public DeleteTagsOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues((Object)String.format("tags[%d].key", count), (Iterable)ImmutableSet.of((Object)entry.getKey()));
            this.queryParameters.replaceValues((Object)String.format("tags[%d].value", count), (Iterable)ImmutableSet.of((Object)entry.getValue()));
            ++count;
        }
        return this;
    }

    public static class Builder {
        public static DeleteTagsOptions resourceIds(Set<String> resourceIds) {
            DeleteTagsOptions options = new DeleteTagsOptions();
            return options.resourceIds(resourceIds);
        }

        public static DeleteTagsOptions resourceIds(String ... resourceIds) {
            DeleteTagsOptions options = new DeleteTagsOptions();
            return options.resourceIds(resourceIds);
        }

        public static DeleteTagsOptions resourceType(String resourceType) {
            DeleteTagsOptions options = new DeleteTagsOptions();
            return options.resourceType(resourceType);
        }

        public static DeleteTagsOptions resourceType(Tag.ResourceType resourceType) {
            DeleteTagsOptions options = new DeleteTagsOptions();
            return options.resourceType(resourceType);
        }

        public static DeleteTagsOptions tags(Map<String, String> tags) {
            DeleteTagsOptions options = new DeleteTagsOptions();
            return options.tags(tags);
        }
    }
}

