/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.rebind.RebindContext;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.Memento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.relations.RelationshipType;
import org.apache.brooklyn.core.entity.EntityRelations;
import org.apache.brooklyn.core.mgmt.rebind.dto.MementosGenerators;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrooklynObjectRebindSupport<T extends Memento>
implements RebindSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBrooklynObjectRebindSupport.class);
    private final AbstractBrooklynObject instance;

    public AbstractBrooklynObjectRebindSupport(AbstractBrooklynObject instance) {
        this.instance = instance;
    }

    public T getMemento() {
        Memento memento = MementosGenerators.newBasicMemento(this.instance);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created memento: {}", (Object)memento.toVerboseString());
        }
        return (T)memento;
    }

    public void reconstruct(RebindContext rebindContext, T memento) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reconstructing: {}", (Object)memento.toVerboseString());
        }
        this.instance.setDisplayName(memento.getDisplayName());
        this.addConfig(rebindContext, memento);
        this.addTags(rebindContext, memento);
        this.addRelations(rebindContext, memento);
        this.addCustoms(rebindContext, memento);
        this.doReconstruct(rebindContext, memento);
        if (!rebindContext.isReadOnly((BrooklynObject)this.instance)) {
            this.instanceRebind(this.instance);
        }
    }

    protected abstract void addConfig(RebindContext var1, T var2);

    protected abstract void addCustoms(RebindContext var1, T var2);

    protected void addTags(RebindContext rebindContext, T memento) {
        if (this.instance instanceof EntityAdjunct && Strings.isNonBlank((CharSequence)memento.getUniqueTag())) {
            ((AbstractEntityAdjunct.AdjunctTagSupport)this.instance.tags()).setUniqueTag(memento.getUniqueTag());
        }
        for (Object tag : memento.getTags()) {
            this.instance.tags().addTag(tag);
        }
    }

    protected void addRelations(RebindContext rebindContext, T memento) {
        for (Map.Entry rEntry : memento.getRelations().entrySet()) {
            RelationshipType<BrooklynObject, BrooklynObject> r = EntityRelations.lookup(this.instance.getManagementContext(), (String)rEntry.getKey());
            if (r == null) {
                throw new IllegalStateException("Unsupported relationship -- " + (String)rEntry.getKey() + " -- in " + memento);
            }
            for (String itemId : (Set)rEntry.getValue()) {
                BrooklynObject item = rebindContext.lookup().lookup(null, itemId);
                if (item != null) {
                    this.instance.relations().add(r, item);
                    continue;
                }
                LOG.warn("Item not found; discarding item {} relation {} of entity {}({})", new Object[]{itemId, r, memento.getType(), memento.getId()});
                rebindContext.getExceptionHandler().onDanglingUntypedItemRef(itemId);
            }
        }
    }

    protected void instanceRebind(AbstractBrooklynObject instance) {
        instance.rebind();
    }

    public void addPolicies(RebindContext rebindContext, T Memento2) {
        throw new UnsupportedOperationException();
    }

    public void addEnrichers(RebindContext rebindContext, T Memento2) {
        throw new UnsupportedOperationException();
    }

    public void addFeeds(RebindContext rebindContext, T Memento2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void doReconstruct(RebindContext rebindContext, T memento) {
    }
}

