/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.rest;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.server.RestApiSetup;
import org.apache.brooklyn.camp.server.rest.util.DtoFactory;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampServer {
    private static final Logger log = LoggerFactory.getLogger(CampServer.class);
    public static final String CAMP_PLATFORM_ATTRIBUTE = CampPlatform.class.getCanonicalName();
    public static final String DTO_FACTORY = DtoFactory.class.getCanonicalName();
    private final CampPlatform platform;
    private final String uriBase;
    private DtoFactory dtoFactory;
    WebAppContext webAppContext;
    Server server;

    public CampServer(CampPlatform platform, String uriBase) {
        this.platform = platform;
        this.uriBase = uriBase;
    }

    public CampPlatform getPlatform() {
        return this.platform;
    }

    public String getUriBase() {
        return this.uriBase;
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public synchronized DtoFactory getDtoFactory() {
        if (this.dtoFactory != null) {
            return this.dtoFactory;
        }
        this.dtoFactory = this.createDtoFactory();
        return this.dtoFactory;
    }

    protected DtoFactory createDtoFactory() {
        return new DtoFactory(this.getPlatform(), this.getUriBase());
    }

    public synchronized CampServer start() {
        if (this.webAppContext != null) {
            throw new IllegalStateException("Already started");
        }
        this.webAppContext = new WebAppContext();
        this.webAppContext.setContextPath("/");
        this.webAppContext.setAttribute(CAMP_PLATFORM_ATTRIBUTE, (Object)this.getPlatform());
        this.webAppContext.setAttribute(DTO_FACTORY, (Object)this.getDtoFactory());
        this.webAppContext.setWar(CampServerUtils.createTempWebDirWithIndexHtml("CAMP REST API <p> (no gui available - rest endpoint at <a href=\"/camp/v11\">/camp/v11</a>)"));
        CampServerUtils.installAsServletFilter((ServletContextHandler)this.webAppContext);
        this.server = CampServerUtils.startServer((ContextHandler)this.webAppContext, "CAMP server");
        return this;
    }

    public synchronized void stop() {
        try {
            this.server.stop();
            this.server = null;
            this.webAppContext.stop();
            this.webAppContext = null;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Integer getPort() {
        if (this.server == null) {
            return null;
        }
        NetworkConnector networkConnector = (NetworkConnector)this.server.getConnectors()[0];
        return networkConnector.getLocalPort();
    }

    public static class CampServerUtils {
        public static void installAsServletFilter(ServletContextHandler context) {
            RestApiSetup.install(context);
        }

        public static Server startServer(ContextHandler context, String summary) {
            int port = Networking.nextAvailablePort((int)8080);
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName("camp-jetty-server-" + port + "-" + threadPool.getName());
            Server server = new Server((ThreadPool)threadPool);
            ServerConnector httpConnector = new ServerConnector(server);
            httpConnector.setPort(port);
            server.addConnector((Connector)httpConnector);
            server.setHandler((Handler)context);
            try {
                server.start();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
            log.info("CAMP REST server started (" + summary + ") on");
            log.info("  http://localhost:" + httpConnector.getLocalPort() + "/");
            return server;
        }

        public static String createTempWebDirWithIndexHtml(String indexHtmlContent) {
            File dir = Files.createTempDir();
            dir.deleteOnExit();
            try {
                Files.write((CharSequence)indexHtmlContent, (File)new File(dir, "index.html"), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                Exceptions.propagate((Throwable)e);
            }
            return dir.getAbsolutePath();
        }
    }
}

