/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.features;

import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.b2.domain.Bucket;
import org.jclouds.b2.domain.BucketList;
import org.jclouds.b2.domain.BucketType;
import org.jclouds.b2.filters.RequestAuthorization;
import org.jclouds.blobstore.attr.BlobScope;
import org.jclouds.blobstore.attr.BlobScopes;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={RequestAuthorization.class})
@BlobScope(value=BlobScopes.CONTAINER)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface BucketApi {
    @Named(value="b2_create_bucket")
    @POST
    @Path(value="/b2api/v1/b2_create_bucket")
    @MapBinder(value=BindToJsonPayload.class)
    @PayloadParams(keys={"accountId"}, values={"{jclouds.identity}"})
    public Bucket createBucket(@PayloadParam(value="bucketName") String var1, @PayloadParam(value="bucketType") BucketType var2);

    @Named(value="b2_delete_bucket")
    @POST
    @Path(value="/b2api/v1/b2_delete_bucket")
    @MapBinder(value=BindToJsonPayload.class)
    @PayloadParams(keys={"accountId"}, values={"{jclouds.identity}"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Bucket deleteBucket(@PayloadParam(value="bucketId") String var1);

    @Named(value="b2_update_bucket")
    @POST
    @Path(value="/b2api/v1/b2_update_bucket")
    @MapBinder(value=BindToJsonPayload.class)
    @PayloadParams(keys={"accountId"}, values={"{jclouds.identity}"})
    public Bucket updateBucket(@PayloadParam(value="bucketId") String var1, @PayloadParam(value="bucketType") BucketType var2);

    @Named(value="b2_list_buckets")
    @POST
    @Path(value="/b2api/v1/b2_list_buckets")
    @MapBinder(value=BindToJsonPayload.class)
    @PayloadParams(keys={"accountId"}, values={"{jclouds.identity}"})
    public BucketList listBuckets();
}

