/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.internal.PaginatedCollection;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.functions.BaseToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.Json;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Path(value="/actions")
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface ActionApi
extends Closeable {
    @Named(value="action:list")
    @GET
    @ResponseParser(value=ParseActions.class)
    @Transform(value=ParseActions.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Action> list();

    @Named(value="action:list")
    @GET
    @ResponseParser(value=ParseActions.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Action> list(ListOptions var1);

    @Named(value="action:get")
    @GET
    @SelectJson(value={"action"})
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Action get(@PathParam(value="id") int var1);

    public static final class ParseActions
    extends ParseJson<Actions> {
        @Inject
        ParseActions(Json json) {
            super(json, TypeLiteral.get(Actions.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Action, ListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Action> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.actionApi().list(options);
            }
        }

        private static class Actions
        extends PaginatedCollection<Action> {
            @ConstructorProperties(value={"actions", "meta", "links"})
            public Actions(List<Action> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }
    }
}

