/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.rest.testing.mocks;

import org.apache.brooklyn.api.objs.HighlightTuple;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestMockSimplePolicy extends AbstractPolicy {

    @SuppressWarnings("unused")
    private static final Logger log = LoggerFactory.getLogger(RestMockSimplePolicy.class);

    public RestMockSimplePolicy() {
        super();
        this.setHighlight("testNameTask",  new HighlightTuple("testDescription", 123L, "testTaskId"));
        this.setHighlight("testNameNoTask",  new HighlightTuple("testDescription", 123L, null));
    }

    @SetFromFlag("sampleConfig")
    public static final ConfigKey<String> SAMPLE_CONFIG = BasicConfigKey.builder(String.class)
            .name("brooklyn.rest.mock.sample.config")
            .description("Mock sample config")
            .defaultValue("DEFAULT_VALUE")
            .reconfigurable(true)
            .build();

    @SetFromFlag
    public static final ConfigKey<Integer> INTEGER_CONFIG = BasicConfigKey.builder(Integer.class)
            .name("brooklyn.rest.mock.sample.integer")
            .description("Mock integer config")
            .defaultValue(1)
            .reconfigurable(true)
            .build();

    @Override
    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        // no-op
    }
}
