/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.logbook.opensearch;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.minidev.json.JSONObject;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.logbook.BrooklynLogEntry;
import org.apache.brooklyn.util.core.logbook.LogBookQueryParams;
import org.apache.brooklyn.util.core.logbook.LogStore;
import org.apache.brooklyn.util.core.logbook.LogbookConfig;
import org.apache.brooklyn.util.core.logbook.opensearch.BrooklynOpenSearchModel;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class OpenSearchLogStore
implements LogStore {
    public static final String BASE_NAME_OPEN_SEARCH_LOG_STORE = "brooklyn.logbook.openSearchLogStore";
    public static final ConfigKey<String> LOGBOOK_LOG_STORE_HOST = ConfigKeys.newStringConfigKey("brooklyn.logbook.openSearchLogStore.host", "Log store host");
    public static final ConfigKey<String> LOGBOOK_LOG_STORE_INDEX = ConfigKeys.newStringConfigKey("brooklyn.logbook.openSearchLogStore.index", "Log store index");
    public static final ConfigKey<String> LOGBOOK_LOG_STORE_USER = ConfigKeys.newStringConfigKey("brooklyn.logbook.openSearchLogStore.user", "User name");
    public static final ConfigKey<String> LOGBOOK_LOG_STORE_PASS = ConfigKeys.newStringConfigKey("brooklyn.logbook.openSearchLogStore.password", "User password");
    public static final ConfigKey<String> LOGBOOK_LOG_STORE_APIKEY = ConfigKeys.newStringConfigKey("brooklyn.logbook.openSearchLogStore.apikey", "API key");
    public static final ConfigKey<Boolean> LOGBOOK_LOG_STORE_VERIFY_SSL = ConfigKeys.newBooleanConfigKey("brooklyn.logbook.openSearchLogStore.verifySsl", "Verify SSL", true);
    private final ManagementContext mgmt;
    CloseableHttpClient httpClient;
    private String host;
    private String user;
    private String password;
    private String apiKey;
    private Boolean verifySsl;
    private String indexName;
    private Integer maxTasks;

    @VisibleForTesting
    public OpenSearchLogStore() {
        this.mgmt = null;
        this.maxTasks = (Integer)LogbookConfig.LOGBOOK_MAX_RECURSIVE_TASKS.getDefaultValue();
    }

    public OpenSearchLogStore(ManagementContext mgmt) {
        this.mgmt = mgmt;
        this.initialize();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (!this.verifySsl.booleanValue()) {
            try {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
                NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
                SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                Exceptions.propagate((Throwable)e);
            }
        }
        if (Strings.isNonBlank((CharSequence)this.apiKey)) {
            httpClientBuilder.setDefaultHeaders((Collection)ImmutableList.of((Object)new BasicHeader("Authorization", "ApiKey " + this.apiKey)));
        } else {
            httpClientBuilder.setDefaultCredentialsProvider(this.buildBasicCredentialsProvider());
        }
        this.httpClient = httpClientBuilder.build();
    }

    private CredentialsProvider buildBasicCredentialsProvider() {
        URL url;
        try {
            url = new URL(this.host);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The provided host OpenSearch host URL is not valid: " + this.host);
        }
        HttpHost httpHost = new HttpHost(url.getHost(), url.getPort());
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        return provider;
    }

    private void initialize() {
        this.maxTasks = (Integer)this.mgmt.getConfig().getConfig(LogbookConfig.LOGBOOK_MAX_RECURSIVE_TASKS);
        this.host = (String)this.mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_HOST);
        Preconditions.checkNotNull((Object)this.host, (Object)("OpenSearch host must be set: " + LOGBOOK_LOG_STORE_HOST.getName()));
        this.user = (String)this.mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_USER);
        this.indexName = (String)this.mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_INDEX);
        this.password = (String)this.mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_PASS);
        this.apiKey = (String)this.mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_APIKEY);
        this.verifySsl = (Boolean)this.mgmt.getConfig().getConfig(LOGBOOK_LOG_STORE_VERIFY_SSL);
    }

    @Override
    public List<BrooklynLogEntry> query(LogBookQueryParams params) throws IOException {
        HttpPost request = new HttpPost(this.host + "/" + this.indexName + "/_search");
        request.addHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(this.getJsonQuery(params)));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            BrooklynOpenSearchModel jsonResponse = (BrooklynOpenSearchModel)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(response.getEntity().getContent(), BrooklynOpenSearchModel.class);
            if (jsonResponse.hits != null && jsonResponse.hits.hits != null) {
                List<BrooklynLogEntry> brooklynLogEntries = jsonResponse.hits.hits.stream().map(openSearchHit -> {
                    BrooklynLogEntry entry = openSearchHit.getSource();
                    entry.setLineId(openSearchHit.getId());
                    return entry;
                }).collect(Collectors.toList());
                if (params.isTail().booleanValue()) {
                    Collections.reverse(brooklynLogEntries);
                }
                List<BrooklynLogEntry> list = brooklynLogEntries;
                return list;
            }
            ImmutableList immutableList = ImmutableList.of();
            return immutableList;
        }
    }

    @Override
    public Set<String> enumerateTaskIds(Set<?> parents, int maxTasks) {
        return LogStore.enumerateTaskIdsDefault(this.mgmt, parents, maxTasks);
    }

    @VisibleForTesting
    protected String getJsonQuery(LogBookQueryParams params) {
        ImmutableMap qb = ImmutableMap.builder().put((Object)"size", (Object)params.getNumberOfItems()).put((Object)"sort", (Object)ImmutableMap.of((Object)"timestamp", (Object)(params.isTail() != false ? "desc" : "asc"))).put((Object)"query", this.buildQuery(params)).build();
        return new JSONObject((Map)qb).toString();
    }

    private ImmutableMap<String, Object> buildQuery(LogBookQueryParams params) {
        ImmutableList queryBoolMustList;
        ImmutableList.Builder queryBoolMustListBuilder = ImmutableList.builder();
        if (!params.getLevels().isEmpty() && !params.getLevels().contains("ALL")) {
            queryBoolMustListBuilder.add((Object)ImmutableMap.of((Object)"terms", (Object)ImmutableMap.of((Object)"level", (Object)ImmutableList.copyOf((Collection)params.getLevels().stream().map(String::toLowerCase).map(String::trim).collect(Collectors.toList())))));
        }
        if (Strings.isNonBlank((CharSequence)params.getDateTimeFrom()) || Strings.isNonBlank((CharSequence)params.getDateTimeTo())) {
            ImmutableMap.Builder timestampMapBuilder = ImmutableMap.builder();
            if (Strings.isNonBlank((CharSequence)params.getDateTimeFrom())) {
                timestampMapBuilder.put((Object)"gte", (Object)params.getDateTimeFrom());
            }
            if (Strings.isNonBlank((CharSequence)params.getDateTimeTo())) {
                timestampMapBuilder.put((Object)"lte", (Object)params.getDateTimeTo());
            }
            queryBoolMustListBuilder.add((Object)ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)"timestamp", (Object)timestampMapBuilder.build())));
        }
        if (Strings.isNonBlank((CharSequence)params.getTaskId())) {
            MutableSet taskIds = MutableSet.of((Object)params.getTaskId());
            if (params.isRecursive().booleanValue() && this.mgmt != null) {
                Task parent = this.mgmt.getExecutionManager().getTask(params.getTaskId());
                BrooklynTaskTags.WorkflowTaskTag wf = BrooklynTaskTags.getWorkflowTaskTag(parent, false);
                String workflowId = wf != null ? wf.getWorkflowId() : null;
                taskIds.addAll(this.enumerateTaskIds((Set<?>)MutableSet.of().putIfNotNull((Object)parent).putIfNotNull((Object)workflowId), this.maxTasks));
            }
            queryBoolMustListBuilder.add((Object)ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"should", (Object)ImmutableList.of(params.isRecursive() != false ? this.buildMultiMatchOf("taskId", (Set<String>)taskIds) : this.buildMatchPhraseOf("taskId", params.getTaskId()), params.isRecursive() != false ? this.buildMultiMatchOf("message", (Set<String>)taskIds) : this.buildMatchPhraseOf("message", params.getTaskId())))));
        }
        if (Strings.isNonBlank((CharSequence)params.getEntityId())) {
            queryBoolMustListBuilder.add((Object)ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"should", (Object)ImmutableList.of(this.buildMatchPhraseOf("entityIds", params.getEntityId()), this.buildMatchPhraseOf("message", params.getEntityId())))));
        }
        if (Strings.isNonBlank((CharSequence)params.getSearchPhrase())) {
            queryBoolMustListBuilder.add(this.buildMatchPhraseOf("message", params.getSearchPhrase()));
        }
        if ((queryBoolMustList = queryBoolMustListBuilder.build()).isEmpty()) {
            return ImmutableMap.of((Object)"match_all", (Object)ImmutableMap.of());
        }
        MutableMap query = MutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", (Object)queryBoolMustList));
        return ImmutableMap.copyOf((Map)query);
    }

    private ImmutableMap<String, ImmutableMap<String, String>> buildMatchPhraseOf(String field, String searchPhrase) {
        return ImmutableMap.of((Object)"match_phrase", (Object)ImmutableMap.of((Object)field, (Object)searchPhrase));
    }

    private ImmutableMap<String, ImmutableMap<String, ImmutableMap<String, String>>> buildMultiMatchOf(String field, Set<String> searchPhrases) {
        return ImmutableMap.of((Object)"match", (Object)ImmutableMap.of((Object)field, (Object)ImmutableMap.of((Object)"query", (Object)Joiner.on((String)" ").join(searchPhrases), (Object)"analyzer", (Object)"whitespace", (Object)"operator", (Object)"or")));
    }
}

