/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.PathTrackingWriter;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.brooklyn.util.core.xstream.XmlSerializer;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeThrowableConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(SafeThrowableConverter.class);
    private final DefaultConverterLookup converterLookup;
    private final Predicate<Class> supportedTypes;
    ThreadLocal<Object> converting = new ThreadLocal();
    @VisibleForTesting
    public static int TODO = 0;

    public SafeThrowableConverter(Predicate<Class> supportedTypes, DefaultConverterLookup converterLookup) {
        this.supportedTypes = supportedTypes;
        this.converterLookup = converterLookup;
    }

    public boolean canConvert(Class type) {
        return this.converting.get() == null && this.supportedTypes.test(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        boolean wrappedHere = false;
        int depth = -1;
        HierarchicalStreamWriter w2 = writer;
        try {
            if (this.converting.get() != null) {
                wrappedHere = false;
            } else {
                wrappedHere = true;
                this.converting.set(source);
                this.converterLookup.flushCache();
                while (w2 instanceof PathTrackingWriter) {
                    w2 = w2.underlyingWriter();
                }
                if (w2 instanceof XmlSerializer.PrettyPrintWriterExposingStack) {
                    depth = ((XmlSerializer.PrettyPrintWriterExposingStack)w2).path.depth();
                }
            }
            try {
                context.convertAnother(source);
                return;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (depth < 0) {
                    throw Exceptions.propagate((Throwable)e);
                }
                log.debug("Unable to convert " + source + "; will abandon keys that aren't valid: " + e);
                while (((XmlSerializer.PrettyPrintWriterExposingStack)w2).path.depth() > depth) {
                    writer.endNode();
                    writer.flush();
                    try {
                        ((XmlSerializer.PrettyPrintWriterExposingStack)w2).getOrigWriter().write("<!-- fields omitted in previous node due to error -->");
                    }
                    catch (IOException ex) {
                        throw Exceptions.propagate((Throwable)ex);
                        return;
                    }
                }
            }
        }
        finally {
            if (wrappedHere) {
                this.converting.set(null);
                this.converterLookup.flushCache();
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        this.converting.set("not for use with unmarshalling");
        this.converterLookup.flushCache();
        return context.convertAnother(null, context.getRequiredType());
    }
}

