/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.location.AbstractLocationResolver;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.location.byon.FixedListMachineProvisioningLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.JcloudsPropertiesFromBrooklynProperties;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.WildcardGlobs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsByonLocationResolver
extends AbstractLocationResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(JcloudsByonLocationResolver.class);
    public static final String BYON = "jcloudsByon";

    public boolean isEnabled() {
        return LocationConfigUtils.isResolverPrefixEnabled((ManagementContext)this.managementContext, (String)this.getPrefix());
    }

    public String getPrefix() {
        return BYON;
    }

    protected Class<? extends Location> getLocationType() {
        return FixedListMachineProvisioningLocation.class;
    }

    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"jcloudsByon(provider='aws-ec2',region='us-east-1',hosts='i-12345678,i-90123456')\"");
    }

    protected Map<String, Object> getFilteredLocationProperties(String provider, String namedLocation, Map<String, ?> prioritisedProperties, Map<String, ?> globalProperties) {
        String providerOrApi = (String)prioritisedProperties.get("provider");
        String regionName = (String)prioritisedProperties.get("region");
        return new JcloudsPropertiesFromBrooklynProperties().getJcloudsProperties(providerOrApi, regionName, namedLocation, globalProperties);
    }

    protected ConfigBag extractConfig(Map<?, ?> locationFlags, String spec, LocationRegistry registry) {
        Object hostIds;
        ConfigBag config = super.extractConfig(locationFlags, spec, registry);
        String providerOrApi = (String)config.getStringKey("provider");
        String regionName = (String)config.getStringKey("region");
        String endpoint = (String)config.getStringKey("endpoint");
        config.remove(LocationInternal.NAMED_SPEC_NAME.getName());
        Object hosts = config.getStringKey("hosts");
        config.remove("hosts");
        if (Strings.isEmpty((CharSequence)providerOrApi)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; provider must be defined");
        }
        if (hosts == null || hosts instanceof String && Strings.isBlank((CharSequence)((String)hosts))) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; at least one host must be defined");
        }
        String jcloudsSpec = "jclouds:" + providerOrApi + (regionName != null ? ":" + regionName : "") + (endpoint != null ? ":" + endpoint : "");
        final Maybe jcloudsLocationSpec = registry.getLocationSpec(jcloudsSpec, config.getAllConfig());
        if (jcloudsLocationSpec.isAbsentOrNull()) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; referrenced jclouds spec '" + jcloudsSpec + "' cannot be resolved");
        }
        if (!JcloudsLocation.class.isAssignableFrom(((LocationSpec)jcloudsLocationSpec.get()).getType())) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; referrenced spec '" + jcloudsSpec + "' of type " + ((LocationSpec)jcloudsLocationSpec.get()).getType() + " rather than JcloudsLocation");
        }
        if (hosts instanceof String) {
            hostIds = ((String)hosts).isEmpty() ? ImmutableList.of() : WildcardGlobs.getGlobsAfterBraceExpansion((String)("{" + hosts + "}"), (boolean)true, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR);
        } else if (hosts instanceof Iterable) {
            hostIds = ImmutableList.copyOf((Iterable)((Iterable)hosts));
        } else {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; at least one host must be defined");
        }
        if (hostIds.isEmpty()) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; at least one host must be defined");
        }
        final ArrayList machinesFlags = Lists.newArrayList();
        for (Object hostId : hostIds) {
            Map<?, ?> machineFlags;
            if (hostId instanceof String) {
                machineFlags = this.parseMachineFlags((String)hostId, config);
            } else if (hostId instanceof Map) {
                machineFlags = this.parseMachineFlags((Map)hostId, config);
            } else {
                throw new IllegalArgumentException("Invalid host type '" + (hostId == null ? null : hostId.getClass().getName()) + ", referrenced in spec '" + spec);
            }
            machinesFlags.add(machineFlags);
        }
        Supplier<List<JcloudsMachineLocation>> machinesFactory = new Supplier<List<JcloudsMachineLocation>>(){

            public List<JcloudsMachineLocation> get() {
                ArrayList result = Lists.newArrayList();
                JcloudsLocation jcloudsLocation = (JcloudsLocation)JcloudsByonLocationResolver.this.managementContext.getLocationManager().createLocation((LocationSpec)jcloudsLocationSpec.get());
                for (Map machineFlags : machinesFlags) {
                    try {
                        jcloudsLocation.config().putAll(machineFlags);
                        JcloudsMachineLocation machine = jcloudsLocation.registerMachine((Map<?, ?>)ImmutableMap.of());
                        result.add(machine);
                    }
                    catch (NoMachinesAvailableException e) {
                        Map sanitizedMachineFlags = Sanitizer.sanitize((Map)machineFlags);
                        log.warn("Error rebinding to jclouds machine " + sanitizedMachineFlags + " in " + jcloudsLocation, (Throwable)e);
                        Exceptions.propagate((Throwable)e);
                    }
                }
                log.debug("Created machines for jclouds BYON location: " + result);
                return result;
            }
        };
        config.put(FixedListMachineProvisioningLocation.INITIAL_MACHINES_FACTORY, (Object)machinesFactory);
        return config;
    }

    protected Map<?, ?> parseMachineFlags(Map<String, ?> vals, ConfigBag config) {
        if (!(vals.get("id") instanceof String) || Strings.isBlank((CharSequence)((String)vals.get("id")))) {
            Map valSanitized = Sanitizer.sanitize(vals);
            throw new IllegalArgumentException("In jcloudsByon, machine " + valSanitized + " is missing String 'id'");
        }
        return MutableMap.builder().putAll(config.getAllConfig()).putAll(vals).build();
    }

    protected Map<?, ?> parseMachineFlags(String hostIdentifier, ConfigBag config) {
        return MutableMap.builder().putAll(config.getAllConfig()).put((Object)"id", (Object)hostIdentifier).build();
    }
}

