/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.location;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.config.ConfigKey;

public class LocationSpec<T extends Location>
extends AbstractBrooklynObjectSpec<T, LocationSpec<T>> {
    private static final long serialVersionUID = 1L;
    private Location parent;
    private final Map<Class<?>, Object> extensions = Maps.newLinkedHashMap();

    public static <T extends Location> LocationSpec<T> create(Class<T> type) {
        return new LocationSpec<T>(type);
    }

    public static <T extends Location> LocationSpec<T> create(Map<?, ?> config, Class<T> type) {
        return (LocationSpec)LocationSpec.create(type).configure(config);
    }

    public static <T extends Location> LocationSpec<T> create(LocationSpec<T> spec) {
        Class exactType = spec.getType();
        return LocationSpec.create(exactType).copyFrom(spec);
    }

    protected LocationSpec(Class<T> type) {
        super(type);
    }

    @Override
    protected LocationSpec<T> copyFrom(LocationSpec<T> otherSpec) {
        LocationSpec<T> result = super.copyFrom(otherSpec).extensions(otherSpec.getExtensions());
        if (otherSpec.getParent() != null) {
            result.parent(otherSpec.getParent());
        }
        return result;
    }

    @Override
    protected void checkValidType(Class<? extends T> type) {
        this.checkIsImplementation(type, Location.class);
        this.checkIsNewStyleImplementation(type);
    }

    public LocationSpec<T> parent(Location val) {
        this.parent = (Location)Preconditions.checkNotNull((Object)val, (Object)"parent");
        return this;
    }

    public <E> LocationSpec<T> extension(Class<E> extensionType, E extension) {
        this.extensions.put((Class<?>)Preconditions.checkNotNull(extensionType, (Object)"extensionType"), Preconditions.checkNotNull(extension, (Object)"extension"));
        return this;
    }

    public <E> LocationSpec<T> extensions(Map<Class<?>, ?> extensions) {
        for (Map.Entry<Class<?>, ?> entry : extensions.entrySet()) {
            this.extension(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Location getParent() {
        return this.parent;
    }

    @Override
    public Map<String, ?> getFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    @Override
    public Map<ConfigKey<?>, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public Map<Class<?>, Object> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }
}

