/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.components.jaspi.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.geronimo.components.jaspi.model.ClientAuthConfigType;
import org.apache.geronimo.components.jaspi.model.ServerAuthConfigType;
import org.apache.geronimo.components.jaspi.model.StringMapAdapter;

@XmlRootElement(name="configProvider", namespace="http://geronimo.apache.org/xml/ns/geronimo-jaspi")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="configProviderType", propOrder={"messageLayer", "appContext", "description", "className", "properties", "clientAuthConfig", "serverAuthConfig", "persistent", "classLoaderName"})
public class ConfigProviderType
implements Serializable {
    private static final long serialVersionUID = 12343L;
    protected String messageLayer;
    protected String appContext;
    protected String description;
    protected String className;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=StringMapAdapter.class)
    protected Map<String, String> properties;
    private List<ClientAuthConfigType> clientAuthConfig;
    private List<ServerAuthConfigType> serverAuthConfig;
    protected Boolean persistent = Boolean.FALSE;
    protected String classLoaderName;

    public ConfigProviderType() {
    }

    public ConfigProviderType(String messageLayer, String appContext, boolean persistent, AuthConfigFactory authConfigFactory) {
        this.messageLayer = messageLayer;
        this.appContext = appContext;
        this.persistent = persistent;
    }

    public String getMessageLayer() {
        return this.messageLayer;
    }

    public void setMessageLayer(String value) {
        this.messageLayer = value;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public void setAppContext(String value) {
        this.appContext = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String value) {
        this.className = value;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> value) {
        this.properties = value;
    }

    public List<ClientAuthConfigType> getClientAuthConfig() {
        if (this.clientAuthConfig == null) {
            this.clientAuthConfig = new ArrayList<ClientAuthConfigType>();
        }
        return this.clientAuthConfig;
    }

    public List<ServerAuthConfigType> getServerAuthConfig() {
        if (this.serverAuthConfig == null) {
            this.serverAuthConfig = new ArrayList<ServerAuthConfigType>();
        }
        return this.serverAuthConfig;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean value) {
        this.persistent = value;
    }

    public String getClassLoaderName() {
        return this.classLoaderName;
    }

    public void setClassLoaderName(String classLoaderName) {
        this.classLoaderName = classLoaderName;
    }

    public static String getRegistrationKey(String layer, String appContext) {
        return layer + "/" + appContext;
    }

    public String getKey() {
        return ConfigProviderType.getRegistrationKey(this.getMessageLayer(), this.getAppContext());
    }
}

