/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.windows;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.feed.PollConfig;
import org.apache.brooklyn.core.sensor.AbstractAddTriggerableSensor;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshValueFunctions;
import org.apache.brooklyn.feed.windows.CmdFeed;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class WinRmCommandSensor<T>
extends AbstractAddTriggerableSensor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(WinRmCommandSensor.class);
    public static final ConfigKey<String> SENSOR_COMMAND = ConfigKeys.newStringConfigKey((String)"command", (String)"SSH command to execute for sensor");
    public static final ConfigKey<String> SENSOR_EXECUTION_DIR = ConfigKeys.newStringConfigKey((String)"executionDir", (String)"Directory where the command should run; if not supplied, executes in the entity's run dir (or home dir if no run dir is defined); use '~' to always execute in the home dir, or 'custom-feed/' to execute in a custom-feed dir relative to the run dir");
    public static final ConfigKey<Map<String, String>> SENSOR_ENVIRONMENT = WinRmTool.ENVIRONMENT;
    private String command;
    private String executionDir;
    private Map<String, String> sensorEnv;

    protected WinRmCommandSensor() {
    }

    public WinRmCommandSensor(ConfigBag params) {
        super(params);
    }

    public void apply(final EntityLocal entity) {
        final AttributeSensor sensor = this.addSensor(entity);
        String name = (String)this.initParam(SENSOR_NAME);
        final String command = (String)Preconditions.checkNotNull((Object)this.initParam(SENSOR_COMMAND), (Object)"SSH command must be supplied when defining this sensor");
        final String executionDir = (String)this.initParam(SENSOR_EXECUTION_DIR);
        final Map sensorEnv = (Map)this.initParam(SENSOR_ENVIRONMENT);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding WinRM sensor {} to {}", (Object)name, (Object)entity);
        }
        Supplier<Map<String, String>> envSupplier = new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                Object env = MutableMap.copyOf((Map)((Map)entity.getConfig(SENSOR_ENVIRONMENT)));
                if (sensorEnv != null) {
                    env.putAll(sensorEnv);
                }
                try {
                    env = (Map)Tasks.resolveDeepValueCoerced((Object)env, (TypeToken)new TypeToken<Map<String, String>>(){}, (ExecutionContext)((EntityInternal)entity).getExecutionContext(), (String)"WinRM environment");
                }
                catch (InterruptedException | ExecutionException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
                ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(((EntityInternal)entity).getManagementContext());
                return serializer.serialize((Map)env);
            }
        };
        Supplier<String> commandSupplier = new Supplier<String>(){

            public String get() {
                return WinRmCommandSensor.makeCommandExecutingInDirectory(command, executionDir, (Entity)entity);
            }
        };
        CommandPollConfig pollConfig = (CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)new CommandPollConfig(sensor).period((Duration)this.initParam(SENSOR_PERIOD))).env((Supplier)envSupplier).command((Supplier)commandSupplier).checkSuccess(SshValueFunctions.exitStatusEquals((int)0))).onFailureOrException(Functions.constant(null))).onSuccess(Functions.compose((Function)new Function<String, T>(){

            public T apply(String input) {
                return TypeCoercions.coerce((Object)Strings.trimEnd((String)input), (Class)sensor.getType());
            }
        }, (Function)SshValueFunctions.stdout()));
        this.standardPollConfig((Entity)entity, this.initParams(), (PollConfig)pollConfig);
        CmdFeed feed = (CmdFeed)((CmdFeed.Builder)((CmdFeed.Builder)((CmdFeed.Builder)CmdFeed.builder().name("WinRM Sensor Feed: " + (String)this.initParam(SENSOR_NAME))).entity((Entity)entity)).onlyIfServiceUp((Boolean)Maybe.ofDisallowingNull((Object)EntityInitializers.resolve((ConfigBag)this.initParams(), (ConfigKey)ONLY_IF_SERVICE_UP)).or((Object)true))).poll(pollConfig).build();
        entity.addFeed((Feed)feed);
    }

    @Beta
    public static String makeCommandExecutingInDirectory(String command, String executionDir, Entity entity) {
        String finalCommand = command;
        String execDir = executionDir;
        if (Strings.isNonBlank((CharSequence)execDir) && !"~".equals(execDir)) {
            finalCommand = "(if exist \"" + execDir + "\" (rundll32) else (mkdir \"" + execDir + "\")) && cd \"" + execDir + "\" && " + finalCommand;
        }
        return finalCommand;
    }

    protected Object readResolve() {
        super.readResolve();
        this.initFromConfigBag(ConfigBag.newInstance().putIfAbsentAndNotNull(SENSOR_COMMAND, (Object)this.command).putIfAbsentAndNotNull(SENSOR_EXECUTION_DIR, (Object)this.executionDir).putIfAbsentAndNotNull(SENSOR_ENVIRONMENT, this.sensorEnv));
        this.command = null;
        this.executionDir = null;
        this.sensorEnv = null;
        return this;
    }
}

