/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class JDBCUtils {
    public static final String DATASOURCE = "datasource";
    public static final String JNDI = "jndi:";
    public static final String OSGI = "osgi:";

    private JDBCUtils() {
    }

    public static DataSource createDatasource(BundleContext bc, String url) throws Exception {
        Object ds = JDBCUtils.doCreateDatasource(bc, url);
        if (ds == null) {
            throw new Exception("Unable to create datasource for " + url);
        }
        return (DataSource)DataSource.class.cast(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object doCreateDatasource(BundleContext bc, String url) throws Exception {
        String string = url = url != null ? url.trim() : null;
        if (url == null || url.isEmpty()) {
            throw new Exception("Illegal datasource url format. Datasource URL cannot be null or empty.");
        }
        if (url.startsWith(JNDI)) {
            String jndiName = url.substring(JNDI.length());
            URI uri = new URI(jndiName);
            String scheme = uri.getScheme();
            if (scheme == null || scheme.equals("java")) {
                throw new Exception("Unsupported JNDI URI: " + jndiName);
            }
            try (InitialContext ic = new InitialContext();){
                Object object = ic.lookup(jndiName);
                return object;
            }
        }
        if (url.startsWith(OSGI)) {
            ServiceReference[] references;
            String osgiFilter = url.substring(OSGI.length());
            String clazz = null;
            String filter = null;
            String[] tokens = osgiFilter.split("/", 2);
            if (tokens.length > 0) {
                clazz = tokens[0];
            }
            if (tokens.length > 1) {
                filter = tokens[1];
            }
            if ((references = bc.getServiceReferences(clazz, filter)) != null) {
                ServiceReference ref = references[0];
                Object ds = bc.getService(ref);
                bc.ungetService(ref);
                return ds;
            }
            throw new Exception("Unable to find service reference for datasource: " + clazz + "/" + filter);
        }
        throw new Exception("Illegal datasource url format " + url);
    }

    protected static int rawUpdate(DataSource dataSource, String query, String ... params) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            int n;
            block14: {
                PreparedStatement statement = connection.prepareStatement(query);
                try {
                    for (int i = 0; i < params.length; ++i) {
                        statement.setString(i + 1, params[i]);
                    }
                    int res = statement.executeUpdate();
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                    n = res;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
    }

    protected static int rawUpdate(Connection connection, String query, String ... params) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, params[i]);
            }
            int n = statement.executeUpdate();
            return n;
        }
    }

    protected static List<String> rawSelect(DataSource dataSource, String query, String ... params) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            List<String> list = JDBCUtils.rawSelect(connection, query, params);
            return list;
        }
    }

    protected static List<String> rawSelect(Connection connection, String query, String ... params) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        try (PreparedStatement statement = connection.prepareStatement(query);){
            for (int i = 0; i < params.length; ++i) {
                statement.setString(i + 1, params[i]);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    results.add(resultSet.getString(1));
                }
            }
        }
        return results;
    }
}

