/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.riak;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.List;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.java.UsesJava;
import org.apache.brooklyn.entity.nosql.riak.RiakNodeImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="Riak Node", description="Riak is a distributed NoSQL key-value data store that offers extremely high availability, fault tolerance, operational simplicity and scalability.")
@ImplementedBy(value=RiakNodeImpl.class)
public interface RiakNode
extends SoftwareProcess,
UsesJava {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (String)"Version to install (Default 2.0.5)", (Object)"2.0.5");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"riak-%s");
    @SetFromFlag(value="optimizeNetworking")
    public static final ConfigKey<Boolean> OPTIMIZE_HOST_NETWORKING = ConfigKeys.newBooleanConfigKey((String)"riak.networking.optimize", (String)"Optimize host networking when running in a VM", (Boolean)Boolean.TRUE);
    @SetFromFlag(value="vmArgsTemplateUrl")
    public static final ConfigKey<String> RIAK_VM_ARGS_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"riak.vmArgs.templateUrl", (String)"Template file (in freemarker format) for the vm.args config file", (String)"classpath://org/apache/brooklyn/entity/nosql/riak/vm.args");
    @SetFromFlag(value="appConfigTemplateUrl")
    public static final ConfigKey<String> RIAK_APP_CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"riak.appConfig.templateUrl", (String)"Template file (in freemarker format) for the app.config config file", (String)"classpath://org/apache/brooklyn/entity/nosql/riak/app.config");
    @SetFromFlag(value="appConfigTemplateUrlLinux")
    public static final ConfigKey<String> RIAK_CONF_TEMPLATE_URL_LINUX = ConfigKeys.newStringConfigKey((String)"riak.riakConf.templateUrl.linux", (String)"Template file (in freemarker format) for the app.config config file", (String)"classpath://org/apache/brooklyn/entity/nosql/riak/riak.conf");
    @SetFromFlag(value="appConfigTemplateUrlMac")
    public static final ConfigKey<String> RIAK_CONF_TEMPLATE_URL_MAC = ConfigKeys.newStringConfigKey((String)"riak.riakConf.templateUrl.mac", (String)"Template file (in freemarker format) for the app.config config file", (String)"classpath://org/apache/brooklyn/entity/nosql/riak/riak-mac.conf");
    public static final ConfigKey<String> RIAK_CONF_ADDITIONAL_CONTENT = ConfigKeys.newStringConfigKey((String)"riak.riakConf.additionalContent", (String)"Template file (in freemarker format) for setting up additional settings in the riak.conf file", (String)"");
    @SetFromFlag(value="maxOpenFiles")
    public static final ConfigKey<Integer> RIAK_MAX_OPEN_FILES = ConfigKeys.newIntegerConfigKey((String)"riak.max.open.files", (String)"Number of the open files required by Riak", (Integer)65536);
    @SetFromFlag(value="downloadUrlRhelCentos")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL_RHEL_CENTOS = ConfigKeys.newTemplateSensorAndConfigKey((String)"download.url.rhelcentos", (String)"URL pattern for downloading the linux RPM installer (will substitute things like ${version} automatically)", (String)"http://s3.amazonaws.com/downloads.basho.com/riak/${entity.majorVersion}/${entity.fullVersion}/rhel/${entity.osMajorVersion}/riak-${entity.fullVersion}-1.el${entity.osMajorVersion}.x86_64.rpm");
    @SetFromFlag(value="downloadUrlUbuntu")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL_UBUNTU = ConfigKeys.newTemplateSensorAndConfigKey((String)"download.url.ubuntu", (String)"URL pattern for downloading the linux Ubuntu installer (will substitute things like ${version} automatically)", (String)"http://s3.amazonaws.com/downloads.basho.com/riak/${entity.majorVersion}/${entity.fullVersion}/ubuntu/$OS_RELEASE/riak_${entity.fullVersion}-1_amd64.deb");
    @SetFromFlag(value="downloadUrlDebian")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL_DEBIAN = ConfigKeys.newTemplateSensorAndConfigKey((String)"download.url.debian", (String)"URL pattern for downloading the linux Debian installer (will substitute things like ${version} automatically)", (String)"http://s3.amazonaws.com/downloads.basho.com/riak/${entity.majorVersion}/${entity.fullVersion}/debian/$OS_RELEASE/riak_${entity.fullVersion}-1_amd64.deb");
    @SetFromFlag(value="downloadUrlMac")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL_MAC = ConfigKeys.newTemplateSensorAndConfigKey((String)"download.url.mac", (String)"URL pattern for downloading the MAC binaries tarball (will substitute things like ${version} automatically)", (String)"http://s3.amazonaws.com/downloads.basho.com/riak/${entity.majorVersion}/${entity.fullVersion}/osx/10.8/riak-${entity.fullVersion}-OSX-x86_64.tar.gz");
    @SetFromFlag(value="riakWebPort")
    public static final PortAttributeSensorAndConfigKey RIAK_WEB_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"riak.webPort", (String)"Riak Web Port", (Object)"8098+");
    @SetFromFlag(value="riakPbPort")
    public static final PortAttributeSensorAndConfigKey RIAK_PB_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"riak.pbPort", (String)"Riak Protocol Buffers Port", (Object)"8087+");
    @SetFromFlag(value="useHttpMonitoring")
    public static final ConfigKey<Boolean> USE_HTTP_MONITORING = ConfigKeys.newConfigKey((String)"httpMonitoring.enabled", (String)"HTTP(S) monitoring enabled", (Object)Boolean.TRUE);
    public static final AttributeSensor<Boolean> RIAK_PACKAGE_INSTALL = Sensors.newBooleanSensor((String)"riak.install.package", (String)"Flag to indicate whether Riak was installed using an OS package");
    public static final AttributeSensor<Boolean> RIAK_ON_PATH = Sensors.newBooleanSensor((String)"riak.install.onPath", (String)"Flag to indicate whether Riak is available on the PATH");
    public static final AttributeSensor<Boolean> RIAK_NODE_HAS_JOINED_CLUSTER = Sensors.newBooleanSensor((String)"riak.node.riakNodeHasJoinedCluster", (String)"Flag to indicate whether the Riak node has joined a cluster member");
    public static final AttributeSensor<String> RIAK_NODE_NAME = Sensors.newStringSensor((String)"riak.node", (String)"Returns the riak node name as defined in vm.args");
    @SetFromFlag(value="handoffListenerPort")
    public static final AttributeSensorAndConfigKey<Integer, Integer> HANDOFF_LISTENER_PORT = ConfigKeys.newIntegerSensorAndConfigKey((String)"riak.handoff.port", (String)"Handoff Listener Port", (Integer)8099);
    @SetFromFlag(value="epmdListenerPort")
    public static final AttributeSensorAndConfigKey<Integer, Integer> EPMD_LISTENER_PORT = ConfigKeys.newIntegerSensorAndConfigKey((String)"riak.epmd.port", (String)"Erlang Port Mapper Daemon Listener Port", (Integer)4369);
    @SetFromFlag(value="erlangPortRangeStart")
    public static final AttributeSensorAndConfigKey<Integer, Integer> ERLANG_PORT_RANGE_START = ConfigKeys.newIntegerSensorAndConfigKey((String)"riak.erlang.portrange.start", (String)"Erlang Port Range Start", (Integer)6000);
    @SetFromFlag(value="erlangPortRangeEnd")
    public static final AttributeSensorAndConfigKey<Integer, Integer> ERLANG_PORT_RANGE_END = ConfigKeys.newIntegerSensorAndConfigKey((String)"riak.erlang.portrange.end", (String)"Erlang Port Range End", (Integer)7999);
    @SetFromFlag(value="configInternalNetworking")
    public static final ConfigKey<Boolean> CONFIGURE_INTERNAL_NETWORKING = ConfigKeys.newBooleanConfigKey((String)"riak.networking.internal", (String)"Set up internal networking for intra-node communication", (Boolean)Boolean.TRUE);
    @SetFromFlag(value="searchEnabled")
    public static final ConfigKey<Boolean> SEARCH_ENABLED = ConfigKeys.newBooleanConfigKey((String)"riak.search", (String)"Deploy Solr and configure Riak to use it", (Boolean)Boolean.FALSE);
    public static final ConfigKey<Integer> SEARCH_SOLR_PORT = ConfigKeys.newIntegerConfigKey((String)"search.solr.port", (String)"Solr port", (Integer)8983);
    public static final ConfigKey<Integer> SEARCH_SOLR_JMX_PORT = ConfigKeys.newIntegerConfigKey((String)"search.solr.jmx_port", (String)"Solr port", (Integer)8985);
    public static final AttributeSensor<Integer> NODE_GETS = Sensors.newIntegerSensor((String)"riak.node.gets", (String)"Gets in the last minute");
    public static final AttributeSensor<Integer> NODE_GETS_TOTAL = Sensors.newIntegerSensor((String)"riak.node.gets.total", (String)"Total gets since node started");
    public static final AttributeSensor<Integer> NODE_PUTS = Sensors.newIntegerSensor((String)"riak.node.puts", (String)"Puts in the last minute");
    public static final AttributeSensor<Integer> NODE_PUTS_TOTAL = Sensors.newIntegerSensor((String)"riak.node.puts.total", (String)"Total puts since node started");
    public static final AttributeSensor<Integer> VNODE_GETS = Sensors.newIntegerSensor((String)"riak.vnode.gets");
    public static final AttributeSensor<Integer> VNODE_GETS_TOTAL = Sensors.newIntegerSensor((String)"riak.vnode.gets.total");
    public static final AttributeSensor<Integer> VNODE_PUTS = Sensors.newIntegerSensor((String)"riak.vnode.puts");
    public static final AttributeSensor<Integer> VNODE_PUTS_TOTAL = Sensors.newIntegerSensor((String)"riak.vnode.puts.total");
    public static final AttributeSensor<Integer> READ_REPAIRS_TOTAL = Sensors.newIntegerSensor((String)"riak.read.repairs.total");
    public static final AttributeSensor<Integer> COORD_REDIRS_TOTAL = Sensors.newIntegerSensor((String)"riak.coord.redirs.total");
    public static final AttributeSensor<Integer> MEMORY_PROCESSES_USED = Sensors.newIntegerSensor((String)"riak.memory.processes.used");
    public static final AttributeSensor<Integer> SYS_PROCESS_COUNT = Sensors.newIntegerSensor((String)"riak.sys.process.count");
    public static final AttributeSensor<Integer> PBC_CONNECTS = Sensors.newIntegerSensor((String)"riak.pbc.connects");
    public static final AttributeSensor<Integer> PBC_ACTIVE = Sensors.newIntegerSensor((String)"riak.pbc.active");
    public static final AttributeSensor<List<String>> RING_MEMBERS = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"ring.members", (String)"all the riak nodes in the ring");
    public static final AttributeSensor<Integer> NODE_OPS = Sensors.newIntegerSensor((String)"riak.node.ops", (String)"Sum of node gets and puts in the last minute");
    public static final AttributeSensor<Integer> NODE_OPS_TOTAL = Sensors.newIntegerSensor((String)"riak.node.ops.total", (String)"Sum of node gets and puts since the node started");
    public static final MethodEffector<Void> JOIN_RIAK_CLUSTER = new MethodEffector(RiakNode.class, "joinCluster");
    public static final MethodEffector<Void> LEAVE_RIAK_CLUSTER = new MethodEffector(RiakNode.class, "leaveCluster");
    public static final MethodEffector<Void> REMOVE_FROM_CLUSTER = new MethodEffector(RiakNode.class, "removeNode");
    public static final AttributeSensor<Integer> RIAK_NODE_GET_FSM_TIME_MEAN = Sensors.newIntegerSensor((String)"riak.node_get_fsm_time_mean", (String)"Time between reception of client read request and subsequent response to client");
    public static final AttributeSensor<Integer> RIAK_NODE_PUT_FSM_TIME_MEAN = Sensors.newIntegerSensor((String)"riak.node_put_fsm_time_mean", (String)"Time between reception of client write request and subsequent response to client");
    public static final AttributeSensor<Integer> RIAK_OBJECT_COUNTER_MERGE_TIME_MEAN = Sensors.newIntegerSensor((String)"riak.object_counter_merge_time_mean", (String)"Time it takes to perform an Update Counter operation");
    public static final AttributeSensor<Integer> RIAK_OBJECT_SET_MERGE_TIME_MEAN = Sensors.newIntegerSensor((String)"riak.object_set_merge_time_mean", (String)"Time it takes to perform an Update Set operation");
    public static final AttributeSensor<Integer> RIAK_OBJECT_MAP_MERGE_TIME_MEAN = Sensors.newIntegerSensor((String)"riak.object_map_merge_time_mean", (String)"Time it takes to perform an Update Map operation");
    public static final AttributeSensor<Integer> RIAK_CONSISTENT_GET_TIME_MEAN = Sensors.newIntegerSensor((String)"riak.consistent_get_time_mean", (String)"Strongly consistent read latency");
    public static final AttributeSensor<Integer> RIAK_CONSISTENT_PUT_TIME_MEAN = Sensors.newIntegerSensor((String)"riak.consistent_put_time_mean", (String)"Strongly consistent write latency");
    public static final List<AttributeSensor<Integer>> ONE_MINUTE_SENSORS = ImmutableList.of(RIAK_NODE_GET_FSM_TIME_MEAN, RIAK_NODE_PUT_FSM_TIME_MEAN, RIAK_OBJECT_COUNTER_MERGE_TIME_MEAN, RIAK_OBJECT_SET_MERGE_TIME_MEAN, RIAK_OBJECT_MAP_MERGE_TIME_MEAN, RIAK_CONSISTENT_GET_TIME_MEAN, RIAK_CONSISTENT_PUT_TIME_MEAN);
    public static final AttributeSensor<URI> RIAK_CONSOLE_URI = Attributes.MAIN_URI;

    public Integer getRiakWebPort();

    public Integer getRiakPbPort();

    public Integer getHandoffListenerPort();

    public Integer getEpmdListenerPort();

    public Integer getErlangPortRangeStart();

    public Integer getErlangPortRangeEnd();

    public Boolean isSearchEnabled();

    public Integer getSearchSolrPort();

    public Integer getSearchSolrJmxPort();

    public String getFullVersion();

    public String getMajorVersion();

    public String getOsMajorVersion();

    @Effector(description="Join the Riak cluster on the given node")
    public void joinCluster(@EffectorParam(name="nodeName") String var1);

    @Effector(description="Leave the Riak cluster")
    public void leaveCluster();

    @Effector(description="Remove the given node from the Riak cluster")
    public void removeNode(@EffectorParam(name="nodeName") String var1);

    @Effector(description="Recover and join the Riak cluster on the given node")
    public void recoverFailedNode(@EffectorParam(name="nodeName") String var1);

    @Effector(description="Create or modify a bucket type before activation")
    public void bucketTypeCreate(@EffectorParam(name="bucketTypeName") String var1, @EffectorParam(name="bucketTypeProperties") String var2);

    @Effector(description="List all currently available bucket types and their activation status")
    public List<String> bucketTypeList();

    @Effector(description="Display the status and properties of a specific bucket type")
    public List<String> bucketTypeStatus(@EffectorParam(name="bucketTypeName") String var1);

    @Effector(description="Update a bucket type after activation")
    public void bucketTypeUpdate(@EffectorParam(name="bucketTypeName") String var1, @EffectorParam(name="bucketTypeProperties") String var2);

    @Effector(description="Activate a bucket type")
    public void bucketTypeActivate(@EffectorParam(name="bucketTypeName") String var1);
}

