/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.functions;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.openstack.keystone.auth.config.CredentialType;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.auth.domain.TenantOrDomainAndCredentials;
import org.jclouds.openstack.keystone.auth.functions.BaseAuthenticator;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityAuthenticationApi;
import org.jclouds.rackspace.cloudidentity.v2_0.domain.ApiKeyCredentials;

@CredentialType(value="RAX-KSKEY:apiKeyCredentials")
@Singleton
public class AuthenticateApiKeyCredentials
extends BaseAuthenticator<ApiKeyCredentials> {
    protected final CloudIdentityAuthenticationApi api;

    @Inject
    AuthenticateApiKeyCredentials(CloudIdentityAuthenticationApi api) {
        this.api = api;
    }

    public ApiKeyCredentials createCredentials(String identity, String credential) {
        return ApiKeyCredentials.createWithUsernameAndApiKey(identity, credential);
    }

    public String toString() {
        return "authenticateApiKeyCredentials()";
    }

    public AuthInfo authenticate(TenantOrDomainAndCredentials<ApiKeyCredentials> credentials) {
        return this.api.authenticateApiKey(credentials);
    }
}

