/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.external.vault;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.external.AbstractExternalConfigSupplier;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.javalang.BrooklynHttpConfig;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VaultExternalConfigSupplier
extends AbstractExternalConfigSupplier {
    public static final String CHARSET_NAME = "UTF-8";
    public static final ImmutableMap<String, String> MINIMAL_HEADERS = ImmutableMap.of((Object)"Content-Type", (Object)"application/json; charset=UTF-8", (Object)"Accept", (Object)"application/json", (Object)"Accept-Charset", (Object)"UTF-8");
    private static final Logger LOG = LoggerFactory.getLogger(VaultExternalConfigSupplier.class);
    protected final Map<String, String> config;
    protected final String name;
    protected final HttpClient httpClient;
    protected final Gson gson;
    protected final String endpoint;
    protected final String path;
    protected final String mountPoint;
    protected final int version;
    protected final int recoverTryCount;
    protected final String token;
    protected final ImmutableMap<String, String> headersWithToken;

    public VaultExternalConfigSupplier(ManagementContext managementContext, String name, Map<String, String> config) {
        super(managementContext, name);
        String version;
        this.config = config;
        this.name = name;
        this.httpClient = BrooklynHttpConfig.httpClientBuilder(managementContext, true).build();
        this.gson = new GsonBuilder().create();
        ArrayList errors = Lists.newArrayListWithCapacity((int)2);
        this.endpoint = config.get("endpoint");
        if (Strings.isBlank((CharSequence)this.endpoint)) {
            errors.add("missing configuration 'endpoint'");
        }
        this.path = config.get("path");
        if (Strings.isBlank((CharSequence)this.path)) {
            errors.add("missing configuration 'path'");
        }
        if (Strings.isBlank((CharSequence)(version = config.get("kv-api-version"))) || "1".equals(version)) {
            this.version = 1;
        } else if ("2".equals(version)) {
            this.version = 2;
        } else {
            this.version = -1;
            errors.add("'kv-api-version' must be either 1 or 2");
        }
        this.recoverTryCount = NumberUtils.toInt((String)config.get("recoverTryCount"), (int)10);
        this.mountPoint = config.get("mountPoint");
        if (Strings.isBlank((CharSequence)this.mountPoint) && this.version == 2) {
            errors.add("missing configuration 'mountPoint'");
        }
        if (!Strings.isBlank((CharSequence)this.mountPoint) && this.version == 1) {
            errors.add("'mountPoint' is only applicable when kv-api-version=2");
        }
        if (!errors.isEmpty()) {
            String message = String.format("Problem configuration Vault external config supplier '%s': %s", name, Joiner.on((String)System.lineSeparator()).join((Iterable)errors));
            throw new IllegalArgumentException(message);
        }
        this.token = this.initAndLogIn(config);
        if (Strings.isBlank((CharSequence)this.token)) {
            LOG.warn("Vault token blank. Startup will continue but vault might not be available. Recover attempt will be made on next vault access.");
        }
        this.headersWithToken = ImmutableMap.builder().putAll(MINIMAL_HEADERS).put((Object)"X-Vault-Token", (Object)this.token).build();
    }

    protected abstract String initAndLogIn(Map<String, String> var1);

    @Override
    public String get(String key) {
        String urlPath = this.version == 1 ? Urls.mergePaths((String[])new String[]{"v1", this.path}) : Urls.mergePaths((String[])new String[]{"v1", this.mountPoint, "data", this.path});
        JsonObject response = this.apiGetRetryable(urlPath, (Map<String, String>)this.headersWithToken, this.recoverTryCount);
        JsonElement jsonElement = this.version == 1 ? response.getAsJsonObject("data").get(key) : response.getAsJsonObject("data").getAsJsonObject("data").get(key);
        String asString = jsonElement.getAsString();
        return asString;
    }

    public Map<String, String> getDataAsStringMap() {
        JsonObject response = this.apiGetRetryable(Urls.mergePaths((String[])new String[]{"v1", this.path}), (Map<String, String>)this.headersWithToken, this.recoverTryCount);
        Map<String, JsonElement> dataMap = response.getAsJsonObject("data").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Maps.transformValues(dataMap, jsonElement -> jsonElement.getAsString());
    }

    protected JsonObject apiGetRetryable(String path, Map<String, String> headers, int recoverTryCount) {
        try {
            if (Strings.isBlank((CharSequence)headers.get("X-Vault-Token"))) {
                String currentToken = this.initAndLogIn(this.config);
                if (Strings.isBlank((CharSequence)currentToken)) {
                    throw new IllegalStateException("Vault sealed or unavailable.");
                }
                headers = MutableMap.copyOf(headers).add((Object)"X-Vault-Token", (Object)currentToken);
            }
            return this.apiGet(path, (Map<String, String>)headers);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (recoverTryCount > 0) {
                LOG.warn("Vault sealed or unavailable. Retries remaining: " + recoverTryCount);
                Time.sleep((Duration)Duration.ONE_SECOND);
                String currentToken = this.initAndLogIn(this.config);
                headers = MutableMap.copyOf((Map)headers).add((Object)"X-Vault-Token", (Object)currentToken);
                return this.apiGetRetryable(path, (Map<String, String>)headers, --recoverTryCount);
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected JsonObject apiGet(String path, Map<String, String> headers) {
        try {
            String uri = Urls.mergePaths((String[])new String[]{this.endpoint, path});
            LOG.trace("Vault request - GET: {}", (Object)uri);
            HttpToolResponse response = HttpTool.httpGet((HttpClient)this.httpClient, (URI)Urls.toUri((String)uri), headers);
            LOG.trace("Vault response - code: {} {}", (Object)response.getResponseCode(), (Object)response.getReasonPhrase());
            String responseBody = new String(response.getContent(), CHARSET_NAME);
            if (HttpTool.isStatusCodeHealthy((int)response.getResponseCode())) {
                return (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
            }
            throw new IllegalStateException("HTTP request returned code: " + response.getResponseCode() + " - " + responseBody);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected JsonObject apiPost(String path, ImmutableMap<String, String> headers, ImmutableMap<String, String> requestData) {
        try {
            String body = this.gson.toJson(requestData);
            String uri = Urls.mergePaths((String[])new String[]{this.endpoint, path});
            LOG.trace("Vault request - POST: {}", (Object)uri);
            HttpToolResponse response = HttpTool.httpPost((HttpClient)this.httpClient, (URI)Urls.toUri((String)uri), headers, (byte[])body.getBytes(CHARSET_NAME));
            LOG.trace("Vault response - code: {} {}", (Object)response.getResponseCode(), (Object)response.getReasonPhrase());
            String responseBody = new String(response.getContent(), CHARSET_NAME);
            if (HttpTool.isStatusCodeHealthy((int)response.getResponseCode())) {
                return (JsonObject)this.gson.fromJson(responseBody, JsonObject.class);
            }
            throw new IllegalStateException("HTTP request returned code: " + response.getResponseCode() + " - " + responseBody);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

