/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.objs.BasicConfigurableObject;
import org.apache.brooklyn.core.resolve.jackson.JsonPassThroughDeserializer;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ConfigKeySelfExtracting;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;

public class EntityInitializers {
    public static EntityInitializer addingTags(Object ... tags) {
        return new AddTags(tags);
    }

    public static <T> T resolve(ConfigBag configBag, ConfigKey<T> key) {
        return EntityInitializers.resolve(configBag, key, BasicExecutionContext.getCurrentExecutionContext());
    }

    public static <T> T resolve(ConfigBag configBag, ConfigKey<T> key, ExecutionContext executionContext) {
        if (key instanceof ConfigKeySelfExtracting && executionContext != null) {
            ConfigKeySelfExtracting ckse = (ConfigKeySelfExtracting)key;
            Object result = ckse.extractValue(configBag.getAllConfigAsConfigKeyMap(), executionContext);
            return (T)(result != null || configBag.containsKey(key.getName()) ? result : key.getDefaultValue());
        }
        return configBag.get(key);
    }

    public static abstract class InitializerPatternForConfigurable
    extends BasicConfigurableObject
    implements EntityInitializer {
        protected InitializerPatternForConfigurable() {
        }

        protected InitializerPatternForConfigurable(ConfigBag params) {
            this.initFromConfigBag(params);
        }

        protected void initFromConfigBag(ConfigBag params) {
            if (params != null) {
                params.forEach((k, v) -> this.config().set(ConfigKeys.newConfigKey(Object.class, k), v));
            }
        }

        @JsonAnySetter
        private void initField(String key, Object value) {
            this.config().set(ConfigKeys.newConfigKey(Object.class, key), value);
            this.initFromConfigBag(ConfigBag.newInstance(MutableMap.of((Object)key, (Object)value)));
        }

        @JsonProperty(value="brooklyn.config")
        private void initBrooklynConfig(Map<String, Object> params) {
            this.initFromConfigBag(ConfigBag.newInstance(params));
        }
    }

    private static abstract class InitializerPatternHandlingConfigNeatlyOnSerializeAndDeserialize
    implements EntityInitializer,
    Serializable {
        @JsonIgnore
        private ConfigBag initParams = ConfigBag.newInstance();

        protected InitializerPatternHandlingConfigNeatlyOnSerializeAndDeserialize() {
        }

        protected InitializerPatternHandlingConfigNeatlyOnSerializeAndDeserialize(ConfigBag params) {
            this.initFromConfigBag(params);
        }

        protected void initFromConfigBag(ConfigBag params) {
            if (params != null && !params.isEmpty()) {
                this.initParams.putAll(params);
            }
        }

        ConfigBag initParams() {
            return this.initParams;
        }

        @JsonAnySetter
        @JsonDeserialize(contentUsing=JsonPassThroughDeserializer.class)
        protected void initField(String key, Object value) {
            this.initFromConfigBag(ConfigBag.newInstance(MutableMap.of((Object)key, (Object)value)));
        }

        @JsonProperty(value="brooklyn.config")
        @JsonDeserialize(contentUsing=JsonPassThroughDeserializer.class)
        private void initBrooklynConfig(Map<String, Object> params) {
            this.initFromConfigBag(ConfigBag.newInstance(params));
        }

        protected Object readResolve() {
            if (this.initParams == null) {
                this.initParams = ConfigBag.newInstance();
            }
            return this;
        }
    }

    public static abstract class InitializerPatternWithConfigKeys
    extends InitializerPatternHandlingConfigNeatlyOnSerializeAndDeserialize {
        protected InitializerPatternWithConfigKeys() {
        }

        protected InitializerPatternWithConfigKeys(ConfigBag params) {
            super(params);
        }

        protected <T> T initParam(ConfigKey<T> key) {
            return this.initParams().get(key);
        }

        @Override
        protected ConfigBag initParams() {
            return super.initParams();
        }

        @JsonProperty(value="brooklyn.config")
        protected Map<String, Object> getBrooklynConfig() {
            return this.initParams().getAllConfig();
        }
    }

    public static abstract class InitializerPatternWithFieldsFromConfigKeys
    extends InitializerPatternHandlingConfigNeatlyOnSerializeAndDeserialize {
        @JsonIgnore
        private List<BiConsumer<ConfigBag, Boolean>> configKeyInitRules = MutableList.of();

        protected InitializerPatternWithFieldsFromConfigKeys() {
        }

        protected InitializerPatternWithFieldsFromConfigKeys(ConfigBag params) {
            super(params);
        }

        protected <T> void addInitConfigMapping(ConfigKey<T> key, Function<T, T> setter) {
            this.addInitConfigRule((config, isFirst) -> config.ifPresent(key).transformNow(setter).or(() -> {
                if (isFirst.booleanValue() && key.hasDefaultValue()) {
                    setter.apply(key.getDefaultValue());
                }
                return null;
            }));
        }

        protected <T> void addInitConfigRule(BiConsumer<ConfigBag, Boolean> rule) {
            this.configKeyInitRules.add(rule);
            rule.accept(this.initParams(), true);
        }

        @Override
        protected void initFromConfigBag(ConfigBag params) {
            if (this.configKeyInitRules != null) {
                this.configKeyInitRules.forEach(c -> c.accept(params, false));
            }
            super.initFromConfigBag(params);
        }

        protected void initParamsFailIfAnyUnused() {
            if (!this.initParams().getUnusedConfig().isEmpty()) {
                throw new IllegalArgumentException("Unused parameters in " + this + ": " + this.initParams().getUnusedConfig());
            }
        }
    }

    public static class AddTags
    implements EntityInitializer {
        public final List<Object> tags;

        public AddTags() {
            this.tags = null;
        }

        public AddTags(Object ... tags) {
            this.tags = ImmutableList.copyOf((Object[])tags);
        }

        public void apply(EntityLocal entity) {
            if (this.tags == null) {
                throw new IllegalStateException("Initializer needs to be configured with the tags to add");
            }
            for (Object tag : this.tags) {
                entity.tags().addTag(tag);
            }
        }
    }
}

