/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs.proxy;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.proxy.SpecialBrooklynObjectConstructor;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InternalFactory.class);
    protected final ManagementContextInternal managementContext;

    public static boolean isNewStyle(Class<?> clazz) {
        try {
            clazz.getDeclaredConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public InternalFactory(ManagementContextInternal managementContext) {
        this.managementContext = (ManagementContextInternal)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    protected <T> T construct(Class<? extends T> clazz, AbstractBrooklynObjectSpec<?, ?> optionalSpec, Map<String, ?> optionalOldStyleConstructorFlags) {
        try {
            ConfigBag bag;
            Class<? extends SpecialBrooklynObjectConstructor> special;
            if (optionalSpec != null && (special = (bag = ConfigBag.newInstance(optionalSpec.getConfig())).get(SpecialBrooklynObjectConstructor.Config.SPECIAL_CONSTRUCTOR)) != null) {
                return this.constructWithSpecial(special, clazz, optionalSpec);
            }
            if (InternalFactory.isNewStyle(clazz)) {
                return this.constructNewStyle(clazz);
            }
            MutableMap constructorFlags = MutableMap.of();
            if (optionalOldStyleConstructorFlags != null) {
                constructorFlags.add(optionalOldStyleConstructorFlags);
            } else {
                constructorFlags.add(optionalSpec.getFlags());
            }
            return this.constructOldStyle(clazz, (Map<String, ?>)MutableMap.copyOf((Map)constructorFlags));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private <T> T constructWithSpecial(Class<? extends SpecialBrooklynObjectConstructor> special, Class<? extends T> clazz, AbstractBrooklynObjectSpec<?, ?> spec) {
        try {
            return special.newInstance().create(this.managementContext, clazz, spec);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw Exceptions.propagateAnnotated((String)("Unable to create " + clazz + " " + spec + " using special " + special), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T constructNewStyle(Class<T> clazz) {
        if (!InternalFactory.isNewStyle(clazz)) {
            throw new IllegalStateException("Class " + clazz + " must have a no-arg constructor");
        }
        try {
            FactoryConstructionTracker.setConstructing();
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (!(Modifier.isPublic(clazz.getModifiers()) && Modifier.isPublic(constructor.getModifiers()) || constructor.isAccessible())) {
                    try {
                        constructor.setAccessible(true);
                        LOG.warn("Set no-arg constructor accessible for " + clazz + " (deprecated; should have public no-arg constructor)");
                    }
                    catch (SecurityException e) {
                        LOG.warn("Unable to set no-arg constructor accessible for " + clazz + " (continuing, but may subsequently fail): " + e);
                    }
                }
                T t = constructor.newInstance(new Object[0]);
                return t;
            }
            finally {
                FactoryConstructionTracker.reset();
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T constructOldStyle(Class<T> clazz, Map<String, ?> flags) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Maybe v;
        FactoryConstructionTracker.setConstructing();
        try {
            v = Reflections.invokeConstructorFromArgs(clazz, (Object[])new Object[]{MutableMap.copyOf(flags)}, (boolean)true);
        }
        finally {
            FactoryConstructionTracker.reset();
        }
        if (v.isPresent()) {
            return (T)v.get();
        }
        throw new IllegalStateException("No valid constructor defined for " + clazz + " (expected no-arg or single java.util.Map argument)");
    }

    public static class FactoryConstructionTracker {
        private static ThreadLocal<Boolean> constructing = new ThreadLocal();

        public static boolean isConstructing() {
            return constructing.get() == Boolean.TRUE;
        }

        static void reset() {
            constructing.set(Boolean.FALSE);
        }

        static void setConstructing() {
            constructing.set(Boolean.TRUE);
        }
    }
}

